/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.connector;

import java.io.Serializable;
import java.text.ParseException;

public class SocketAddress
implements Serializable {
    private final String address;
    private final String spec;
    private final String host;
    private final int port;
    private final String bind;

    public static SocketAddress valueOf(String address) throws ParseException {
        int port;
        if (address == null || address.trim().isEmpty()) {
            throw new ParseException("Address is empty.", 0);
        }
        int commercial = address.lastIndexOf(64);
        int colon = address.indexOf(58, commercial + 1);
        int colon2 = address.indexOf(58, colon + 1);
        if (colon < 0) {
            throw new ParseException("Port number is missing.", 0);
        }
        try {
            port = Integer.parseInt(address.substring(colon + 1, colon2 < 0 ? address.length() : colon2).trim());
            if (port <= 0 || port >= 65536) {
                throw new ParseException("Port number is out of range.", 0);
            }
        }
        catch (NumberFormatException e) {
            throw new ParseException("Port number is not an integer.", 0);
        }
        String spec = commercial < 0 ? null : SocketAddress.trim(address.substring(0, commercial));
        String host = SocketAddress.trim(address.substring(commercial + 1, colon));
        String bind = colon2 < 0 ? null : SocketAddress.trim(address.substring(colon2 + 1));
        return new SocketAddress(spec, host, port, bind);
    }

    public static String formatAddress(String spec, String host, int port) {
        return SocketAddress.formatAddress(spec, host, port, null);
    }

    public static String formatAddress(String spec, String host, int port, String bind) {
        spec = SocketAddress.trim(spec);
        host = SocketAddress.trim(host);
        bind = SocketAddress.trim(bind);
        return (spec.isEmpty() ? "" : spec + "@") + host + ":" + port + (bind.isEmpty() ? "" : ":" + bind);
    }

    private static String trim(String s) {
        return s == null || s.trim().isEmpty() ? "" : s.trim();
    }

    public SocketAddress(String spec, String host, int port) {
        this(spec, host, port, null);
    }

    public SocketAddress(String spec, String host, int port, String bind) {
        this.address = SocketAddress.formatAddress(spec, host, port, bind);
        this.spec = SocketAddress.trim(spec);
        this.host = SocketAddress.trim(host);
        this.port = port;
        this.bind = bind;
    }

    public String getAddress() {
        return this.address;
    }

    public String getSpec() {
        return this.spec;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getBind() {
        return this.bind;
    }

    public String toString() {
        return this.address;
    }

    public boolean equals(Object o) {
        return o instanceof SocketAddress && this.address.equals(((SocketAddress)o).address);
    }

    public int hashCode() {
        return this.address.hashCode();
    }
}

