/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.mars.common;

import com.devexperts.logging.Logging;
import com.devexperts.mars.common.MARSNode;
import com.devexperts.monitoring.Monitored;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class MARSMonitoredBean<T>
implements Runnable {
    private static final Logging log = Logging.getLogging(MARSMonitoredBean.class);
    private final List<Prop> props;
    private T instance;

    public static <T> MARSMonitoredBean<T> forInstance(MARSNode node, T instance) {
        ArrayList<Prop> props = new ArrayList<Prop>();
        MARSMonitoredBean.listProps(null, node, instance.getClass(), props);
        return new MARSMonitoredBean<T>(props, instance);
    }

    public static <T> MARSMonitoredBean<T> forClass(MARSNode node, Class<? extends T> beanClass) {
        ArrayList<Prop> props = new ArrayList<Prop>();
        MARSMonitoredBean.listProps(null, node, beanClass, props);
        return new MARSMonitoredBean<Object>(props, null);
    }

    @Override
    public synchronized void run() {
        for (Prop prop : this.props) {
            prop.update(this.instance);
        }
    }

    public synchronized void update(T instance) {
        this.instance = instance;
        this.run();
    }

    public synchronized void close() {
        for (Prop prop : this.props) {
            prop.node.remove();
            prop.lastValue = null;
        }
        this.props.clear();
        this.instance = null;
    }

    public MARSMonitoredBean(List<Prop> props, T instance) {
        this.props = props;
        this.instance = instance;
    }

    private static void listProps(Prop parent, MARSNode node, Class<?> beanClass, List<Prop> props) {
        BeanInfo info;
        if (node == null) {
            throw new NullPointerException();
        }
        try {
            info = Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Failed to introspect bean class " + beanClass.getName(), e);
        }
        PropertyDescriptor[] pds = info.getPropertyDescriptors();
        if (pds == null) {
            return;
        }
        for (PropertyDescriptor pd : pds) {
            Monitored monitored;
            Method readMethod = pd.getReadMethod();
            if (readMethod == null || (monitored = readMethod.getAnnotation(Monitored.class)) == null) continue;
            Prop prop = new Prop(parent, readMethod, node, monitored.name(), monitored.description(), monitored.expand());
            props.add(prop);
            if (!prop.expand) continue;
            MARSMonitoredBean.listProps(prop, prop.node, readMethod.getReturnType(), props);
        }
    }

    private static class Prop {
        final Prop parent;
        final Method readMethod;
        final boolean expand;
        final MARSNode node;
        Object lastValue;

        Prop(Prop parent, Method readMethod, MARSNode node, String name, String description, boolean expand) {
            this.parent = parent;
            this.readMethod = readMethod;
            this.expand = expand;
            this.node = node.subNode(name, description);
        }

        public void update(Object instance) {
            Object bean;
            Object object = bean = this.parent == null ? instance : this.parent.lastValue;
            if (bean == null) {
                this.lastValue = null;
                return;
            }
            try {
                this.lastValue = this.readMethod.invoke(bean, new Object[0]);
            }
            catch (Exception e) {
                log.error("Failed to retrieve monitored value", (Throwable)e);
                this.lastValue = null;
                return;
            }
            if (!this.expand) {
                this.node.setValue(String.valueOf(this.lastValue));
            }
        }
    }
}

