/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.mars.common;

import com.devexperts.mars.common.MARS;
import com.devexperts.mars.common.MARSEndpoint;
import com.devexperts.mars.common.MARSEventFactory;
import com.devexperts.mars.common.MARSStatus;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class MARSNode {
    public static final String MARS_ROOT_PROPERTY = "mars.root";
    public static final String MARS_ADDRESS_PROPERTY = "mars.address";
    private final MARSEventFactory marsEventFactory = MARSEventFactory.getInstance();
    private static long last_unique_time;
    private final MARS mars;
    private final String name;
    private String nameValueCache;
    private DateFormat time_formatter;

    public static MARSNode getRoot() {
        return MARSEndpoint.getInstance().getRoot();
    }

    public static void setRoot(MARSNode root) {
        MARSEndpoint.getInstance().setRoot(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateUniqueName() {
        long time = System.currentTimeMillis();
        Class<MARSNode> clazz = MARSNode.class;
        synchronized (MARSNode.class) {
            last_unique_time = time = Math.max(last_unique_time + 1L, time);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return new SimpleDateFormat("yyMMdd-HHmmss:SSS").format(new Date(time));
        }
    }

    public MARSNode(MARS mars, String name) {
        if (mars == null) {
            throw new NullPointerException("MARS is null.");
        }
        if (name == null) {
            throw new NullPointerException("Node name is null.");
        }
        if (name.endsWith(".category") || name.endsWith(".description") || name.endsWith(".status") || name.endsWith(".value")) {
            throw new IllegalArgumentException("Node name ends with reserved suffix: " + name);
        }
        this.mars = mars;
        this.name = name;
    }

    public MARSNode subNode(String subname) {
        return this.subNode(subname, null);
    }

    public MARSNode subNode(String subname, String description) {
        return this.subNode(subname, null, description);
    }

    public MARSNode subNode(String subname, String category, String description) {
        if (subname == null) {
            throw new NullPointerException("Node subname is null.");
        }
        MARSNode subnode = new MARSNode(this.mars, this.name.isEmpty() ? subname : (subname.isEmpty() ? this.name : this.name + "." + subname));
        subnode.setCategory(category);
        subnode.setDescription(description);
        return subnode;
    }

    public MARS getMars() {
        return this.mars;
    }

    public String getName() {
        return this.name;
    }

    private String getInternal(String suffix) {
        return this.mars.getValue(this.name + "." + suffix);
    }

    private void setInternal(String suffix, String value) {
        this.setInternal(suffix, value, 0L);
    }

    private void setInternal(String suffix, String value, long timestamp) {
        if (value != null) {
            this.mars.setValue(this.name + "." + suffix, value, timestamp);
        }
    }

    public String getCategory() {
        return this.getInternal("category");
    }

    public void setCategory(String category) {
        this.setInternal("category", category);
    }

    public String getDescription() {
        return this.getInternal("description");
    }

    public void setDescription(String description) {
        this.setInternal("description", description);
    }

    public String getStatus() {
        return this.getInternal("status");
    }

    public void setStatus(String status) {
        this.setInternal("status", status, 0L);
    }

    public void setStatus(MARSStatus marsStatus) {
        this.setStatus(marsStatus, 0L);
    }

    public void setStatus(MARSStatus marsStatus, long timestamp) {
        if (marsStatus != null) {
            this.setInternal("status", marsStatus.getName(), timestamp);
        }
    }

    public void setStatus(MARSStatus marsStatus, String statusMessage) {
        this.setStatus(marsStatus, statusMessage, 0L);
    }

    public void setStatus(MARSStatus marsStatus, String statusMessage, long timestamp) {
        if (marsStatus != null) {
            this.setInternal("status", marsStatus.getName() + " " + statusMessage, timestamp);
        }
    }

    public String getValue() {
        return this.getInternal("value");
    }

    public void setValue(String value) {
        this.setValue(value, 0L);
    }

    public void setValue(String value, long timestamp) {
        if (value != null) {
            if (this.nameValueCache == null) {
                this.nameValueCache = this.name + "." + "value";
            }
            this.mars.setValue(this.nameValueCache, value, timestamp);
        }
    }

    public int getIntValue() {
        String value = this.getValue();
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public void setIntValue(int value) {
        this.setIntValue(value, 0L);
    }

    public void setIntValue(int value, long timestamp) {
        this.setValue(value == 0 ? "0" : Integer.toString(value), timestamp);
    }

    public double getDoubleValue() {
        String value = this.getValue();
        if (value != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Double.NaN;
    }

    public void setDoubleValue(double value, long timestamp) {
        this.setValue(value == 0.0 ? "0" : (value == (double)((int)value) ? Integer.toString((int)value) : (value == (double)((long)value) ? Long.toString((long)value) : Double.toString(value))), timestamp);
    }

    public void setDoubleValue(double value) {
        this.setDoubleValue(value, 0L);
    }

    private DateFormat getTimeFormatter(TimeZone time_zone) {
        if (this.time_formatter == null) {
            this.time_formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss zzz");
        }
        this.time_formatter.setTimeZone(time_zone);
        return this.time_formatter;
    }

    public long getTimeValue() {
        return this.getTimeValue(TimeZone.getDefault());
    }

    public synchronized long getTimeValue(TimeZone time_zone) {
        String value = this.getValue();
        if (value != null) {
            try {
                return this.getTimeFormatter(time_zone).parse(value).getTime();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return 0L;
    }

    public void setTimeValue(long value, long timestamp) {
        this.setTimeValue(value, TimeZone.getDefault(), timestamp);
    }

    public void setTimeValue(long value) {
        this.setTimeValue(value, TimeZone.getDefault(), 0L);
    }

    public synchronized void setTimeValue(long value, TimeZone timeZone, long timestamp) {
        this.setValue(this.getTimeFormatter(timeZone).format(new Date(value)), timestamp);
    }

    public synchronized void setTimeValue(long value, TimeZone timeZone) {
        this.setTimeValue(value, timeZone, 0L);
    }

    public void remove() {
        this.mars.putEvent(this.marsEventFactory.createMARSEvent(this.getName() + ".status", MARSStatus.REMOVED.getName()));
    }

    public String toString() {
        return this.name;
    }
}

