/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.mars.jvm;

import com.devexperts.logging.Logging;
import com.devexperts.mars.jvm.JVMSelfMonitoring;
import java.io.PrintStream;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;

class ThreadDumper
extends Thread {
    private static final Comparator<ThreadInfo> THREAD_ID_COMPARATOR = new Comparator<ThreadInfo>(){

        @Override
        public int compare(ThreadInfo t1, ThreadInfo t2) {
            return t1.getThreadId() < t2.getThreadId() ? -1 : (t1.getThreadId() > t2.getThreadId() ? 1 : 0);
        }
    };
    private final JVMSelfMonitoring selfMonitoring;
    private final String file;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
    private SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss.sssZ", Locale.US);
    private String header;

    ThreadDumper(JVMSelfMonitoring selfMonitoring, String file) {
        super("ThreadDumper-" + (file.isEmpty() ? "stdout" : file));
        this.setDaemon(true);
        this.selfMonitoring = selfMonitoring;
        this.file = file;
        this.header = "Full thread dump " + System.getProperty("java.vm.name") + " (" + System.getProperty("java.vm.version") + " " + System.getProperty("java.vm.info") + "):";
    }

    String getFile() {
        return this.file;
    }

    private static Logging log() {
        return Logging.getLogging(JVMSelfMonitoring.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            long waitTill;
            long time;
            while ((time = System.currentTimeMillis()) < (waitTill = this.selfMonitoring.getThreadDumpsScheduledAtTime())) {
                Thread.sleep(waitTill - time);
            }
            PrintStream out = this.file.isEmpty() ? System.out : new PrintStream(this.file);
            try {
                while (!ThreadDumper.interrupted() && this.selfMonitoring.getThreadDumpsCount() > 0) {
                    this.makeThreadDump(out);
                    this.selfMonitoring.countThreadDump();
                    ThreadDumper.sleep(this.selfMonitoring.getThreadDumpsPeriodTime());
                }
            }
            finally {
                if (!this.file.isEmpty()) {
                    out.close();
                }
            }
        }
        catch (InterruptedException out) {
        }
        catch (Throwable t) {
            ThreadDumper.log().error("Failed to make thread dumps", t);
        }
        finally {
            this.selfMonitoring.threadDumperTerminated(this);
        }
    }

    private void makeThreadDump(PrintStream out) {
        ThreadMXBean threadMXBean = this.selfMonitoring.getThreadMXBean();
        ThreadInfo[] threadInfos = threadMXBean.dumpAllThreads(threadMXBean.isObjectMonitorUsageSupported(), threadMXBean.isSynchronizerUsageSupported());
        Arrays.sort(threadInfos, THREAD_ID_COMPARATOR);
        Date now = new Date();
        out.println(this.dateFormat.format(now) + "T" + this.timeFormat.format(now) + ": ThreadDumper: Writing thread dump");
        out.println(this.header);
        out.println();
        for (ThreadInfo ti : threadInfos) {
            String lockOwner = ti.getLockOwnerId() > 0L ? " owned by \"" + ti.getLockOwnerName() + "\" id=" + ti.getLockOwnerId() : "";
            String lockInfo = ti.getLockName() != null ? " (lock=" + ti.getLockName() + lockOwner + ")" : "";
            out.println("\"" + ti.getThreadName() + "\" id=" + ti.getThreadId() + " " + (Object)((Object)ti.getThreadState()) + lockInfo);
            for (StackTraceElement ste : ti.getStackTrace()) {
                out.println("\tat " + ste);
            }
            out.println();
        }
        out.flush();
    }
}

