/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.connector;

import com.devexperts.connector.Connector;
import com.devexperts.connector.SocketHandler;
import java.net.Socket;

abstract class SocketController {
    protected final Connector connector;
    protected static final String[] STATE_NAMES = new String[]{"NEW", "CONNECTING", "CONNECTED", "CLOSED"};
    protected static final int NEW = 0;
    protected static final int CONNECTING = 1;
    protected static final int CONNECTED = 2;
    protected static final int CLOSED = 3;
    protected int state = 0;
    protected static final long LOG_DELAY = 120000L;
    private SocketHandler.ControlPack handlerControlPack;

    protected SocketController(Connector connector) {
        this.connector = connector;
    }

    abstract void start();

    abstract void close();

    abstract void handlerClosed(SocketHandler var1);

    abstract Socket acquireSocket();

    protected SocketHandler createNewSocket(String address) {
        SocketHandler handler = new SocketHandler(this.connector, this, address, this.handlerControlPack);
        this.handlerControlPack = handler.getControlPack();
        return handler;
    }
}

