/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.connector;

import com.devexperts.connector.ConnectionAdapter;
import com.devexperts.connector.ConnectionAdapterListener;
import com.devexperts.connector.Connector;
import com.devexperts.connector.SocketController;
import com.devexperts.util.LogUtil;
import java.net.Socket;

class SocketHandler
implements ConnectionAdapterListener,
Runnable {
    private final Connector connector;
    private final SocketController controller;
    private Thread reader;
    private Thread writer;
    private String address;
    private Socket socket;
    private ConnectionAdapter adapter;
    private int heartbeat_period;
    private boolean data_available = true;
    private static final String[] STATE_NAMES = new String[]{"NEW", "CONNECTING", "CONNECTED", "CLOSED"};
    private static final int NEW = 0;
    private static final int CONNECTING = 1;
    private static final int CONNECTED = 2;
    private static final int CLOSED = 3;
    private volatile int state = 0;
    private static final long LOG_DELAY = 120000L;
    private final ControlPack controlPack;

    SocketHandler(Connector connector, SocketController controller, String address, ControlPack controlPack) {
        this.connector = connector;
        this.controller = controller;
        this.address = address;
        this.controlPack = controlPack != null ? controlPack : new ControlPack();
    }

    public String toString() {
        return "SocketHandler-" + LogUtil.hideCredentials((Object)this.address) + ": " + STATE_NAMES[this.state];
    }

    void start() {
        this.makeConnecting();
    }

    void close() {
        this.runDisconnect(null);
    }

    private synchronized boolean makeConnecting() {
        if (this.state == 3) {
            return false;
        }
        if (this.state != 0) {
            throw new IllegalStateException("Handler may be started only once.");
        }
        this.reader = new Thread((Runnable)this, "SocketHandler-" + LogUtil.hideCredentials((Object)this.address));
        this.reader.setDaemon(true);
        this.reader.start();
        this.state = 1;
        return true;
    }

    private synchronized boolean makeConnected(Socket socket, ConnectionAdapter adapter) {
        if (this.state == 3) {
            return false;
        }
        if (this.state != 1) {
            throw new IllegalStateException("Handler may be connected only once.");
        }
        this.reader.setName("SocketReader-" + LogUtil.hideCredentials((Object)this.address));
        this.writer = new Thread((Runnable)this, "SocketWriter-" + LogUtil.hideCredentials((Object)this.address));
        this.writer.setDaemon(true);
        this.writer.start();
        this.socket = socket;
        this.adapter = adapter;
        this.state = 2;
        return true;
    }

    private synchronized boolean makeClosed() {
        if (this.state == 3) {
            return false;
        }
        this.notifyAll();
        if (this.reader != null) {
            this.reader.interrupt();
        }
        if (this.writer != null) {
            this.writer.interrupt();
        }
        this.state = 3;
        return true;
    }

    @Override
    public synchronized void dataAvailable(ConnectionAdapter adapter) {
        if (adapter != this.adapter) {
            return;
        }
        if (this.data_available) {
            return;
        }
        this.data_available = true;
        this.notifyAll();
    }

    @Override
    public void adapterClosed(ConnectionAdapter adapter) {
        if (adapter != this.adapter) {
            return;
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread thread = Thread.currentThread();
        SocketHandler socketHandler = this;
        synchronized (socketHandler) {
            if (thread != this.reader && thread != this.writer) {
                throw new IllegalStateException("Illegal thread: " + thread.getName());
            }
            if (this.state == 3) {
                return;
            }
        }
        if (thread == this.reader && !this.runConnect()) {
            return;
        }
        Throwable error = null;
        try {
            if (thread == this.reader) {
                this.runRead();
            } else {
                this.runWrite();
            }
            this.runDisconnect(error);
        }
        catch (InterruptedException interruptedException) {
            this.runDisconnect(error);
        }
        catch (Throwable t) {
            try {
                error = t;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.runDisconnect(error);
            }
        }
    }

    private void cleanup(Socket socket, ConnectionAdapter adapter) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Throwable t) {
                this.connector.log("Cleanup failed " + LogUtil.hideCredentials((Object)this.connector.getSocketAddress(socket)), t, null);
            }
        }
        if (adapter != null) {
            try {
                adapter.close();
            }
            catch (Throwable t) {
                this.connector.log("Cleanup failed " + LogUtil.hideCredentials((Object)adapter), t, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean runConnect() {
        boolean bl;
        Throwable error;
        boolean connected;
        ConnectionAdapter adapter;
        Socket socket;
        block27: {
            block26: {
                SocketHandler socketHandler = this;
                synchronized (socketHandler) {
                    if (this.state != 1) {
                        return false;
                    }
                }
                socket = null;
                adapter = null;
                connected = false;
                error = null;
                socket = this.controller.acquireSocket();
                if (socket != null) break block26;
                boolean bl2 = false;
                if (connected) return bl2;
                this.controller.handlerClosed(this);
                this.cleanup(socket, adapter);
                if (!this.makeClosed()) return bl2;
                if (error == null) return bl2;
                long curTime = System.currentTimeMillis();
                if (curTime - this.controlPack.prevConnectStatusTime < 120000L) {
                    this.controlPack.prevConnectStatusNumber++;
                    return bl2;
                } else {
                    this.controlPack.prevConnectStatusTime = curTime;
                    StringBuilder sb = new StringBuilder(error.getMessage());
                    if (this.controlPack.prevConnectStatusNumber != 0L) {
                        sb.append('[').append(this.controlPack.prevConnectStatusNumber + 1L);
                        sb.append(" msg, address=").append(LogUtil.hideCredentials((Object)this.address)).append(']');
                        this.controlPack.prevConnectStatusNumber = 0L;
                    }
                    this.connector.log(sb.toString(), error, null);
                }
                return bl2;
            }
            this.address = this.connector.getSocketAddress(socket);
            this.heartbeat_period = this.connector.getHeartbeatPeriod();
            socket.setKeepAlive(true);
            socket.setTcpNoDelay(true);
            socket.setSoTimeout(this.connector.getHeartbeatTimeout());
            adapter = this.connector.createConnectionAdapter(socket);
            if (adapter != null) break block27;
            boolean bl3 = false;
            if (connected) return bl3;
            this.controller.handlerClosed(this);
            this.cleanup(socket, adapter);
            if (!this.makeClosed()) return bl3;
            if (error == null) return bl3;
            long curTime = System.currentTimeMillis();
            if (curTime - this.controlPack.prevConnectStatusTime < 120000L) {
                this.controlPack.prevConnectStatusNumber++;
                return bl3;
            } else {
                this.controlPack.prevConnectStatusTime = curTime;
                StringBuilder sb = new StringBuilder(error.getMessage());
                if (this.controlPack.prevConnectStatusNumber != 0L) {
                    sb.append('[').append(this.controlPack.prevConnectStatusNumber + 1L);
                    sb.append(" msg, address=").append(LogUtil.hideCredentials((Object)this.address)).append(']');
                    this.controlPack.prevConnectStatusNumber = 0L;
                }
                this.connector.log(sb.toString(), error, null);
            }
            return bl3;
        }
        try {
            adapter.setListener(this);
            adapter.start();
            if (this.makeConnected(socket, adapter)) {
                return true;
            }
            boolean bl4 = false;
            bl = bl4;
            if (connected) return bl;
            this.controller.handlerClosed(this);
            this.cleanup(socket, adapter);
            if (!this.makeClosed()) return bl;
            if (error == null) return bl;
        }
        catch (Throwable t) {
            try {
                error = t;
                boolean bl5 = false;
                return bl5;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (!connected) {
                    this.controller.handlerClosed(this);
                    this.cleanup(socket, adapter);
                    if (this.makeClosed() && error != null) {
                        long curTime = System.currentTimeMillis();
                        if (curTime - this.controlPack.prevConnectStatusTime < 120000L) {
                            this.controlPack.prevConnectStatusNumber++;
                        } else {
                            this.controlPack.prevConnectStatusTime = curTime;
                            StringBuilder sb = new StringBuilder(error.getMessage());
                            if (this.controlPack.prevConnectStatusNumber != 0L) {
                                sb.append('[').append(this.controlPack.prevConnectStatusNumber + 1L);
                                sb.append(" msg, address=").append(LogUtil.hideCredentials((Object)this.address)).append(']');
                                this.controlPack.prevConnectStatusNumber = 0L;
                            }
                            this.connector.log(sb.toString(), error, null);
                        }
                    }
                }
            }
        }
        long curTime = System.currentTimeMillis();
        if (curTime - this.controlPack.prevConnectStatusTime < 120000L) {
            this.controlPack.prevConnectStatusNumber++;
            return bl;
        } else {
            this.controlPack.prevConnectStatusTime = curTime;
            StringBuilder sb = new StringBuilder(error.getMessage());
            if (this.controlPack.prevConnectStatusNumber != 0L) {
                sb.append('[').append(this.controlPack.prevConnectStatusNumber + 1L);
                sb.append(" msg, address=").append(LogUtil.hideCredentials((Object)this.address)).append(']');
                this.controlPack.prevConnectStatusNumber = 0L;
            }
            this.connector.log(sb.toString(), error, null);
        }
        return bl;
    }

    private void runDisconnect(Throwable error) {
        if (!this.makeClosed()) {
            return;
        }
        this.controller.handlerClosed(this);
        this.cleanup(this.socket, this.adapter);
        this.connector.log("Disconnect for " + LogUtil.hideCredentials((Object)this.address), error, "DISCONNECTED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runRead() throws Throwable {
        while (!Thread.interrupted()) {
            SocketHandler socketHandler = this;
            synchronized (socketHandler) {
                if (this.state != 2) {
                    return;
                }
            }
            int bytes = this.adapter.readData();
            if (bytes >= 0) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWrite() throws Throwable {
        long next_heartbeat;
        long time = System.currentTimeMillis();
        long l = next_heartbeat = this.heartbeat_period == 0 ? Long.MAX_VALUE : time + (long)this.connector.getSkewedPeriod(this.heartbeat_period);
        while (!Thread.interrupted()) {
            boolean do_write;
            SocketHandler socketHandler = this;
            synchronized (socketHandler) {
                while (this.state == 2 && !this.data_available && time < next_heartbeat) {
                    this.wait(next_heartbeat - time);
                    time = System.currentTimeMillis();
                }
                if (this.state != 2) {
                    return;
                }
                do_write = this.data_available;
                this.data_available = false;
            }
            int bytes = 0;
            if (do_write) {
                bytes = this.adapter.writeData();
            }
            if (bytes == 0 && time >= next_heartbeat) {
                bytes = this.adapter.writeHeartbeat();
            }
            if (bytes < 0) {
                return;
            }
            if (bytes <= 0) continue;
            time = System.currentTimeMillis();
            next_heartbeat = this.heartbeat_period == 0 ? Long.MAX_VALUE : time + (long)this.connector.getSkewedPeriod(this.heartbeat_period);
        }
    }

    ControlPack getControlPack() {
        return this.controlPack;
    }

    static class ControlPack {
        private long prevConnectStatusTime;
        private long prevConnectStatusNumber;

        ControlPack() {
        }
    }
}

