/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.mars.common;

import com.devexperts.logging.Logging;
import com.devexperts.mars.common.MARS;
import com.devexperts.mars.common.MARSNode;
import com.devexperts.mars.common.MARSPlugin;
import com.devexperts.mars.common.net.MARSConnector;
import com.devexperts.services.Services;
import com.devexperts.util.LogUtil;
import com.devexperts.util.SystemProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class MARSEndpoint {
    private static final Logging log = Logging.getLogging(MARS.class);
    private static final Builder SYSTEM_BUILDER = new Builder();
    private static final Map<Builder, MARSEndpoint> INSTANCES;
    private final Builder builder;
    private final String marsRootName;
    private final MARS mars;
    private MARSNode root;
    private final String address;
    private final List<MARSConnector> connectors = new ArrayList<MARSConnector>();
    private final List<MARSPlugin> plugins = new ArrayList<MARSPlugin>();
    private int refCounter;

    public static MARSEndpoint getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    MARSEndpoint(Builder builder, String marsRootName, MARS mars, MARSNode root, String address) {
        this.builder = builder;
        this.marsRootName = marsRootName;
        this.mars = mars;
        this.root = root;
        this.address = address;
    }

    public String getMarsRootName() {
        return this.marsRootName;
    }

    void acquire() {
        if (this.refCounter++ > 0) {
            return;
        }
        if (this.address.length() > 0) {
            MARSConnector connector = new MARSConnector(this.mars, false, true);
            connector.setAddress(this.address);
            connector.start();
            this.connectors.add(connector);
            log.info("MARS root is " + this.root + ", address is " + LogUtil.hideCredentials((Object)this.address));
        }
        for (MARSPlugin.Factory pluginFactory : Services.createServices(MARSPlugin.Factory.class, null)) {
            MARSPlugin plugin = pluginFactory.createPlugin(this);
            plugin.start();
            this.plugins.add(plugin);
            log.info("Started " + plugin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Map<Builder, MARSEndpoint> map = INSTANCES;
        synchronized (map) {
            if (--this.refCounter > 0) {
                return;
            }
            INSTANCES.remove(this.builder);
            for (MARSConnector connector : this.connectors) {
                log.info("Stopping " + connector);
                try {
                    connector.stop();
                }
                catch (Exception e) {
                    log.info("Failed to stop connector", (Throwable)e);
                }
            }
            for (MARSPlugin plugin : this.plugins) {
                log.info("Stopping " + plugin);
                try {
                    plugin.stop();
                }
                catch (Exception e) {
                    log.error("Failed to stop plugin", (Throwable)e);
                }
            }
            this.connectors.clear();
            this.plugins.clear();
        }
    }

    public MARSNode getRoot() {
        return this.root;
    }

    synchronized void setRoot(MARSNode root) {
        this.root = root;
        log.warn("[DEPRECATED METHOD MARSNode.setRoot: Use -Dmars.root=<root-name>] MARS root is set to " + root);
    }

    static {
        SYSTEM_BUILDER.withProperty("mars.root", SystemProperties.getProperty((String)"mars.root", (String)""));
        SYSTEM_BUILDER.withProperty("mars.address", SystemProperties.getProperty((String)"mars.address", (String)""));
        INSTANCES = new HashMap<Builder, MARSEndpoint>();
    }

    public static class Builder {
        private static final Set<String> SUPPORTED_PROPERTIES = new HashSet<String>(Arrays.asList("mars.root", "mars.address"));
        protected final Properties props = new Properties();

        Builder() {
        }

        public final Builder withProperty(String key, String value) {
            if (key == null || value == null) {
                throw new NullPointerException();
            }
            if (this.supportsProperty(key)) {
                this.props.setProperty(key, value);
            }
            return this;
        }

        public final Builder withProperties(Properties props) {
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                this.withProperty((String)entry.getKey(), (String)entry.getValue());
            }
            return this;
        }

        public boolean supportsProperty(String key) {
            return SUPPORTED_PROPERTIES.contains(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MARSEndpoint acquire() {
            String name = this.props.getProperty("mars.root", SYSTEM_BUILDER.props.getProperty("mars.root", ""));
            String address = this.props.getProperty("mars.address", SYSTEM_BUILDER.props.getProperty("mars.address", ""));
            this.props.setProperty("mars.root", name);
            this.props.setProperty("mars.address", address);
            Map map = INSTANCES;
            synchronized (map) {
                MARSEndpoint endpoint = (MARSEndpoint)INSTANCES.get(this);
                if (endpoint == null) {
                    endpoint = this.build();
                    INSTANCES.put(this, endpoint);
                }
                endpoint.acquire();
                return endpoint;
            }
        }

        private MARSEndpoint build() {
            String name = this.props.getProperty("mars.root");
            String address = this.props.getProperty("mars.address");
            MARS mars = new MARS();
            MARSNode root = new MARSNode(mars, name).subNode(MARSNode.generateUniqueName());
            return new MARSEndpoint(this, name, mars, root, address);
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Builder && this.props.equals(((Builder)o).props);
        }

        public int hashCode() {
            return this.props.hashCode();
        }
    }

    private static class InstanceHolder {
        static final MARSEndpoint INSTANCE = MARSEndpoint.access$000().acquire();

        private InstanceHolder() {
        }
    }
}

