/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.ng;

import com.devexperts.qd.DataIntField;
import com.devexperts.qd.DataObjField;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.kit.CompactIntField;
import com.devexperts.qd.kit.DefaultRecord;
import com.devexperts.qd.kit.MarshalledObjField;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.ng.RecordMode;
import com.devexperts.qd.ng.RecordSource;
import org.junit.Assert;
import org.junit.Test;

public class RecordModeBufAppendTest {
    private final DataRecord record = new DefaultRecord(0, "Test", true, new DataIntField[]{new CompactIntField(0, "Test.I0"), new CompactIntField(1, "Test.I1"), new CompactIntField(2, "Test.I2")}, new DataObjField[]{new MarshalledObjField(0, "Test.O0"), new MarshalledObjField(1, "Test.O1")});

    @Test
    public void testDataToSubscription() {
        RecordBuffer buf0 = new RecordBuffer();
        RecordBuffer buf1 = new RecordBuffer(RecordMode.SUBSCRIPTION);
        this.assertEmptyData(buf0.add(this.record, 0, "TEST-SYM"), 0, "TEST-SYM");
        this.assertEmptyData(buf0.add(this.record, 1234, null), 1234, null);
        this.copyBuf0to1(buf0, buf1);
        this.assertSub(buf1.next(), 0, "TEST-SYM");
        this.assertSub(buf1.next(), 1234, null);
        Assert.assertNull((Object)buf1.next());
    }

    @Test
    public void testDataToHistorySubscription() {
        RecordBuffer buf0 = new RecordBuffer();
        RecordBuffer buf1 = new RecordBuffer(RecordMode.HISTORY_SUBSCRIPTION);
        RecordCursor cur = buf0.add(this.record, 0, "TEST-SYM");
        cur.setInt(0, 55);
        cur.setInt(1, 66);
        this.assertHistoryData(cur, 0, "TEST-SYM", 55, 66);
        cur = buf0.add(this.record, 1234, null);
        cur.setInt(0, 77);
        cur.setInt(1, 88);
        this.assertHistoryData(cur, 1234, null, 77, 88);
        this.copyBuf0to1(buf0, buf1);
        this.assertHistorySub(buf1.next(), 0, "TEST-SYM", 55, 66);
        this.assertHistorySub(buf1.next(), 1234, null, 77, 88);
        Assert.assertNull((Object)buf1.next());
    }

    @Test
    public void testSubscriptionToData() {
        RecordBuffer buf0 = new RecordBuffer(RecordMode.SUBSCRIPTION);
        RecordBuffer buf1 = new RecordBuffer();
        this.assertSub(buf0.add(this.record, 0, "TEST-SYM"), 0, "TEST-SYM");
        this.assertSub(buf0.add(this.record, 1234, null), 1234, null);
        this.copyBuf0to1(buf0, buf1);
        this.assertEmptyData(buf1.next(), 0, "TEST-SYM");
        this.assertEmptyData(buf1.next(), 1234, null);
        Assert.assertNull((Object)buf1.next());
    }

    @Test
    public void testHistorySubscriptionToData() {
        RecordBuffer buf0 = new RecordBuffer(RecordMode.HISTORY_SUBSCRIPTION);
        RecordBuffer buf1 = new RecordBuffer();
        RecordCursor cur = buf0.add(this.record, 0, "TEST-SYM");
        cur.setInt(0, 55);
        cur.setInt(1, 66);
        this.assertHistorySub(cur, 0, "TEST-SYM", 55, 66);
        cur = buf0.add(this.record, 1234, null);
        cur.setInt(0, 77);
        cur.setInt(1, 88);
        this.assertHistorySub(cur, 1234, null, 77, 88);
        this.copyBuf0to1(buf0, buf1);
        this.assertHistoryData(buf1.next(), 0, "TEST-SYM", 55, 66);
        this.assertHistoryData(buf1.next(), 1234, null, 77, 88);
        Assert.assertNull((Object)buf1.next());
    }

    @Test
    public void testHistorySubscriptionToSubscription() {
        RecordBuffer buf0 = new RecordBuffer(RecordMode.HISTORY_SUBSCRIPTION);
        RecordBuffer buf1 = new RecordBuffer(RecordMode.SUBSCRIPTION);
        RecordCursor cur = buf0.add(this.record, 0, "TEST-SYM");
        cur.setInt(0, 55);
        cur.setInt(1, 66);
        this.assertHistorySub(cur, 0, "TEST-SYM", 55, 66);
        cur = buf0.add(this.record, 1234, null);
        cur.setTime(330712481880L);
        this.assertHistorySub(cur, 1234, null, 77, 88);
        this.copyBuf0to1(buf0, buf1);
        this.assertSub(buf1.next(), 0, "TEST-SYM");
        this.assertSub(buf1.next(), 1234, null);
        Assert.assertNull((Object)buf1.next());
    }

    @Test
    public void testSubscriptionToHistorySubscription() {
        RecordBuffer buf0 = new RecordBuffer(RecordMode.SUBSCRIPTION);
        RecordBuffer buf1 = new RecordBuffer(RecordMode.HISTORY_SUBSCRIPTION);
        this.assertSub(buf0.add(this.record, 0, "TEST-SYM"), 0, "TEST-SYM");
        this.assertSub(buf0.add(this.record, 1234, null), 1234, null);
        this.copyBuf0to1(buf0, buf1);
        this.assertHistorySub(buf1.next(), 0, "TEST-SYM", 0, 0);
        this.assertHistorySub(buf1.next(), 1234, null, 0, 0);
        Assert.assertNull((Object)buf1.next());
    }

    private void copyBuf0to1(RecordBuffer buf0, RecordBuffer buf1) {
        Assert.assertEquals((long)2L, (long)buf0.size());
        Assert.assertEquals((long)0L, (long)buf1.size());
        buf1.process((RecordSource)buf0);
        Assert.assertEquals((long)2L, (long)buf0.size());
        Assert.assertEquals((long)2L, (long)buf1.size());
    }

    private void assertSub(RecordCursor cur, int cipher, String symbol) {
        Assert.assertNotNull((Object)cur);
        Assert.assertEquals((Object)this.record, (Object)cur.getRecord());
        Assert.assertEquals((long)cipher, (long)cur.getCipher());
        Assert.assertEquals((Object)symbol, (Object)cur.getSymbol());
        Assert.assertEquals((long)0L, (long)cur.getIntCount());
        Assert.assertEquals((long)0L, (long)cur.getObjCount());
    }

    private void assertHistorySub(RecordCursor cur, int cipher, String symbol, int i0, int i1) {
        Assert.assertNotNull((Object)cur);
        Assert.assertEquals((Object)this.record, (Object)cur.getRecord());
        Assert.assertEquals((long)cipher, (long)cur.getCipher());
        Assert.assertEquals((Object)symbol, (Object)cur.getSymbol());
        Assert.assertEquals((long)2L, (long)cur.getIntCount());
        Assert.assertEquals((long)0L, (long)cur.getObjCount());
        Assert.assertEquals((long)i0, (long)cur.getInt(0));
        Assert.assertEquals((long)i1, (long)cur.getInt(1));
    }

    private void assertEmptyData(RecordCursor cur, int cipher, String symbol) {
        Assert.assertNotNull((Object)cur);
        Assert.assertEquals((Object)this.record, (Object)cur.getRecord());
        Assert.assertEquals((long)cipher, (long)cur.getCipher());
        Assert.assertEquals((Object)symbol, (Object)cur.getSymbol());
        Assert.assertEquals((long)3L, (long)cur.getIntCount());
        Assert.assertEquals((long)2L, (long)cur.getObjCount());
        Assert.assertEquals((long)0L, (long)cur.getInt(0));
        Assert.assertEquals((long)0L, (long)cur.getInt(1));
        Assert.assertEquals((long)0L, (long)cur.getInt(2));
        Assert.assertNull((Object)cur.getObj(0));
        Assert.assertNull((Object)cur.getObj(1));
    }

    private void assertHistoryData(RecordCursor cur, int cipher, String symbol, int i0, int i1) {
        Assert.assertNotNull((Object)cur);
        Assert.assertEquals((Object)this.record, (Object)cur.getRecord());
        Assert.assertEquals((long)cipher, (long)cur.getCipher());
        Assert.assertEquals((Object)symbol, (Object)cur.getSymbol());
        Assert.assertEquals((long)3L, (long)cur.getIntCount());
        Assert.assertEquals((long)2L, (long)cur.getObjCount());
        Assert.assertEquals((long)i0, (long)cur.getInt(0));
        Assert.assertEquals((long)i1, (long)cur.getInt(1));
        Assert.assertEquals((long)0L, (long)cur.getInt(2));
        Assert.assertNull((Object)cur.getObj(0));
        Assert.assertNull((Object)cur.getObj(1));
    }
}

