/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

import com.devexperts.qd.DataIntField;
import com.devexperts.qd.DataObjField;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.impl.matrix.History;
import com.devexperts.qd.impl.matrix.HistoryBuffer;
import com.devexperts.qd.impl.matrix.HistoryBufferOld;
import com.devexperts.qd.impl.matrix.RecordCursorKeeper;
import com.devexperts.qd.impl.matrix.RecordCursorKeeperOld;
import com.devexperts.qd.kit.CompactIntField;
import com.devexperts.qd.kit.DefaultRecord;
import com.devexperts.qd.kit.MarshalledObjField;
import com.devexperts.qd.kit.TimeMillisField;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.ng.RecordMode;
import com.devexperts.qd.ng.RecordSink;
import com.devexperts.qd.stats.QDStats;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.junit.Assert;
import org.junit.Test;

public class HistoryBufferTest {
    private static final Random RANDOM = new Random(0L);
    private static final DataRecord RECORD = new DefaultRecord(0, "Test_Record", true, new DataIntField[]{new TimeMillisField(0, "Test_Record.Time"), new CompactIntField(1, "Test_Record.Int0"), new CompactIntField(2, "Test_Record.Int1"), new CompactIntField(3, "Test_Record.Int2")}, new DataObjField[]{new MarshalledObjField(0, "Test_Record.Obj0"), new MarshalledObjField(1, "Test_Record.Obj1")});
    private static final QDStats QD_STATS = new QDStats(QDStats.SType.ANY);

    @Test
    public void testEmptyBuffer() {
        HistoryBufferOld bufferOld = new HistoryBufferOld(RECORD, false);
        HistoryBuffer bufferNew = new HistoryBuffer(RECORD, false);
        this.verifyBuffers(bufferOld, bufferNew, 0L, 10L);
    }

    @Test
    public void testSimpleInsert() {
        HistoryBufferOld bufferOld = new HistoryBufferOld(RECORD, false);
        HistoryBuffer bufferNew = new HistoryBuffer(RECORD, false);
        int[] largeSequence = IntStream.range(0, 64).toArray();
        this.generateHistoryBuffer(largeSequence, bufferOld, bufferNew, false);
        this.verifyBuffers(bufferOld, bufferNew, 0L, 64L);
    }

    @Test
    public void testInsertBiDirection() {
        HistoryBufferOld bufferOld = new HistoryBufferOld(RECORD, false);
        HistoryBuffer bufferNew = new HistoryBuffer(RECORD, false);
        int left = 1000;
        int right = 1000;
        for (int i = 0; i < 1000; ++i) {
            this.putToBuffers(left - i, bufferOld, bufferNew, false);
            this.putToBuffers(right + i, bufferOld, bufferNew, false);
        }
        this.verifyBuffers(bufferOld, bufferNew, 0L, 2000L);
    }

    @Test
    public void testAvailableCount() {
        for (int i = 0; i < 1000; ++i) {
            HistoryBufferOld bufferOld = new HistoryBufferOld(RECORD, false);
            HistoryBuffer bufferNew = new HistoryBuffer(RECORD, false);
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            for (int j = 0; j < 2048; ++j) {
                boolean shouldRemove = RANDOM.nextBoolean();
                int time = RANDOM.nextInt(2048);
                min = Math.min(min, time);
                max = Math.max(max, time);
                RecordBuffer buf = this.createRecordBuffer(time);
                RecordCursor cursor = buf.current();
                bufferOld.putRecord(time, cursor, shouldRemove, QD_STATS, 0);
                bufferNew.putRecord((long)time, cursor, shouldRemove, QD_STATS, 0);
            }
            Assert.assertEquals((long)bufferOld.getAvailableCount(min - 1, max + 1), (long)bufferNew.getAvailableCount((long)(min - 1), (long)(max + 1)));
            Assert.assertEquals((long)bufferOld.getAvailableCount(min, max + 1), (long)bufferNew.getAvailableCount((long)min, (long)(max + 1)));
            Assert.assertEquals((long)bufferOld.getAvailableCount(min - 1, max), (long)bufferNew.getAvailableCount((long)(min - 1), (long)max));
            Assert.assertEquals((long)bufferOld.getAvailableCount((min * 3 + max) / 4, (min + 3 * max) / 4), (long)bufferNew.getAvailableCount((long)((min * 3 + max) / 4), (long)((min + 3 * max) / 4)));
            this.verifyBuffers(bufferOld, bufferNew, min, max);
        }
    }

    @Test
    public void testInsertAndRemoveSameElements() {
        HistoryBufferOld bufferOld = new HistoryBufferOld(RECORD, false);
        HistoryBuffer bufferNew = new HistoryBuffer(RECORD, false);
        int[] initial = IntStream.range(0, 20).toArray();
        this.generateHistoryBuffer(initial, bufferOld, bufferNew, false);
        int[] remove = new int[]{5, 7, 9, 11, 13, 15};
        this.generateHistoryBuffer(remove, bufferOld, bufferNew, true);
        this.generateHistoryBuffer(remove, bufferOld, bufferNew, false);
        this.verifyBuffers(bufferOld, bufferNew, 0L, 20L);
    }

    @Test
    public void testRandomInsertRemove() {
        HistoryBufferOld bufferOld = new HistoryBufferOld(RECORD, false);
        HistoryBuffer bufferNew = new HistoryBuffer(RECORD, false);
        for (int i = 0; i < 100000; ++i) {
            boolean shouldRemove = RANDOM.nextBoolean();
            int time = RANDOM.nextInt(2048) + 1;
            RecordBuffer buf = this.createRecordBuffer(time);
            RecordCursor cursor = buf.current();
            bufferOld.putRecord(time, cursor, shouldRemove, QD_STATS, 0);
            bufferNew.putRecord((long)time, cursor, shouldRemove, QD_STATS, 0);
            Assert.assertEquals((long)bufferOld.size(), (long)bufferNew.size());
            Assert.assertEquals((long)bufferOld.getMaxAvailableTime(), (long)bufferNew.getMaxAvailableTime());
            Assert.assertEquals((long)bufferOld.getMinAvailableTime(), (long)bufferNew.getMinAvailableTime());
            Assert.assertEquals((long)bufferOld.getAvailableCount(0L, 2049L), (long)bufferNew.getAvailableCount(0L, 2049L));
            Assert.assertEquals((long)bufferOld.getAvailableCount(500L, 1500L), (long)bufferNew.getAvailableCount(500L, 1500L));
        }
        this.verifyBuffers(bufferOld, bufferNew, 0L, 2049L);
    }

    @Test
    public void testConsecutiveRemoveInsert() {
        HistoryBufferOld bufferOld = new HistoryBufferOld(RECORD, false);
        HistoryBuffer bufferNew = new HistoryBuffer(RECORD, false);
        int[] initial = new int[]{1, 2, 3, 4, 5};
        this.generateHistoryBuffer(initial, bufferOld, bufferNew, false);
        for (int i : initial) {
            RecordBuffer removeBuf = this.createRecordBuffer(i);
            RecordCursor removeCursor = removeBuf.current();
            bufferOld.putRecord(i, removeCursor, true, QD_STATS, 0);
            bufferNew.putRecord((long)i, removeCursor, true, QD_STATS, 0);
            RecordBuffer insertBuf = this.createRecordBuffer(i);
            RecordCursor insertCursor = insertBuf.current();
            bufferOld.putRecord(i, insertCursor, false, QD_STATS, 0);
            bufferNew.putRecord((long)i, insertCursor, false, QD_STATS, 0);
        }
        this.verifyBuffers(bufferOld, bufferNew, 1L, 5L);
    }

    @Test
    public void testGapCreationAndFill() {
        HistoryBufferOld bufferOld = new HistoryBufferOld(RECORD, false);
        HistoryBuffer bufferNew = new HistoryBuffer(RECORD, false);
        int[] gapFull = IntStream.range(11, 13).toArray();
        int[] gapNotFull = IntStream.range(111, 142).toArray();
        Set exclusion = IntStream.concat(Arrays.stream(gapFull), Arrays.stream(gapNotFull)).boxed().collect(Collectors.toSet());
        int[] initial = IntStream.range(0, 256).filter(i -> !exclusion.contains(i)).toArray();
        this.generateHistoryBuffer(initial, bufferOld, bufferNew, false);
        this.generateHistoryBuffer(gapFull, bufferOld, bufferNew, false);
        this.generateHistoryBuffer(gapNotFull, bufferOld, bufferNew, false);
        this.verifyBuffers(bufferOld, bufferNew, 0L, 256L);
    }

    @Test
    public void testRandomizedGapInsertion() {
        for (int iterations = 0; iterations < 1000; ++iterations) {
            HistoryBufferOld bufferOld = new HistoryBufferOld(RECORD, false);
            HistoryBuffer bufferNew = new HistoryBuffer(RECORD, false);
            int[] sequence = RANDOM.ints(0, 2000).distinct().limit(100L).sorted().toArray();
            this.generateHistoryBuffer(sequence, bufferOld, bufferNew, false);
            ArrayList<Integer> gapTimes = new ArrayList<Integer>();
            Set times = Arrays.stream(sequence).boxed().collect(Collectors.toSet());
            for (int i = 1; i < sequence[sequence.length - 1]; ++i) {
                if (times.contains(i) || !RANDOM.nextBoolean()) continue;
                gapTimes.add(i);
            }
            Collections.shuffle(gapTimes);
            this.generateHistoryBuffer(gapTimes.stream().mapToInt(value -> value).toArray(), bufferOld, bufferNew, false);
            this.verifyBuffers(bufferOld, bufferNew, sequence[0], sequence[sequence.length - 1]);
        }
    }

    @Test
    public void testRandomRemoval() {
        HistoryBufferOld bufferOld = new HistoryBufferOld(RECORD, false);
        HistoryBuffer bufferNew = new HistoryBuffer(RECORD, false);
        int[] initial = IntStream.range(0, 100).toArray();
        this.generateHistoryBuffer(initial, bufferOld, bufferNew, false);
        for (int i = 0; i < 50; ++i) {
            int time = RANDOM.nextInt(98) + 1;
            RecordBuffer buf = this.createRecordBuffer(time);
            RecordCursor cursor = buf.current();
            bufferOld.putRecord(time, cursor, true, QD_STATS, 0);
            bufferNew.putRecord((long)time, cursor, true, QD_STATS, 0);
        }
        this.verifyBuffers(bufferOld, bufferNew, 0L, 100L);
    }

    @Test
    public void testBoundaryInsertions() {
        HistoryBufferOld bufferOld = new HistoryBufferOld(RECORD, false);
        HistoryBuffer bufferNew = new HistoryBuffer(RECORD, false);
        int[] initial = new int[]{10, 20, 30, 40, 50};
        this.generateHistoryBuffer(initial, bufferOld, bufferNew, false);
        int[] boundaries = new int[]{9, 51};
        this.generateHistoryBuffer(boundaries, bufferOld, bufferNew, false);
        int[] between = new int[]{15, 25, 35, 45};
        this.generateHistoryBuffer(between, bufferOld, bufferNew, false);
        this.verifyBuffers(bufferOld, bufferNew, 0L, 55L);
    }

    @Test
    public void testCompactionTrigger() {
        for (int iterations = 0; iterations < 1000; ++iterations) {
            int count = 1024 + RANDOM.nextInt(1000);
            HistoryBufferOld bufferOld = new HistoryBufferOld(RECORD, false);
            HistoryBuffer bufferNew = new HistoryBuffer(RECORD, false);
            for (int i = 0; i < count; ++i) {
                this.putToBuffers(i, bufferOld, bufferNew, false);
            }
            int parts = 1 + RANDOM.nextInt(20);
            int partCount = count / parts;
            for (int i = 0; i < parts; ++i) {
                int start = i * partCount;
                for (int j = 0; j < partCount / 3; ++j) {
                    this.putToBuffers(start + j, bufferOld, bufferNew, true);
                }
            }
            RecordBuffer buf = this.createRecordBuffer(partCount);
            RecordCursor cursor = buf.current();
            bufferOld.putRecord(partCount, cursor, false, QD_STATS, 0);
            bufferNew.putRecord((long)partCount, cursor, false, QD_STATS, 0);
            this.verifyBuffers(bufferOld, bufferNew, 0L, count);
        }
    }

    @Test
    public void testEmptyBufferRemoveOldRecords() {
        HistoryBufferOld bufferOld = new HistoryBufferOld(RECORD, false);
        HistoryBuffer bufferNew = new HistoryBuffer(RECORD, false);
        bufferOld.removeOldRecords(100L, QD_STATS, 0);
        bufferNew.removeOldRecords(100L, QD_STATS, 0);
        Assert.assertEquals((long)0L, (long)bufferOld.size());
        Assert.assertEquals((long)0L, (long)bufferNew.size());
        this.verifyBuffers(bufferOld, bufferNew, 0L, 100L);
    }

    @Test
    public void testFullBufferRemoveOldRecords() {
        HistoryBufferOld bufferOld = new HistoryBufferOld(RECORD, false);
        HistoryBuffer bufferNew = new HistoryBuffer(RECORD, false);
        int[] sequence = IntStream.range(0, 2048).toArray();
        this.generateHistoryBuffer(sequence, bufferOld, bufferNew, false);
        bufferOld.removeOldRecords(2049L, QD_STATS, 0);
        bufferNew.removeOldRecords(2049L, QD_STATS, 0);
        Assert.assertEquals((long)0L, (long)bufferOld.size());
        Assert.assertEquals((long)0L, (long)bufferNew.size());
        this.verifyBuffers(bufferOld, bufferNew, 0L, 2049L);
    }

    @Test
    public void testRemoveOldRecords() throws Exception {
        for (int iteration = 0; iteration < 100; ++iteration) {
            QDStats statsOld = new QDStats(QDStats.SType.ANY);
            QDStats statsNew = new QDStats(QDStats.SType.ANY);
            HistoryBufferOld bufferOld = new HistoryBufferOld(RECORD, false);
            HistoryBuffer bufferNew = new HistoryBuffer(RECORD, false);
            HistoryBufferTest.setFieldValue(bufferOld, "everSnapshotTime", Long.MIN_VALUE);
            HistoryBufferTest.setFieldValue(bufferNew, "everSnapshotTime", Long.MIN_VALUE);
            int[] elements = RANDOM.ints(3000L).distinct().toArray();
            this.generateHistoryBuffer(elements, bufferOld, bufferNew, false);
            for (int i : elements) {
                if (!RANDOM.nextBoolean()) continue;
                this.putToBuffers(i, bufferOld, bufferNew, true);
            }
            Arrays.sort(elements);
            int min = elements[0];
            int max = elements[elements.length - 1];
            int median = elements[elements.length / 2];
            Assert.assertEquals((long)bufferOld.size(), (long)bufferNew.size());
            this.verifyBuffers(bufferOld, bufferNew, min, max + 1);
            bufferOld.removeOldRecords(median, statsOld, 0);
            bufferNew.removeOldRecords((long)median, statsNew, 0);
            Assert.assertEquals((long)statsOld.getValue(QDStats.SValue.RID_REMOVED), (long)statsNew.getValue(QDStats.SValue.RID_REMOVED));
            Assert.assertEquals((long)bufferOld.size(), (long)bufferNew.size());
            Assert.assertTrue((bufferOld.getMinAvailableTime() >= (long)median ? 1 : 0) != 0);
            Assert.assertTrue((bufferNew.getMinAvailableTime() >= (long)median ? 1 : 0) != 0);
            this.verifyBuffers(bufferOld, bufferNew, median, max);
            bufferOld.removeOldRecords(max + 1, statsOld, 0);
            bufferNew.removeOldRecords((long)(max + 1), statsNew, 0);
            Assert.assertEquals((long)statsOld.getValue(QDStats.SValue.RID_REMOVED), (long)statsNew.getValue(QDStats.SValue.RID_REMOVED));
            Assert.assertEquals((long)0L, (long)bufferOld.size());
            Assert.assertEquals((long)0L, (long)bufferNew.size());
            this.verifyBuffers(bufferOld, bufferNew, min, max + 1);
        }
    }

    @Test
    public void testEmptyBufferEnforceMaxRecordCount() {
        HistoryBufferOld bufferOld = new HistoryBufferOld(RECORD, false);
        HistoryBuffer bufferNew = new HistoryBuffer(RECORD, false);
        bufferOld.enforceMaxRecordCount(50, QD_STATS, 0);
        bufferNew.enforceMaxRecordCount(50, QD_STATS, 0);
        Assert.assertEquals((long)0L, (long)bufferOld.size());
        Assert.assertEquals((long)0L, (long)bufferNew.size());
        this.verifyBuffers(bufferOld, bufferNew, 0L, 100L);
    }

    @Test
    public void testFullBufferEnforceMaxRecordCount() {
        QDStats statsOld = new QDStats(QDStats.SType.ANY);
        QDStats statsNew = new QDStats(QDStats.SType.ANY);
        HistoryBufferOld bufferOld = new HistoryBufferOld(RECORD, false);
        HistoryBuffer bufferNew = new HistoryBuffer(RECORD, false);
        int[] sequence = IntStream.range(0, 2048).toArray();
        this.generateHistoryBuffer(sequence, bufferOld, bufferNew, false);
        bufferOld.enforceMaxRecordCount(0, statsOld, 0);
        bufferNew.enforceMaxRecordCount(0, statsNew, 0);
        Assert.assertEquals((long)statsOld.getValue(QDStats.SValue.RID_REMOVED), (long)statsNew.getValue(QDStats.SValue.RID_REMOVED));
        Assert.assertEquals((long)0L, (long)bufferOld.size());
        Assert.assertEquals((long)0L, (long)bufferNew.size());
        this.verifyBuffers(bufferOld, bufferNew, 0L, 2048L);
    }

    @Test
    public void testRandomizedEnforceMaxRecordCount() {
        for (int iteration = 0; iteration < 100; ++iteration) {
            QDStats statsOld = new QDStats(QDStats.SType.ANY);
            QDStats statsNew = new QDStats(QDStats.SType.ANY);
            HistoryBufferOld bufferOld = new HistoryBufferOld(RECORD, false);
            HistoryBuffer bufferNew = new HistoryBuffer(RECORD, false);
            int[] elements = RANDOM.ints(3000L).distinct().toArray();
            this.generateHistoryBuffer(elements, bufferOld, bufferNew, false);
            for (int i : elements) {
                if (!RANDOM.nextBoolean()) continue;
                this.putToBuffers(i, bufferOld, bufferNew, true);
            }
            Arrays.sort(elements);
            int min = elements[0];
            int max = elements[elements.length - 1];
            Assert.assertEquals((long)bufferOld.size(), (long)bufferNew.size());
            this.verifyBuffers(bufferOld, bufferNew, min, max + 1);
            int maxCount = RANDOM.nextInt(bufferOld.size() + 1);
            bufferOld.enforceMaxRecordCount(maxCount, statsOld, 0);
            bufferNew.enforceMaxRecordCount(maxCount, statsNew, 0);
            Assert.assertEquals((long)statsOld.getValue(QDStats.SValue.RID_REMOVED), (long)statsNew.getValue(QDStats.SValue.RID_REMOVED));
            Assert.assertEquals((long)maxCount, (long)bufferOld.size());
            Assert.assertEquals((long)maxCount, (long)bufferNew.size());
            this.verifyBuffers(bufferOld, bufferNew, min, max + 1);
            bufferOld.enforceMaxRecordCount(3, statsOld, 0);
            bufferNew.enforceMaxRecordCount(3, statsNew, 0);
            Assert.assertEquals((long)statsOld.getValue(QDStats.SValue.RID_REMOVED), (long)statsNew.getValue(QDStats.SValue.RID_REMOVED));
            maxCount = Math.min(3, bufferOld.size());
            Assert.assertEquals((long)maxCount, (long)bufferOld.size());
            Assert.assertEquals((long)maxCount, (long)bufferNew.size());
            this.verifyBuffers(bufferOld, bufferNew, min, max + 1);
            bufferOld.enforceMaxRecordCount(0, statsOld, 0);
            bufferNew.enforceMaxRecordCount(0, statsNew, 0);
            Assert.assertEquals((long)statsOld.getValue(QDStats.SValue.RID_REMOVED), (long)statsNew.getValue(QDStats.SValue.RID_REMOVED));
            Assert.assertEquals((long)0L, (long)bufferOld.size());
            Assert.assertEquals((long)0L, (long)bufferNew.size());
            this.verifyBuffers(bufferOld, bufferNew, min, max + 1);
        }
    }

    @Test
    public void testFullRemoveSnapshotFromSnipTime() {
        QDStats statsOld = new QDStats(QDStats.SType.ANY);
        QDStats statsNew = new QDStats(QDStats.SType.ANY);
        RecordBuffer removeBufferOld = RecordBuffer.getInstance((RecordMode)RecordMode.DATA);
        RecordBuffer removeBufferNew = RecordBuffer.getInstance((RecordMode)RecordMode.DATA);
        HistoryBufferOld bufferOld = new HistoryBufferOld(RECORD, false);
        HistoryBuffer bufferNew = new HistoryBuffer(RECORD, false);
        int[] sequence = IntStream.range(0, 100).toArray();
        this.generateHistoryBuffer(sequence, bufferOld, bufferNew, false);
        bufferOld.snapshotSnipAndRemove(100L, RECORD, 1, "TEST", removeBufferOld, statsOld, 0);
        bufferNew.snapshotSnipAndRemove(100L, RECORD, 1, "TEST", removeBufferNew, statsNew, 0);
        Assert.assertEquals((long)statsOld.getValue(QDStats.SValue.RID_REMOVED), (long)statsNew.getValue(QDStats.SValue.RID_REMOVED));
        this.compareRecordBuffers(removeBufferOld, removeBufferNew);
        this.verifyBuffers(bufferOld, bufferNew, 0L, 100L);
    }

    @Test
    public void testRandomRemoveSnapshotFromSnipTime() throws Exception {
        for (int iteration = 0; iteration < 100; ++iteration) {
            HistoryBufferOld bufferOld = new HistoryBufferOld(RECORD, false);
            HistoryBuffer bufferNew = new HistoryBuffer(RECORD, false);
            HistoryBufferTest.setFieldValue(bufferOld, "everSnapshotTime", Long.MIN_VALUE);
            HistoryBufferTest.setFieldValue(bufferNew, "everSnapshotTime", Long.MIN_VALUE);
            int[] elements = RANDOM.ints(3000L).distinct().toArray();
            this.generateHistoryBuffer(elements, bufferOld, bufferNew, false);
            for (int i : elements) {
                if (!RANDOM.nextBoolean()) continue;
                this.putToBuffers(i, bufferOld, bufferNew, true);
            }
            Arrays.sort(elements);
            int min = elements[0];
            int max = elements[elements.length - 1];
            Assert.assertEquals((long)bufferOld.size(), (long)bufferNew.size());
            this.verifyBuffers(bufferOld, bufferNew, min, max + 1);
            for (int i = 0; i < elements.length; ++i) {
                if (i % 42 != 0) continue;
                int time = elements[i];
                QDStats statsOld = new QDStats(QDStats.SType.ANY);
                QDStats statsNew = new QDStats(QDStats.SType.ANY);
                RecordBuffer removeBufferOld = RecordBuffer.getInstance((RecordMode)RecordMode.DATA);
                RecordBuffer removeBufferNew = RecordBuffer.getInstance((RecordMode)RecordMode.DATA);
                bufferOld.snapshotSnipAndRemove(time, RECORD, 1, "TEST", removeBufferOld, statsOld, 0);
                bufferNew.snapshotSnipAndRemove((long)time, RECORD, 1, "TEST", removeBufferNew, statsNew, 0);
                Assert.assertEquals((long)statsOld.getValue(QDStats.SValue.RID_REMOVED), (long)statsNew.getValue(QDStats.SValue.RID_REMOVED));
                this.compareRecordBuffers(removeBufferOld, removeBufferNew);
                this.verifyBuffers(bufferOld, bufferNew, time, max + 1);
            }
            QDStats statsOld = new QDStats(QDStats.SType.ANY);
            QDStats statsNew = new QDStats(QDStats.SType.ANY);
            RecordBuffer removeBufferOld = RecordBuffer.getInstance((RecordMode)RecordMode.DATA);
            RecordBuffer removeBufferNew = RecordBuffer.getInstance((RecordMode)RecordMode.DATA);
            bufferOld.snapshotSnipAndRemove(max + 1, RECORD, 1, "TEST", removeBufferOld, statsOld, 0);
            bufferNew.snapshotSnipAndRemove((long)(max + 1), RECORD, 1, "TEST", removeBufferNew, statsNew, 0);
            Assert.assertEquals((long)statsOld.getValue(QDStats.SValue.RID_REMOVED), (long)statsNew.getValue(QDStats.SValue.RID_REMOVED));
            Assert.assertEquals((long)0L, (long)bufferOld.size());
            Assert.assertEquals((long)0L, (long)bufferNew.size());
            this.compareRecordBuffers(removeBufferOld, removeBufferNew);
            this.verifyBuffers(bufferOld, bufferNew, 0L, max + 1);
        }
    }

    @Test
    public void testFullRemoveUpdateSnapshotTimeAndSweepRemove() {
        QDStats statsOld = new QDStats(QDStats.SType.ANY);
        QDStats statsNew = new QDStats(QDStats.SType.ANY);
        RecordBuffer removeBufferOld = RecordBuffer.getInstance((RecordMode)RecordMode.DATA);
        RecordBuffer removeBufferNew = RecordBuffer.getInstance((RecordMode)RecordMode.DATA);
        HistoryBufferOld bufferOld = new HistoryBufferOld(RECORD, false);
        HistoryBuffer bufferNew = new HistoryBuffer(RECORD, false);
        int[] sequence = IntStream.range(0, 100).toArray();
        this.generateHistoryBuffer(sequence, bufferOld, bufferNew, false);
        bufferOld.updateSnapshotTimeAndSweepRemove(0L, 0L, RECORD, 1, "TEST", removeBufferOld, statsOld, 0);
        bufferNew.updateSnapshotTimeAndSweepRemove(0L, 0L, RECORD, 1, "TEST", removeBufferNew, statsNew, 0);
        Assert.assertEquals((long)statsOld.getValue(QDStats.SValue.RID_REMOVED), (long)statsNew.getValue(QDStats.SValue.RID_REMOVED));
        this.compareRecordBuffers(removeBufferOld, removeBufferNew);
        this.verifyBuffers(bufferOld, bufferNew, 0L, 100L);
    }

    @Test
    public void testVariousTimeNoGapsUpdateSnapshotTimeAndSweepRemove() throws Exception {
        long[] initialSnapshotTimes = new long[]{Long.MAX_VALUE, 100L, 50L, 200L};
        long[] updateTimes = new long[]{Long.MAX_VALUE, 250L, 150L, 100L, 50L, 30L, 20L, 0L, -10L};
        long[] trimValues = new long[]{0L, 10L, 40L, 80L, 120L, 500L};
        int[] elements = IntStream.range(1, 201).toArray();
        for (long initialSnapshotTime : initialSnapshotTimes) {
            for (long time : updateTimes) {
                for (long trimToTime : trimValues) {
                    QDStats statsOld = new QDStats(QDStats.SType.ANY);
                    QDStats statsNew = new QDStats(QDStats.SType.ANY);
                    RecordBuffer removeBufferOld = RecordBuffer.getInstance((RecordMode)RecordMode.DATA);
                    RecordBuffer removeBufferNew = RecordBuffer.getInstance((RecordMode)RecordMode.DATA);
                    HistoryBufferOld bufferOld = new HistoryBufferOld(RECORD, false);
                    HistoryBuffer bufferNew = new HistoryBuffer(RECORD, false);
                    HistoryBufferTest.setFieldValue(bufferOld, "everSnapshotTime", Long.MIN_VALUE);
                    HistoryBufferTest.setFieldValue(bufferNew, "everSnapshotTime", Long.MIN_VALUE);
                    this.generateHistoryBuffer(elements, bufferOld, bufferNew, false);
                    HistoryBufferTest.setFieldValue(bufferOld, "snapshotTime", initialSnapshotTime);
                    HistoryBufferTest.setFieldValue(bufferNew, "snapshotTime", initialSnapshotTime);
                    bufferOld.updateSnapshotTimeAndSweepRemove(time, trimToTime, RECORD, 1, "TEST", removeBufferOld, statsOld, 0);
                    bufferNew.updateSnapshotTimeAndSweepRemove(time, trimToTime, RECORD, 1, "TEST", removeBufferNew, statsNew, 0);
                    Assert.assertEquals((long)statsOld.getValue(QDStats.SValue.RID_REMOVED), (long)statsNew.getValue(QDStats.SValue.RID_REMOVED));
                    this.compareRecordBuffers(removeBufferOld, removeBufferNew);
                    this.verifyBuffers(bufferOld, bufferNew, 1L, 201L);
                }
            }
        }
    }

    @Test
    public void testRandomUpdateSnapshotTimeAndSweepRemove() throws Exception {
        for (int iteration = 0; iteration < 100; ++iteration) {
            HistoryBufferOld bufferOld = new HistoryBufferOld(RECORD, false);
            HistoryBuffer bufferNew = new HistoryBuffer(RECORD, false);
            HistoryBufferTest.setFieldValue(bufferOld, "everSnapshotTime", Long.MIN_VALUE);
            HistoryBufferTest.setFieldValue(bufferNew, "everSnapshotTime", Long.MIN_VALUE);
            int[] elements = RANDOM.ints(3000L).distinct().toArray();
            this.generateHistoryBuffer(elements, bufferOld, bufferNew, false);
            for (int i : elements) {
                if (!RANDOM.nextBoolean()) continue;
                this.putToBuffers(i, bufferOld, bufferNew, true);
            }
            Arrays.sort(elements);
            int min = elements[0];
            int max = elements[elements.length - 1];
            Assert.assertEquals((long)bufferOld.size(), (long)bufferNew.size());
            this.verifyBuffers(bufferOld, bufferNew, min, max + 1);
            for (int i = 0; i < 1000; ++i) {
                long initialSnapshotTime = RANDOM.nextInt(max + 1);
                long time = RANDOM.nextInt((int)initialSnapshotTime + 1);
                long trimToTime = RANDOM.nextInt((int)initialSnapshotTime + 1);
                QDStats statsOld = new QDStats(QDStats.SType.ANY);
                QDStats statsNew = new QDStats(QDStats.SType.ANY);
                RecordBuffer removeBufferOld = RecordBuffer.getInstance((RecordMode)RecordMode.DATA);
                RecordBuffer removeBufferNew = RecordBuffer.getInstance((RecordMode)RecordMode.DATA);
                HistoryBufferTest.setFieldValue(bufferOld, "snapshotTime", initialSnapshotTime);
                HistoryBufferTest.setFieldValue(bufferNew, "snapshotTime", initialSnapshotTime);
                bufferOld.updateSnapshotTimeAndSweepRemove(time, trimToTime, RECORD, 1, "TEST", removeBufferOld, statsOld, 0);
                bufferNew.updateSnapshotTimeAndSweepRemove(time, trimToTime, RECORD, 1, "TEST", removeBufferNew, statsNew, 0);
                Assert.assertEquals((long)statsOld.getValue(QDStats.SValue.RID_REMOVED), (long)statsNew.getValue(QDStats.SValue.RID_REMOVED));
                this.compareRecordBuffers(removeBufferOld, removeBufferNew);
                this.verifyBuffers(bufferOld, bufferNew, time, max + 1);
            }
        }
    }

    @Test
    public void testVariousRangesExamineDataRange() throws Exception {
        HistoryBufferOld bufferOld = new HistoryBufferOld(RECORD, false);
        HistoryBuffer bufferNew = new HistoryBuffer(RECORD, false);
        int[] elements = IntStream.range(1, 101).toArray();
        this.generateHistoryBuffer(elements, bufferOld, bufferNew, false);
        for (int i : elements) {
            if (i % 10 == 0) continue;
            this.putToBuffers(i, bufferOld, bufferNew, true);
        }
        Assert.assertEquals((long)bufferOld.size(), (long)bufferNew.size());
        long[] everSnapshotTimeArray = LongStream.concat(LongStream.rangeClosed(0L, 101L), LongStream.of(Long.MIN_VALUE, Long.MIN_VALUE)).toArray();
        for (boolean snapshotFlag : new boolean[]{false, true}) {
            if (snapshotFlag) {
                HistoryBufferTest.setFieldValue(bufferOld, "flags", (byte)4);
                HistoryBufferTest.setFieldValue(bufferNew, "flags", (byte)4);
            }
            for (long everSnapshotTime : everSnapshotTimeArray) {
                HistoryBufferTest.setFieldValue(bufferOld, "everSnapshotTime", everSnapshotTime);
                HistoryBufferTest.setFieldValue(bufferNew, "everSnapshotTime", everSnapshotTime);
                this.verifyBuffers(bufferOld, bufferNew, 5L, 15L);
                this.verifyBuffers(bufferOld, bufferNew, 15L, 25L);
                this.verifyBuffers(bufferOld, bufferNew, 95L, 105L);
                this.verifyBuffers(bufferOld, bufferNew, 1L, 110L);
                this.verifyBuffers(bufferOld, bufferNew, 35L, 65L);
                this.verifyBuffers(bufferOld, bufferNew, 45L, 45L);
                this.verifyBuffers(bufferOld, bufferNew, 50L, 50L);
                this.verifyBuffers(bufferOld, bufferNew, 110L, 120L);
                this.verifyBuffers(bufferOld, bufferNew, 100L, 110L);
                this.verifyBuffers(bufferOld, bufferNew, 0L, 5L);
                this.verifyBuffers(bufferOld, bufferNew, 0L, 10L);
                this.verifyBuffers(bufferOld, bufferNew, 10L, 80L);
                this.verifyBuffers(bufferOld, bufferNew, 20L, 75L);
                this.verifyBuffers(bufferOld, bufferNew, 25L, 70L);
                this.verifyBuffers(bufferOld, bufferNew, 15L, 95L);
            }
        }
    }

    @Test
    public void testExamineDataRetrieve() {
        for (int iteration = 0; iteration < 1000; ++iteration) {
            HistoryBufferOld bufferOld = new HistoryBufferOld(RECORD, false);
            HistoryBuffer bufferNew = new HistoryBuffer(RECORD, false);
            int[] elements = RANDOM.ints(1100L).distinct().toArray();
            this.generateHistoryBuffer(elements, bufferOld, bufferNew, false);
            for (int i : elements) {
                if (!RANDOM.nextBoolean()) continue;
                this.putToBuffers(i, bufferOld, bufferNew, true);
            }
            Arrays.sort(elements);
            int min = elements[0];
            int max = elements[elements.length - 1];
            Assert.assertEquals((long)bufferOld.size(), (long)bufferNew.size());
            this.verifyBuffers(bufferOld, bufferNew, min, max + 1);
            long timeKnown = RANDOM.nextInt(max + 1);
            long toTime = RANDOM.nextInt((int)timeKnown + 1);
            int limit = RANDOM.nextInt(max + 1);
            int snapshotEndFlag = RANDOM.nextBoolean() ? History.SNAPSHOT_END : History.SNAPSHOT_SNIP;
            boolean txEnd = RANDOM.nextBoolean();
            boolean useFlags = RANDOM.nextBoolean();
            RecordBuffer removeBufferOld = RecordBuffer.getInstance((RecordMode)RecordMode.DATA);
            RecordBuffer removeBufferNew = RecordBuffer.getInstance((RecordMode)RecordMode.DATA);
            bufferOld.examineDataRetrieve(RECORD, 1, "TEST", timeKnown, toTime, (RecordSink)removeBufferOld, new RecordCursorKeeperOld(), null, limit, History.SNAPSHOT_BEGIN, snapshotEndFlag, txEnd, useFlags);
            bufferNew.examineDataRetrieve(RECORD, 1, "TEST", timeKnown, toTime, (RecordSink)removeBufferNew, new RecordCursorKeeper(), null, limit, History.SNAPSHOT_BEGIN, snapshotEndFlag, txEnd, useFlags);
            this.compareRecordBuffers(removeBufferOld, removeBufferNew);
            this.verifyBuffers(bufferOld, bufferNew, min, max + 1);
        }
    }

    @Test
    public void testGapOverflow() {
        HistoryBufferOld bufferOld = new HistoryBufferOld(RECORD, false);
        HistoryBuffer bufferNew = new HistoryBuffer(RECORD, false);
        long left = -9223372036853775808L;
        long right = 9223372036853775807L;
        for (int i = 0; i < 1000; ++i) {
            this.putToBuffers(left - (long)i, bufferOld, bufferNew, false);
            this.putToBuffers(right + (long)i, bufferOld, bufferNew, false);
        }
        this.verifyBuffers(bufferOld, bufferNew, Long.MIN_VALUE, Long.MAX_VALUE);
        this.putToBuffers(right / 2L, bufferOld, bufferNew, false);
        this.verifyBuffers(bufferOld, bufferNew, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    private void generateHistoryBuffer(int[] ids, HistoryBufferOld bufferOld, HistoryBuffer bufferNew, boolean remove) {
        for (int i : ids) {
            this.putToBuffers(i, bufferOld, bufferNew, remove);
            Assert.assertEquals((long)bufferOld.size(), (long)bufferNew.size());
            Assert.assertEquals((long)bufferOld.getMaxAvailableTime(), (long)bufferNew.getMaxAvailableTime());
            Assert.assertEquals((long)bufferOld.getMinAvailableTime(), (long)bufferNew.getMinAvailableTime());
        }
    }

    private void putToBuffers(long i, HistoryBufferOld bufferOld, HistoryBuffer bufferNew, boolean remove) {
        RecordBuffer recordBuffer = this.createRecordBuffer(i);
        RecordCursor cursor = recordBuffer.current();
        bufferOld.putRecord(i, cursor, remove, QD_STATS, 0);
        bufferNew.putRecord(i, cursor, remove, QD_STATS, 0);
    }

    private void verifyBuffers(HistoryBufferOld bufferOld, HistoryBuffer bufferNew, long startTime, long endTime) {
        bufferNew.selfValidate();
        RecordBuffer sinkOld = RecordBuffer.getInstance((RecordMode)RecordMode.DATA);
        RecordBuffer sinkNew = RecordBuffer.getInstance((RecordMode)RecordMode.DATA);
        boolean resultOld = bufferOld.examineDataRangeLTR(RECORD, 0, "TEST_", startTime, endTime, (RecordSink)sinkOld, new RecordCursorKeeperOld(), null);
        boolean resultNew = bufferNew.examineDataRangeLTR(RECORD, 0, "TEST_", startTime, endTime, (RecordSink)sinkNew, new RecordCursorKeeper(), null);
        Assert.assertEquals((Object)resultOld, (Object)resultNew);
        this.compareBuffer(bufferOld, bufferNew, sinkOld, sinkNew, startTime, endTime);
        sinkOld = RecordBuffer.getInstance((RecordMode)RecordMode.DATA);
        sinkNew = RecordBuffer.getInstance((RecordMode)RecordMode.DATA);
        resultOld = bufferOld.examineDataRangeRTL(RECORD, 0, "TEST_", endTime, startTime, (RecordSink)sinkOld, new RecordCursorKeeperOld(), null);
        resultNew = bufferNew.examineDataRangeRTL(RECORD, 0, "TEST_", endTime, startTime, (RecordSink)sinkNew, new RecordCursorKeeper(), null);
        Assert.assertEquals((Object)resultOld, (Object)resultNew);
        this.compareBuffer(bufferOld, bufferNew, sinkOld, sinkNew, startTime, endTime);
    }

    private void compareBuffer(HistoryBufferOld firstHistoryBuffer, HistoryBuffer secondHistoryBuffer, RecordBuffer firstRecordBuffer, RecordBuffer secondRecordBuffer, long startTime, long endTime) {
        Assert.assertEquals((long)firstHistoryBuffer.size(), (long)secondHistoryBuffer.size());
        Assert.assertEquals((long)firstHistoryBuffer.getMaxAvailableTime(), (long)secondHistoryBuffer.getMaxAvailableTime());
        Assert.assertEquals((long)firstHistoryBuffer.getMinAvailableTime(), (long)secondHistoryBuffer.getMinAvailableTime());
        Assert.assertEquals((long)firstHistoryBuffer.getAvailableCount(startTime, endTime), (long)secondHistoryBuffer.getAvailableCount(startTime, endTime));
        Assert.assertEquals((long)firstHistoryBuffer.getAvailableCount((startTime * 3L + endTime) / 4L, (startTime + 3L * endTime) / 4L), (long)secondHistoryBuffer.getAvailableCount((startTime * 3L + endTime) / 4L, (startTime + 3L * endTime) / 4L));
        this.compareRecordBuffers(firstRecordBuffer, secondRecordBuffer);
    }

    private void compareRecordBuffers(RecordBuffer firstRecordBuffer, RecordBuffer secondRecordBuffer) {
        firstRecordBuffer.rewind();
        secondRecordBuffer.rewind();
        Assert.assertEquals((long)firstRecordBuffer.size(), (long)secondRecordBuffer.size());
        while (firstRecordBuffer.hasNext() && secondRecordBuffer.hasNext()) {
            int i;
            RecordCursor cursorOld = firstRecordBuffer.next();
            RecordCursor cursorNew = secondRecordBuffer.next();
            Assert.assertNotNull((Object)cursorOld);
            Assert.assertNotNull((Object)cursorNew);
            Assert.assertEquals((long)cursorOld.getIntCount(), (long)cursorNew.getIntCount());
            Assert.assertEquals((long)cursorOld.getObjCount(), (long)cursorNew.getObjCount());
            Assert.assertEquals((long)cursorOld.getCipher(), (long)cursorNew.getCipher());
            Assert.assertEquals((Object)cursorOld.getSymbol(), (Object)cursorNew.getSymbol());
            for (i = 0; i < cursorOld.getIntCount(); ++i) {
                Assert.assertEquals((long)cursorOld.getInt(i), (long)cursorNew.getInt(i));
            }
            for (i = 0; i < cursorNew.getObjCount(); ++i) {
                Assert.assertEquals((Object)cursorOld.getObj(i), (Object)cursorNew.getObj(i));
            }
        }
    }

    private RecordBuffer createRecordBuffer(long i) {
        RecordBuffer buf = new RecordBuffer(RecordMode.TIMESTAMPED_DATA.withEventTimeSequence());
        RecordCursor cur = buf.add(RECORD, 0, "Test");
        cur.setEventTimeSequence(i);
        int j = 0;
        while (j < RECORD.getIntFieldCount()) {
            if (RECORD.getIntField(j).getSerialType().isLong()) {
                cur.setLong(j, i);
                j += 2;
                continue;
            }
            cur.setInt(j++, this.iVal(i, j));
        }
        for (j = 0; j < RECORD.getObjFieldCount(); ++j) {
            cur.setObj(j, this.oVal(i, j));
        }
        return buf;
    }

    private int iVal(long i, int j) {
        return (int)(100000L * i + (long)j);
    }

    private Object oVal(long i, long j) {
        return i + "," + j;
    }

    public static void setFieldValue(Object object, String fieldName, Object valueTobeSet) throws Exception {
        Field field = object.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        field.set(object, valueTobeSet);
    }
}

