/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDFactory;
import com.devexperts.qd.SymbolCodec;
import com.devexperts.qd.impl.matrix.Collector;
import com.devexperts.qd.impl.matrix.StickySubscription;
import com.devexperts.qd.impl.matrix.Ticker;
import com.devexperts.qd.kit.DefaultRecord;
import com.devexperts.qd.kit.DefaultScheme;
import com.devexperts.qd.kit.PentaCodec;
import com.devexperts.qd.stats.QDStats;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;

public class StickySubscriptionTest {
    private static final MethodHandle STOP_SCHEDULER = StickySubscriptionTest.getMethodHandle("stopScheduler", new Class[0]);
    private static final DataRecord RECORD = new DefaultRecord(0, "Haba", false, null, null);
    private static final DataScheme SCHEME = new DefaultScheme((SymbolCodec)PentaCodec.INSTANCE, new DataRecord[]{RECORD});

    private static MethodHandle getMethodHandle(String name, Class<?> ... parameterTypes) {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Method method = StickySubscription.class.getDeclaredMethod(name, parameterTypes);
            method.setAccessible(true);
            MethodHandle methodHandle = lookup.unreflect(method);
            method.setAccessible(false);
            return methodHandle;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void setField(String fieldName, Object obj, long value) {
        try {
            Field field = StickySubscription.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.setLong(obj, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalStickyPeriodMin() {
        new StickySubscription(-1L, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalStickyPeriodMax() {
        new StickySubscription(TimeUnit.DAYS.toMillis(366L), null);
    }

    @Test(expected=NullPointerException.class)
    public void testNPECollector() {
        new StickySubscription(0L, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetIllegalStickyPeriod() {
        StickySubscription stickySubscription = new StickySubscription(1L, (Collector)this.getTicker());
        stickySubscription.setStickyPeriodGLocked(-1L);
    }

    @Test
    public void testInitDisabled() {
        StickySubscription stickySubscription = new StickySubscription(0L, (Collector)this.getTicker());
        Assert.assertTrue((boolean)stickySubscription.isEmpty());
        Assert.assertFalse((boolean)stickySubscription.isEnabled());
        Assert.assertEquals((long)0L, (long)stickySubscription.getStickyPeriod());
    }

    @Test
    public void testInitEnabled() {
        StickySubscription stickySubscription = new StickySubscription(1L, (Collector)this.getTicker());
        Assert.assertTrue((boolean)stickySubscription.isEmpty());
        Assert.assertTrue((boolean)stickySubscription.isEnabled());
        Assert.assertEquals((long)100L, (long)stickySubscription.getStickyPeriod());
    }

    @Test
    public void testChangeStickyPeriod() {
        StickySubscription stickySubscription = new StickySubscription(100L, (Collector)this.getTicker());
        Assert.assertTrue((boolean)stickySubscription.isEmpty());
        Assert.assertTrue((boolean)stickySubscription.isEnabled());
        Assert.assertEquals((long)100L, (long)stickySubscription.getStickyPeriod());
        long stickyPeriod = 200L;
        stickySubscription.setStickyPeriodGLocked(stickyPeriod);
        Assert.assertEquals((long)stickyPeriod, (long)stickySubscription.getStickyPeriod());
    }

    @Test
    public void testStickyBucketIndex() {
        Stream.of(1, 7, 11, 33, 57, 81, 100, 117, 342).map(stamp -> stamp * 100).forEach(period -> {
            try {
                long periodNanos = TimeUnit.MILLISECONDS.toNanos(period.intValue());
                int stickyBuckets = Math.toIntExact(Math.max(Math.min(StickySubscription.nanosToStamp((long)periodNanos), 100), 1));
                long step = periodNanos / (long)stickyBuckets;
                StickySubscription stickySubscription = new StickySubscription((long)period.intValue(), (Collector)this.getTicker());
                for (int stamp = 0; stamp < 10000; ++stamp) {
                    int index = stickySubscription.getStickyBucketIndex(stamp);
                    long stampNanos = StickySubscription.stampToNanos((long)stamp);
                    int expectedIndex = Math.toIntExact(stampNanos / step % 200L * 4L);
                    Assert.assertEquals((long)expectedIndex, (long)index);
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        });
    }

    @Test
    public void testSimpleStickyCleanupTask() throws Throwable {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Ticker ticker = this.getTicker(countDownLatch::countDown);
        ticker.startSubChangeBatch(0);
        StickySubscription stickySubscription = new StickySubscription(100L, (Collector)ticker);
        stickySubscription.updateCurrentStickyStamp();
        this.addStickySubscription(stickySubscription, ticker, 1);
        Assert.assertTrue((boolean)countDownLatch.await(2L, TimeUnit.SECONDS));
    }

    @Test
    public void testDisableStickyPeriod() throws Throwable {
        CountDownLatch countDownLatch = new CountDownLatch(2);
        Ticker ticker = this.getTicker(countDownLatch::countDown);
        ticker.startSubChangeBatch(0);
        StickySubscription stickySubscription = new StickySubscription(TimeUnit.DAYS.toMillis(365L), (Collector)ticker);
        stickySubscription.updateCurrentStickyStamp();
        this.addStickySubscription(stickySubscription, ticker, 1);
        this.addStickySubscription(stickySubscription, ticker, 2);
        stickySubscription.setStickyPeriodGLocked(0L);
        Assert.assertTrue((boolean)countDownLatch.await(2L, TimeUnit.SECONDS));
        Assert.assertFalse((boolean)stickySubscription.isEnabled());
        Assert.assertTrue((boolean)stickySubscription.isEmpty());
    }

    @Test
    public void testCloseStickySubscription() {
        AtomicInteger count = new AtomicInteger(0);
        Ticker ticker = this.getTicker(count::incrementAndGet);
        ticker.startSubChangeBatch(0);
        StickySubscription stickySubscription = new StickySubscription(TimeUnit.DAYS.toSeconds(365L), (Collector)ticker);
        stickySubscription.updateCurrentStickyStamp();
        this.addStickySubscription(stickySubscription, ticker, 1);
        this.addStickySubscription(stickySubscription, ticker, 2);
        StickySubscriptionTest.setField("stickyPeriod", stickySubscription, 1L);
        stickySubscription.close();
        Assert.assertEquals((long)0L, (long)count.get());
        Assert.assertFalse((boolean)stickySubscription.isEnabled());
        Assert.assertFalse((boolean)stickySubscription.isEmpty());
    }

    @Test
    public void testDirectInvokeDoCleanupStickySubscription() throws Throwable {
        CountDownLatch countDownLatch = new CountDownLatch(2);
        Ticker ticker = this.getTicker(countDownLatch::countDown);
        ticker.startSubChangeBatch(0);
        StickySubscription stickySubscription = new StickySubscription(TimeUnit.SECONDS.toMillis(10L), (Collector)ticker);
        stickySubscription.updateCurrentStickyStamp();
        this.addStickySubscription(stickySubscription, ticker, 1);
        this.addStickySubscription(stickySubscription, ticker, 2);
        STOP_SCHEDULER.invoke(stickySubscription);
        StickySubscriptionTest.setField("stickyPeriod", stickySubscription, 0L);
        stickySubscription.doCleanupStickySubscription();
        StickySubscriptionTest.setField("stickyPeriod", stickySubscription, 1L);
        Assert.assertTrue((boolean)countDownLatch.await(3L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)stickySubscription.isEnabled());
        Assert.assertTrue((boolean)stickySubscription.isEmpty());
    }

    @Test
    public void testInactivateStickySubscription() throws Throwable {
        AtomicInteger count = new AtomicInteger(0);
        Ticker ticker = this.getTicker(count::incrementAndGet);
        ticker.startSubChangeBatch(0);
        StickySubscription stickySubscription = new StickySubscription(TimeUnit.SECONDS.toMillis(1L), (Collector)ticker);
        stickySubscription.updateCurrentStickyStamp();
        this.addStickySubscription(stickySubscription, ticker, 1);
        STOP_SCHEDULER.invoke(stickySubscription);
        this.dropStickySubscription(stickySubscription, ticker, 1);
        StickySubscriptionTest.setField("stickyPeriod", stickySubscription, 0L);
        stickySubscription.doCleanupStickySubscription();
        StickySubscriptionTest.setField("stickyPeriod", stickySubscription, 1L);
        Assert.assertEquals((long)0L, (long)count.get());
        Assert.assertTrue((boolean)stickySubscription.isEnabled());
        Assert.assertTrue((boolean)stickySubscription.isEmpty());
    }

    @Test
    public void testRebuildStickySubscription() {
        AtomicInteger count = new AtomicInteger(0);
        Ticker ticker = this.getTicker(count::incrementAndGet);
        ticker.startSubChangeBatch(0);
        StickySubscription stickySubscription = new StickySubscription(TimeUnit.MINUTES.toMillis(10L), (Collector)ticker);
        this.addStickySubscription(stickySubscription, ticker, 1);
        this.addStickySubscription(stickySubscription, ticker, 2);
        this.addStickySubscription(stickySubscription, ticker, 3);
        stickySubscription.setStickyPeriodGLocked(TimeUnit.SECONDS.toMillis(1L));
        StickySubscriptionTest.setField("stickyPeriod", stickySubscription, 0L);
        stickySubscription.doCleanupStickySubscription();
        Assert.assertEquals((long)3L, (long)count.get());
        Assert.assertTrue((boolean)stickySubscription.isEmpty());
    }

    private void addStickySubscription(StickySubscription stickySubscription, Ticker ticker, int index) {
        stickySubscription.addStickySubscription(ticker.total.sub, index * 6);
    }

    private void dropStickySubscription(StickySubscription stickySubscription, Ticker ticker, int index) {
        stickySubscription.dropStickySubscription(ticker.total.sub, index * 6);
    }

    private Ticker getTicker() {
        return new TestTicker(null);
    }

    private Ticker getTicker(Runnable runnable) {
        return new TestTicker(runnable);
    }

    private static class TestTicker
    extends Ticker {
        private final Runnable runnable;

        TestTicker(Runnable runnable) {
            super(QDFactory.getDefaultFactory().tickerBuilder().withScheme(SCHEME).withStats(QDStats.VOID));
            this.runnable = runnable;
        }

        public void removeStickySubscription(int tindex) {
            this.runnable.run();
        }
    }
}

