/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

import com.devexperts.qd.QDAgent;
import com.devexperts.qd.QDDistributor;
import com.devexperts.qd.QDFactory;
import com.devexperts.qd.impl.matrix.AbstractCollectorTest;
import com.devexperts.qd.stats.QDStats;
import org.junit.Before;
import org.junit.Test;

public class TickerConflationTest
extends AbstractCollectorTest {
    @Before
    public void setUp() throws Exception {
        this.setUp(QDFactory.getDefaultFactory().tickerBuilder().withScheme(SCHEME).withStats(QDStats.VOID).build());
    }

    @Test
    public void testSnapshot() {
        this.process(arg_0 -> ((QDAgent)this.agent).addSubscription(arg_0), "SYMBOL_SYMBOL");
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "SYMBOL_SYMBOL", 100, 1);
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "SYMBOL_SYMBOL", 200, 2);
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "SYMBOL_SYMBOL", 300, 3);
        this.assertRetrieve("SYMBOL_SYMBOL", 300, 1);
    }

    @Test
    public void testSnapshotStoreEverything() {
        this.collector.setStoreEverything(true);
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "SYMBOL_SYMBOL", 100, 1);
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "SYMBOL_SYMBOL", 200, 2);
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "SYMBOL_SYMBOL", 300, 3);
        this.process(arg_0 -> ((QDAgent)this.agent).addSubscription(arg_0), "SYMBOL_SYMBOL");
        this.assertRetrieve("SYMBOL_SYMBOL", 300, 0);
    }

    @Test
    public void testResubscribeStoreEverything() {
        this.collector.setStoreEverything(true);
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "SYMBOL_SYMBOL", 100, 1);
        this.process(arg_0 -> ((QDAgent)this.agent).addSubscription(arg_0), "SYMBOL_SYMBOL");
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "SYMBOL_SYMBOL", 200, 2);
        this.process(arg_0 -> ((QDAgent)this.agent).addSubscription(arg_0), "SYMBOL_SYMBOL");
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "SYMBOL_SYMBOL", 300, 3);
        this.assertRetrieve("SYMBOL_SYMBOL", 300, 2);
    }

    @Test
    public void testTimeMark() {
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "SYMBOL_SYMBOL", 100, 1);
        this.process(arg_0 -> ((QDAgent)this.agent).addSubscription(arg_0), "SYMBOL_SYMBOL");
        this.assertRetrieveNothing();
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "SYMBOL_SYMBOL", 200, 2);
        this.assertRetrieve("SYMBOL_SYMBOL", 200, 2);
        this.process(arg_0 -> ((QDAgent)this.agent).removeSubscription(arg_0), "SYMBOL_SYMBOL");
        this.process(arg_0 -> ((QDAgent)this.agent).addSubscription(arg_0), "SYMBOL_SYMBOL");
        this.assertRetrieveNothing();
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "SYMBOL_SYMBOL", 300, 3);
        this.assertRetrieve("SYMBOL_SYMBOL", 300, 3);
    }

    @Test
    public void testTimeMarkStoreEverything() {
        this.collector.setStoreEverything(true);
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "SYMBOL_SYMBOL", 100, 1);
        this.process(arg_0 -> ((QDAgent)this.agent).addSubscription(arg_0), "SYMBOL_SYMBOL");
        this.assertRetrieve("SYMBOL_SYMBOL", 100, 0);
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "SYMBOL_SYMBOL", 200, 2);
        this.assertRetrieve("SYMBOL_SYMBOL", 200, 2);
        this.process(arg_0 -> ((QDAgent)this.agent).removeSubscription(arg_0), "SYMBOL_SYMBOL");
        this.process(arg_0 -> ((QDAgent)this.agent).addSubscription(arg_0), "SYMBOL_SYMBOL");
        this.assertRetrieve("SYMBOL_SYMBOL", 200, 0);
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "SYMBOL_SYMBOL", 300, 3);
        this.assertRetrieve("SYMBOL_SYMBOL", 300, 3);
    }

    @Test
    public void testConflatedTimeMark() {
        this.process(arg_0 -> ((QDAgent)this.agent).addSubscription(arg_0), "SYMBOL_SYMBOL");
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "SYMBOL_SYMBOL", 100, 1);
        this.assertRetrieve("SYMBOL_SYMBOL", 100, 1);
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "SYMBOL_SYMBOL", 200, 2);
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "SYMBOL_SYMBOL", 300, 3);
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "SYMBOL_SYMBOL", 400, 4);
        this.assertRetrieve("SYMBOL_SYMBOL", 400, 2);
    }

    @Test
    public void testConflatedTimeMarkStoreEverything() {
        this.collector.setStoreEverything(true);
        this.process(arg_0 -> ((QDAgent)this.agent).addSubscription(arg_0), "SYMBOL_SYMBOL");
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "SYMBOL_SYMBOL", 100, 1);
        this.assertRetrieve("SYMBOL_SYMBOL", 100, 1);
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "SYMBOL_SYMBOL", 200, 2);
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "SYMBOL_SYMBOL", 300, 3);
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "SYMBOL_SYMBOL", 400, 4);
        this.assertRetrieve("SYMBOL_SYMBOL", 400, 2);
    }
}

