/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

import com.devexperts.qd.QDAgent;
import com.devexperts.qd.QDDistributor;
import com.devexperts.qd.QDFactory;
import com.devexperts.qd.impl.matrix.AbstractCollectorTest;
import com.devexperts.qd.impl.matrix.Agent;
import com.devexperts.qd.impl.matrix.Ticker;
import com.devexperts.qd.ng.AbstractRecordProvider;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordMode;
import com.devexperts.qd.ng.RecordProvider;
import com.devexperts.qd.ng.RecordSink;
import com.devexperts.qd.stats.QDStats;
import org.junit.Before;
import org.junit.Test;

public class TickerSubscriptionTest
extends AbstractCollectorTest {
    static int BATCH_SIZE = Ticker.RETRIEVE_BATCH_SIZE;
    protected RecordProvider agentSnapshotProvider;
    protected RecordProvider agentUpdateProvider;

    @Before
    public void setUp() throws Exception {
        this.setUp(QDFactory.getDefaultFactory().tickerBuilder().withScheme(SCHEME).withStats(QDStats.VOID).build());
        this.agentSnapshotProvider = this.agent.getSnapshotProvider();
        this.agentUpdateProvider = new AbstractRecordProvider(){

            public RecordMode getMode() {
                return TickerSubscriptionTest.this.getRecordMode();
            }

            public boolean retrieve(RecordSink sink) {
                Agent a = (Agent)TickerSubscriptionTest.this.agent;
                if (!a.updateQueue.isEmpty()) {
                    Ticker ticker = (Ticker)TickerSubscriptionTest.this.collector;
                    a.updateQueue.retrieveForTicker(ticker, a, sink, BATCH_SIZE, 6);
                }
                return !a.updateQueue.isEmpty();
            }
        };
    }

    @Test
    public void testSnapshotViaSnapshotQueue() {
        this.process(arg_0 -> ((QDAgent)this.agent).addSubscription(arg_0), "AAPL_AAPL_AAPL");
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "AAPL_AAPL_AAPL", 1, 1);
        this.assertRetrieve(this.agentSnapshotProvider, "AAPL_AAPL_AAPL", 1, 1, 0L);
        this.assertRetrieveNothing(this.agentUpdateProvider);
    }

    @Test
    public void testSnapshotViaUpdateQueue() {
        this.process(arg_0 -> ((QDAgent)this.agent).addSubscription(arg_0), "AAPL_AAPL_AAPL");
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "AAPL_AAPL_AAPL", 1, 1);
        this.assertRetrieve(this.agentUpdateProvider, "AAPL_AAPL_AAPL", 1, 1, 0L);
        this.assertRetrieveNothing(this.agentSnapshotProvider);
    }

    @Test
    public void testUpdateAfterSnapshot() {
        this.process(arg_0 -> ((QDAgent)this.agent).addSubscription(arg_0), "AAPL_AAPL_AAPL");
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "AAPL_AAPL_AAPL", 1, 1);
        this.assertRetrieve(this.agentSnapshotProvider, "AAPL_AAPL_AAPL", 1, 1, 0L);
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "AAPL_AAPL_AAPL", 2, 2);
        this.assertRetrieveNothing(this.agentSnapshotProvider);
        this.assertRetrieve(this.agentUpdateProvider, "AAPL_AAPL_AAPL", 2, 2, 0L);
    }

    @Test
    public void testUpdateAfterSnapshotViaUpdateQueue() {
        this.process(arg_0 -> ((QDAgent)this.agent).addSubscription(arg_0), "AAPL_AAPL_AAPL");
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "AAPL_AAPL_AAPL", 1, 1);
        this.assertRetrieve(this.agentUpdateProvider, "AAPL_AAPL_AAPL", 1, 1, 0L);
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "AAPL_AAPL_AAPL", 2, 2);
        this.assertRetrieve(this.agentUpdateProvider, "AAPL_AAPL_AAPL", 2, 2, 0L);
        this.assertRetrieveNothing(this.agentSnapshotProvider);
        this.assertRetrieveNothing(this.agentUpdateProvider);
    }

    @Test
    public void testNoSnapshotAfterUnsubscribe() {
        this.process(arg_0 -> ((QDAgent)this.agent).addSubscription(arg_0), "AAPL_AAPL_AAPL");
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "AAPL_AAPL_AAPL", 1, 1);
        this.process(arg_0 -> ((QDAgent)this.agent).removeSubscription(arg_0), "AAPL_AAPL_AAPL");
        this.assertRetrieveNothing(this.agentSnapshotProvider);
        this.assertRetrieveNothing(this.agentUpdateProvider);
    }

    @Test
    public void testNoUpdateAfterUnsubscribe() {
        this.process(arg_0 -> ((QDAgent)this.agent).addSubscription(arg_0), "AAPL_AAPL_AAPL");
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "AAPL_AAPL_AAPL", 1, 1);
        this.assertRetrieve(this.agentUpdateProvider, "AAPL_AAPL_AAPL", 1, 1, 0L);
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "AAPL_AAPL_AAPL", 2, 2);
        this.process(arg_0 -> ((QDAgent)this.agent).removeSubscription(arg_0), "AAPL_AAPL_AAPL");
        this.assertRetrieveNothing(this.agentSnapshotProvider);
        this.assertRetrieveNothing(this.agentUpdateProvider);
    }

    @Test
    public void testNoSnapshotAfterResubscribe() {
        this.process(arg_0 -> ((QDAgent)this.agent).addSubscription(arg_0), "AAPL_AAPL_AAPL");
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "AAPL_AAPL_AAPL", 1, 1);
        this.process(arg_0 -> ((QDAgent)this.agent).removeSubscription(arg_0), "AAPL_AAPL_AAPL");
        this.process(arg_0 -> ((QDAgent)this.agent).addSubscription(arg_0), "AAPL_AAPL_AAPL");
        this.assertRetrieveNothing(this.agentSnapshotProvider);
        this.assertRetrieveNothing(this.agentUpdateProvider);
    }

    @Test
    public void testSnapshotQueueOddity() {
        this.process(arg_0 -> ((QDAgent)this.agent).addSubscription(arg_0), "AAPL_AAPL_AAPL");
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "AAPL_AAPL_AAPL", 1, 1);
        this.assertRetrieve(this.agentUpdateProvider, "AAPL_AAPL_AAPL", 1, 1, 0L);
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "AAPL_AAPL_AAPL", 2, 2);
        this.assertRetrieve(this.agentSnapshotProvider, "AAPL_AAPL_AAPL", 2, 2, 0L);
        this.assertRetrieveNothing(this.agentSnapshotProvider);
        this.assertRetrieveNothing(this.agentUpdateProvider);
    }

    @Test
    public void testResubscribeForReappearingSnapshot() {
        this.process(arg_0 -> ((QDAgent)this.agent).addSubscription(arg_0), "AAPL_AAPL_AAPL");
        this.process(arg_0 -> ((QDAgent)this.agent).addSubscription(arg_0), "MSFT_MSFT_MSFT");
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "AAPL_AAPL_AAPL", 100, 1);
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "MSFT_MSFT_MSFT", 200, 2);
        this.process(arg_0 -> ((QDAgent)this.agent).removeSubscription(arg_0), "MSFT_MSFT_MSFT");
        this.process(arg_0 -> ((QDAgent)this.agent).addSubscription(arg_0), "MSFT_MSFT_MSFT");
        this.assertRetrieve("AAPL_AAPL_AAPL", 100, 1);
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "MSFT_MSFT_MSFT", 300, 3);
        this.assertRetrieve(this.agentSnapshotProvider, "MSFT_MSFT_MSFT", 300, 3, 0L);
        this.assertRetrieveNothing();
    }

    @Test
    public void testResubscribeForExistingSnapshotViaSnapshotQueue() {
        this.resubscribeForExistingSnapshot();
        this.assertRetrieve(this.agentSnapshotProvider, "AAPL_AAPL_AAPL", 0, 0, 0L);
        this.assertRetrieve(this.agentSnapshotProvider, "MSFT_MSFT_MSFT", 0, 0, 0L);
        this.assertRetrieveNothing();
    }

    @Test
    public void testResubscribeForExistingSnapshotViaUpdateQueue() {
        this.resubscribeForExistingSnapshot();
        this.assertRetrieve(this.agentUpdateProvider, "AAPL_AAPL_AAPL", 0, 0, 0L);
        this.assertRetrieve(this.agentUpdateProvider, "MSFT_MSFT_MSFT", 0, 0, 0L);
        this.assertRetrieveNothing();
    }

    private void resubscribeForExistingSnapshot() {
        this.collector.setStoreEverything(true);
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "AAPL_AAPL_AAPL");
        this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "MSFT_MSFT_MSFT");
        this.process(arg_0 -> ((QDAgent)this.agent).addSubscription(arg_0), "AAPL_AAPL_AAPL");
        this.process(arg_0 -> ((QDAgent)this.agent).addSubscription(arg_0), "MSFT_MSFT_MSFT");
        this.process(arg_0 -> ((QDAgent)this.agent).removeSubscription(arg_0), "MSFT_MSFT_MSFT");
        this.process(arg_0 -> ((QDAgent)this.agent).addSubscription(arg_0), "MSFT_MSFT_MSFT");
    }

    @Test
    public void testRetrieveSnapshotUpdateBalance() {
        int[] batches;
        int i;
        String[] SYMBOLS = new String[BATCH_SIZE * 8];
        for (i = 0; i < SYMBOLS.length; ++i) {
            SYMBOLS[i] = String.format("%08d", i);
            this.process(arg_0 -> ((QDAgent)this.agent).addSubscription(arg_0), SYMBOLS[i]);
        }
        for (i = 0; i < SYMBOLS.length / 2; ++i) {
            this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), SYMBOLS[i], i + 100, 1);
            this.assertRetrieve(this.agentSnapshotProvider, SYMBOLS[i], i + 100, 1, 0L);
        }
        for (i = 0; i < SYMBOLS.length; ++i) {
            this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), SYMBOLS[i], i, 1);
        }
        for (int batch : batches = new int[]{0, 4, 1, 5, 2, 6, 3, 7}) {
            RecordBuffer buff = RecordBuffer.getInstance((RecordMode)this.getRecordMode());
            buff.setCapacityLimit(BATCH_SIZE);
            this.agent.retrieve((RecordSink)buff);
            for (int i2 = 0; i2 < BATCH_SIZE; ++i2) {
                int offset = BATCH_SIZE * batch + i2;
                this.assertRetrieve((RecordProvider)buff, SYMBOLS[offset], offset, 1, 0L);
            }
            buff.release();
        }
        this.assertRetrieveNothing();
    }
}

