/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.symbol;

import com.devexperts.qd.impl.symbol.SymbolCache;
import org.junit.Assert;
import org.junit.Test;

public class SymbolCacheTest {
    public static final String SYMBOL = "ABCD";

    @Test
    public void testCacheBuilder() {
        Assert.assertNotNull((Object)SymbolCache.newBuilder().withTtl(10000L).withSharding(4).build());
        Assert.assertThrows(NullPointerException.class, () -> SymbolCache.newBuilder().withClock(null).build());
        Assert.assertThrows(IllegalArgumentException.class, () -> SymbolCache.newBuilder().withInitialCapacity(-1).build());
        Assert.assertThrows(IllegalArgumentException.class, () -> SymbolCache.newBuilder().withTtl(-1L).build());
        Assert.assertThrows(IllegalArgumentException.class, () -> SymbolCache.newBuilder().withSharding(-1).build());
    }

    @Test
    public void testEmbedKey() {
        String symbol = "SYMBOL";
        char[] chars = SymbolCacheTest.toKey(symbol);
        Assert.assertTrue((boolean)SymbolCache.isKey((char[])chars, (int)6));
        Assert.assertEquals((long)57342L, (long)chars[0]);
        Assert.assertEquals((long)57343L, (long)chars[1]);
        Assert.assertEquals((long)symbol.length(), (long)SymbolCache.lengthFromKey((char[])chars));
    }

    @Test
    public void testGetByString() {
        SymbolCache cache = SymbolCache.newBuilder().build();
        String result = cache.resolve(SYMBOL);
        Assert.assertEquals((Object)SYMBOL, (Object)result);
        Assert.assertSame((Object)result, (Object)cache.getIfPresent(SYMBOL));
        Assert.assertNull((Object)cache.getIfPresent("BCDF"));
    }

    @Test
    public void testGetByChars() {
        SymbolCache cache = SymbolCache.newBuilder().build();
        String result = cache.resolveKey(SymbolCacheTest.toKey(SYMBOL));
        Assert.assertEquals((Object)SYMBOL, (Object)result);
        Assert.assertSame((Object)result, (Object)cache.getIfPresent(SYMBOL));
    }

    @Test
    public void testResolveTtl() {
        SymbolCache cache = SymbolCache.newBuilder().withTtl(0L).build();
        Assert.assertSame((Object)SYMBOL, (Object)cache.resolve(SYMBOL));
        Assert.assertSame((Object)SYMBOL, (Object)cache.getIfPresent(SYMBOL));
        cache.cleanUp();
        Assert.assertNull((Object)cache.getIfPresent(SYMBOL));
    }

    @Test
    public void testAcquireReleaseTtl() {
        SymbolCache cache = SymbolCache.newBuilder().withTtl(0L).build();
        Assert.assertSame((Object)SYMBOL, (Object)cache.resolveAndAcquire(SYMBOL));
        Assert.assertSame((Object)SYMBOL, (Object)cache.getIfPresent(SYMBOL));
        Assert.assertSame((Object)SYMBOL, (Object)cache.resolve(new String(SYMBOL.toCharArray())));
        cache.release(SYMBOL);
        Assert.assertSame((Object)SYMBOL, (Object)cache.getIfPresent(SYMBOL));
        cache.cleanUp();
        Assert.assertNull((Object)cache.getIfPresent(SYMBOL));
    }

    private static char[] toKey(String symbol) {
        int length = symbol.length();
        char[] key = new char[length + 6];
        System.arraycopy(symbol.toCharArray(), 0, key, 6, length);
        return SymbolCache.embedKey((char[])key, (int)6, (int)length);
    }
}

