/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.kit;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDFilter;
import com.devexperts.qd.SymbolCodec;
import com.devexperts.qd.SymbolStriper;
import com.devexperts.qd.kit.CompositeFilters;
import com.devexperts.qd.kit.DefaultScheme;
import com.devexperts.qd.kit.HashFilter;
import com.devexperts.qd.kit.HashStriper;
import com.devexperts.qd.kit.MonoStriper;
import com.devexperts.qd.kit.PentaCodec;
import java.util.BitSet;
import org.junit.Assert;
import org.junit.Test;

public class HashFilterStriperTest {
    private static final DataScheme SCHEME = new DefaultScheme((SymbolCodec)PentaCodec.INSTANCE, new DataRecord[0]);

    @Test(expected=IllegalArgumentException.class)
    public void testHashStriperInvalidCountNotPowerOfTwo() {
        HashStriper.valueOf((DataScheme)SCHEME, (int)5);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHashStriperInvalidCountZero() {
        HashStriper.valueOf((DataScheme)SCHEME, (int)0);
    }

    @Test
    public void testHashStriperMono() {
        Assert.assertSame((Object)MonoStriper.INSTANCE, (Object)HashStriper.valueOf((DataScheme)SCHEME, (int)1));
        Assert.assertEquals((Object)"by1", (Object)HashStriper.valueOf((DataScheme)SCHEME, (int)1).toString());
    }

    @Test
    public void testHashStriper() {
        SymbolStriper hash = HashStriper.valueOf((DataScheme)SCHEME, (int)16);
        Assert.assertNotNull((Object)hash);
        Assert.assertEquals((long)16L, (long)hash.getStripeCount());
        Assert.assertEquals((Object)"byhash16", (Object)hash.getName());
    }

    @Test
    public void testHashStriperIndex() {
        SymbolStriper hash = HashStriper.valueOf((DataScheme)SCHEME, (int)16);
        Assert.assertNotNull((Object)hash);
        Assert.assertEquals((long)14L, (long)hash.getStripeIndex(SCHEME.getCodec().encode("IBM"), null));
        Assert.assertEquals((long)14L, (long)hash.getStripeIndex(0, "IBM"));
    }

    @Test
    public void testHashStriperFilterCache() {
        SymbolStriper hash = HashStriper.valueOf((DataScheme)SCHEME, (int)16);
        Assert.assertNotNull((Object)hash);
        Assert.assertSame((Object)hash.getStripeFilter(4), (Object)hash.getStripeFilter(4));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHashFilterInvalid() {
        HashFilter.valueOf((DataScheme)SCHEME, (String)"hash");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHashFilterNotANumber() {
        HashFilter.valueOf((DataScheme)SCHEME, (String)"hashAofB");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHashFilterInvalidCount() {
        HashFilter.valueOf((DataScheme)SCHEME, (String)"hash5of7");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHashFilterInvalidIndex() {
        HashFilter.valueOf((DataScheme)SCHEME, (String)"hash16of16");
    }

    @Test
    public void testHashFilter() {
        SymbolStriper hash = HashStriper.valueOf((DataScheme)SCHEME, (int)16);
        QDFilter filter = hash.getStripeFilter(14);
        Assert.assertNotNull((Object)filter);
        Assert.assertEquals((Object)"hash14of16", (Object)filter.toString());
        Assert.assertTrue((boolean)filter.accept(null, null, SCHEME.getCodec().encode("IBM"), null));
        Assert.assertTrue((boolean)filter.accept(null, null, 0, "IBM"));
    }

    @Test
    public void testHashFilterFormatting() {
        Assert.assertEquals((Object)"hash0001of1024", (Object)HashFilter.formatName((int)1, (int)1024));
        HashStriper striper = (HashStriper)HashStriper.valueOf((DataScheme)SCHEME, (int)1024);
        Assert.assertEquals((Object)"hash0001of1024", (Object)new HashFilter(striper, 1).toString());
    }

    @Test
    public void testHashDifferentFormatting() {
        HashFilter f1 = (HashFilter)HashFilter.valueOf((DataScheme)SCHEME, (String)"hash0of1024");
        Assert.assertNotNull((Object)f1);
        Assert.assertEquals((Object)"hash0of1024", (Object)f1.toString());
        HashFilter f2 = (HashFilter)HashFilter.valueOf((DataScheme)SCHEME, (String)"hash00of1024");
        Assert.assertNotNull((Object)f2);
        Assert.assertEquals((Object)"hash00of1024", (Object)f2.toString());
        HashFilter f3 = (HashFilter)HashFilter.valueOf((DataScheme)SCHEME, (String)"hash000of1024");
        Assert.assertNotNull((Object)f3);
        Assert.assertEquals((Object)"hash000of1024", (Object)f3.toString());
    }

    @Test
    public void testHashIntersectsFilter() {
        BitSet set;
        SymbolStriper s1 = HashStriper.valueOf((DataScheme)SCHEME, (int)8);
        SymbolStriper s2 = HashStriper.valueOf((DataScheme)SCHEME, (int)64);
        int ratio = s2.getStripeCount() / s1.getStripeCount();
        for (int i = 0; i < s1.getStripeCount(); ++i) {
            HashFilter f1 = (HashFilter)s1.getStripeFilter(i);
            set = s2.getIntersectingStripes((QDFilter)f1);
            for (int j = 0; j < s2.getStripeCount(); ++j) {
                HashFilter f2 = (HashFilter)s2.getStripeFilter(j);
                if (j / ratio == i) {
                    Assert.assertTrue((String)(f1 + " should intersect with " + f2), (boolean)set.get(j));
                    continue;
                }
                Assert.assertFalse((String)(f1 + " should not intersect with " + f2), (boolean)set.get(j));
            }
        }
        for (int j = 0; j < s2.getStripeCount(); ++j) {
            HashFilter f2 = (HashFilter)s2.getStripeFilter(j);
            set = s1.getIntersectingStripes((QDFilter)f2);
            for (int i = 0; i < s1.getStripeCount(); ++i) {
                HashFilter f1 = (HashFilter)s1.getStripeFilter(i);
                if (j / ratio == i) {
                    Assert.assertTrue((String)(f1 + " should intersect with " + f2), (boolean)set.get(i));
                    continue;
                }
                Assert.assertFalse((String)(f1 + " should not intersect with " + f2), (boolean)set.get(i));
            }
        }
    }

    @Test
    public void testHashIntersectsUnknownFilter() {
        SymbolStriper striper = HashStriper.valueOf((DataScheme)SCHEME, (int)8);
        Assert.assertNull((Object)striper.getIntersectingStripes(QDFilter.ANYTHING));
        Assert.assertNull((Object)striper.getIntersectingStripes(QDFilter.NOTHING));
        Assert.assertNull((Object)striper.getIntersectingStripes(CompositeFilters.valueOf((String)"A*", (DataScheme)SCHEME)));
    }
}

