/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.ng;

import com.devexperts.qd.DataIntField;
import com.devexperts.qd.DataObjField;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.kit.CompactIntField;
import com.devexperts.qd.kit.DefaultRecord;
import com.devexperts.qd.kit.MarshalledObjField;
import com.devexperts.qd.ng.EventFlag;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.ng.RecordMode;
import com.devexperts.qd.ng.RecordSource;
import java.util.ArrayList;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;

public class RecordBufferTest {
    private static final int BUFFER_SIZE = 10;
    private static final DataRecord RECORD = new DefaultRecord(0, "Test", true, new DataIntField[]{new CompactIntField(0, "Test.Int0"), new CompactIntField(1, "Test.Int1"), new CompactIntField(2, "Test.Int2")}, new DataObjField[]{new MarshalledObjField(0, "Test.Obj0"), new MarshalledObjField(1, "Test.Obj1")});
    private static final DataRecord RECORD2 = new DefaultRecord(1, "Test2", true, new DataIntField[]{new CompactIntField(0, "Test2.Int0"), new CompactIntField(1, "Test2.Int1")}, new DataObjField[]{new MarshalledObjField(0, "Test2.Obj0")});
    private static final DataRecord RECORD_REPLACE = new DefaultRecord(0, "Test_Replace", true, new DataIntField[]{new CompactIntField(0, "Test_Replace.Int0"), new CompactIntField(1, "Test_Replace.Int1"), new CompactIntField(2, "Test_Replace.Int2")}, new DataObjField[]{new MarshalledObjField(0, "Test_Replace.Obj0"), new MarshalledObjField(1, "Test_Replace.Obj1")});
    private static final DataRecord RECORD_REPLACE2 = new DefaultRecord(1, "Test_Replace2", true, new DataIntField[]{new CompactIntField(0, "Test_Replace2.Int0"), new CompactIntField(1, "Test_Replace2.Int1")}, new DataObjField[]{new MarshalledObjField(0, "Test_Replace2.Obj0")});

    @Test
    public void testGetAt() {
        RecordCursor cur;
        int i;
        RecordBuffer buf = new RecordBuffer(RecordMode.DATA.withEventTimeSequence());
        for (i = 1; i <= 100; ++i) {
            int j;
            cur = buf.add(this.record(i), i, this.symbol(i));
            cur.setEventTimeSequence(this.eventTimeSequence(i));
            for (j = 0; j < cur.getIntCount(); ++j) {
                cur.setInt(j, this.iVal(i, j));
            }
            for (j = 0; j < cur.getObjCount(); ++j) {
                cur.setObj(j, this.oVal(i, j));
            }
        }
        Assert.assertEquals((long)100L, (long)buf.size());
        Assert.assertEquals((long)0L, (long)buf.getPosition());
        for (i = 1; i <= 100; ++i) {
            int j;
            cur = buf.next();
            Assert.assertNotNull((Object)cur);
            Assert.assertEquals((Object)this.record(i), (Object)cur.getRecord());
            Assert.assertEquals((long)i, (long)cur.getCipher());
            Assert.assertEquals((Object)this.symbol(i), (Object)cur.getSymbol());
            Assert.assertEquals((long)this.eventTimeSequence(i), (long)cur.getEventTimeSequence());
            long position = cur.getPosition();
            Assert.assertEquals((Object)this.record(i), (Object)buf.getRecordAt(position));
            Assert.assertEquals((long)i, (long)buf.getCipherAt(position));
            Assert.assertEquals((Object)this.symbol(i), (Object)buf.getSymbolAt(position));
            Assert.assertEquals((long)this.eventTimeSequence(i), (long)buf.getEventTimeSequenceAt(position));
            for (j = 0; j < cur.getIntCount(); ++j) {
                Assert.assertEquals((long)this.iVal(i, j), (long)cur.getInt(j));
            }
            for (j = 0; j < cur.getObjCount(); ++j) {
                Assert.assertEquals((Object)this.oVal(i, j), (Object)cur.getObj(j));
            }
        }
        Assert.assertNull((Object)buf.next());
        Assert.assertEquals((long)buf.getLimit(), (long)buf.getPosition());
    }

    @Test
    public void testCompact() {
        HashSet<RecordMode> modes = new HashSet<RecordMode>();
        modes.add(RecordMode.DATA);
        modes.add(RecordMode.HISTORY_SUBSCRIPTION);
        modes.add(RecordMode.SUBSCRIPTION);
        modes.add(RecordMode.MARKED_DATA);
        modes.add(RecordMode.TIMESTAMPED_DATA);
        modes.add(RecordMode.DATA.withAttachment());
        modes.add(RecordMode.DATA.withTimeMark().withEventTimeSequence().withAttachment());
        modes.add(RecordMode.SUBSCRIPTION.withTimeMark().withEventTimeSequence().withAttachment());
        for (RecordMode mode : modes) {
            RecordCursor cur2;
            RecordBuffer buf = new RecordBuffer(mode);
            for (int i = 1; i <= 100; ++i) {
                int j;
                cur2 = buf.add(RECORD, i, null);
                for (j = 0; j < cur2.getIntCount(); ++j) {
                    cur2.setInt(j, this.iVal(i, j));
                }
                for (j = 0; j < cur2.getObjCount(); ++j) {
                    cur2.setObj(j, this.oVal(i, j));
                }
            }
            Assert.assertEquals((long)100L, (long)buf.size());
            Assert.assertEquals((long)0L, (long)buf.getPosition());
            boolean result = buf.compact(cur -> cur.getCipher() % 2 != 0);
            Assert.assertTrue((boolean)result);
            Assert.assertEquals((long)50L, (long)buf.size());
            Assert.assertEquals((long)0L, (long)buf.getPosition());
            int expect = 1;
            while ((cur2 = buf.next()) != null) {
                int j;
                Assert.assertEquals((long)expect, (long)cur2.getCipher());
                for (j = 0; j < cur2.getIntCount(); ++j) {
                    Assert.assertEquals((long)this.iVal(expect, j), (long)cur2.getInt(j));
                }
                for (j = 0; j < cur2.getObjCount(); ++j) {
                    Assert.assertEquals((Object)this.oVal(expect, j), (Object)cur2.getObj(j));
                }
                expect += 2;
            }
            Assert.assertEquals((long)101L, (long)expect);
            Assert.assertEquals((long)buf.getLimit(), (long)buf.getPosition());
        }
    }

    private DataRecord record(int i) {
        return i % 2 == 0 ? RECORD : RECORD2;
    }

    private String symbol(int i) {
        return String.valueOf(i);
    }

    private long eventTimeSequence(int i) {
        return ((long)(~i) << 32) + (long)i;
    }

    private int iVal(int i, int j) {
        return 123 + i + j * 3278;
    }

    private Object oVal(int i, int j) {
        return i + "," + j;
    }

    @Test
    public void testCompactCleanup1() {
        RecordBuffer buf = new RecordBuffer(RecordMode.FLAGGED_DATA);
        buf.add(RECORD, 1, null).setEventFlags(EventFlag.REMOVE_EVENT.flag());
        buf.add(RECORD, 2, null).setEventFlags(EventFlag.REMOVE_EVENT.flag());
        buf.add(RECORD, 3, null).setEventFlags(EventFlag.REMOVE_EVENT.flag());
        Assert.assertEquals((long)3L, (long)buf.size());
        buf.next();
        buf.next();
        buf.compact();
        Assert.assertEquals((long)1L, (long)buf.size());
        Assert.assertEquals((long)0L, (long)buf.getPosition());
        Assert.assertEquals((long)0L, (long)buf.add(RECORD, 4, null).getEventFlags());
        Assert.assertEquals((long)0L, (long)buf.add(RECORD, 5, null).getEventFlags());
    }

    @Test
    public void testCompactCleanup2() {
        RecordBuffer buf = new RecordBuffer(RecordMode.FLAGGED_DATA);
        buf.add(RECORD, 1, null).setEventFlags(EventFlag.REMOVE_EVENT.flag());
        buf.add(RECORD, 2, null).setEventFlags(EventFlag.REMOVE_EVENT.flag());
        buf.add(RECORD, 3, null).setEventFlags(EventFlag.REMOVE_EVENT.flag());
        Assert.assertEquals((long)3L, (long)buf.size());
        buf.next();
        buf.compact();
        Assert.assertEquals((long)2L, (long)buf.size());
        Assert.assertEquals((long)0L, (long)buf.getPosition());
        Assert.assertEquals((long)0L, (long)buf.add(RECORD, 4, null).getEventFlags());
        Assert.assertEquals((long)0L, (long)buf.add(RECORD, 5, null).getEventFlags());
    }

    @Test
    public void testUnlink() {
        RecordBuffer buf = new RecordBuffer(RecordMode.DATA.withLink());
        RecordCursor cur = buf.add(RECORD, 1, null);
        long pos1 = cur.getPosition();
        cur = buf.add(RECORD, 2, null);
        cur.setLinkTo(pos1);
        long pos2 = cur.getPosition();
        cur = buf.add(RECORD, 3, null);
        long pos3 = cur.getPosition();
        cur = buf.add(RECORD, 4, null);
        cur.setLinkTo(pos2);
        long pos4 = cur.getPosition();
        cur = buf.add(RECORD, 5, null);
        long pos5 = cur.getPosition();
        cur = buf.add(RECORD, 6, null);
        long pos6 = cur.getPosition();
        cur = buf.add(RECORD, 7, null);
        cur.setLinkTo(pos5);
        long pos7 = cur.getPosition();
        cur = buf.add(RECORD, 8, null);
        cur.setLinkTo(pos6);
        long pos8 = cur.getPosition();
        this.checkUnlinked(buf, new int[0]);
        buf.unlinkFrom(pos4);
        this.checkUnlinked(buf, 1, 2, 4);
        buf.unlinkFrom(pos8);
        this.checkUnlinked(buf, 1, 2, 4, 6, 8);
        buf.unlinkFrom(pos3);
        this.checkUnlinked(buf, 1, 2, 3, 4, 6, 8);
        buf.unlinkFrom(pos7);
        this.checkUnlinked(buf, 1, 2, 3, 4, 5, 6, 7, 8);
    }

    private void checkUnlinked(RecordBuffer buf, int ... ciphers) {
        Assert.assertEquals((long)8L, (long)buf.size());
        int j = 0;
        for (int i = 1; i <= 8; ++i) {
            RecordCursor cur = buf.next();
            Assert.assertNotNull((Object)cur);
            Assert.assertEquals((long)i, (long)cur.getCipher());
            if (j < ciphers.length && ciphers[j] < i) {
                ++j;
            }
            boolean shallBeUnlinked = j < ciphers.length && ciphers[j] == i;
            Assert.assertEquals((Object)shallBeUnlinked, (Object)cur.isUnlinked());
        }
        buf.rewind();
    }

    @Test
    public void testAddBetweenDifferentModes() {
        RecordBuffer buf1 = RecordBuffer.getInstance((RecordMode)RecordMode.DATA.withLink().withEventTimeSequence());
        RecordCursor cur = buf1.add(RECORD, 0, "TEST-SYM1");
        long baseEts = 81985529216486895L;
        cur.setEventTimeSequence(baseEts);
        long pos1 = cur.getPosition();
        cur = buf1.add(RECORD, 0, "TEST-SYM2");
        cur.setLinkTo(pos1);
        cur.setEventTimeSequence(baseEts << 1);
        long pos2 = cur.getPosition();
        cur = buf1.add(RECORD, 0, "TEST-SYM3");
        cur.setLinkTo(pos2);
        cur.setEventTimeSequence(baseEts << 2);
        Assert.assertEquals((String)"buf1.size", (long)3L, (long)buf1.size());
        RecordBuffer buf2 = RecordBuffer.getInstance((RecordMode)RecordMode.MARKED_DATA.withEventTimeSequence());
        buf2.process((RecordSource)buf1);
        Assert.assertEquals((String)"buf2.size", (long)3L, (long)buf1.size());
        cur = buf2.next();
        Assert.assertNotNull((Object)cur);
        Assert.assertEquals((String)"symbol1", (Object)"TEST-SYM1", (Object)cur.getSymbol());
        Assert.assertEquals((String)"mark1", (long)0L, (long)cur.getTimeMark());
        Assert.assertEquals((String)"ets1", (long)baseEts, (long)cur.getEventTimeSequence());
        cur = buf2.next();
        Assert.assertNotNull((Object)cur);
        Assert.assertEquals((String)"symbol2", (Object)"TEST-SYM2", (Object)cur.getSymbol());
        Assert.assertEquals((String)"mark2", (long)0L, (long)cur.getTimeMark());
        Assert.assertEquals((String)"ets2", (long)(baseEts << 1), (long)cur.getEventTimeSequence());
        cur = buf2.next();
        Assert.assertNotNull((Object)cur);
        Assert.assertEquals((String)"symbol3", (Object)"TEST-SYM3", (Object)cur.getSymbol());
        Assert.assertEquals((String)"mark3", (long)0L, (long)cur.getTimeMark());
        Assert.assertEquals((String)"ets3", (long)(baseEts << 2), (long)cur.getEventTimeSequence());
        Assert.assertNull((String)"no next", (Object)buf2.next());
    }

    @Test
    public void testFastCopy() {
        long baseEts = 81985529216486895L;
        RecordBuffer buf1 = RecordBuffer.getInstance((RecordMode)RecordMode.DATA.withEventTimeSequence());
        RecordCursor cur = buf1.add(RECORD, 0, "TEST-SYM1");
        cur.setEventTimeSequence(baseEts);
        cur = buf1.add(RECORD, 0, "TEST-SYM2");
        cur.setEventTimeSequence(baseEts << 1);
        cur = buf1.add(RECORD, 0, "TEST-SYM3");
        cur.setEventTimeSequence(baseEts << 2);
        Assert.assertEquals((String)"buf1.size", (long)3L, (long)buf1.size());
        RecordBuffer buf2 = RecordBuffer.getInstance((RecordMode)buf1.getMode());
        buf2.process((RecordSource)buf1);
        Assert.assertEquals((String)"buf2.size", (long)3L, (long)buf2.size());
        cur = buf2.next();
        Assert.assertNotNull((Object)cur);
        Assert.assertEquals((String)"symbol1", (Object)"TEST-SYM1", (Object)cur.getSymbol());
        Assert.assertEquals((String)"ets1", (long)baseEts, (long)cur.getEventTimeSequence());
        cur = buf2.next();
        Assert.assertNotNull((Object)cur);
        Assert.assertEquals((String)"symbol2", (Object)"TEST-SYM2", (Object)cur.getSymbol());
        Assert.assertEquals((String)"ets2", (long)(baseEts << 1), (long)cur.getEventTimeSequence());
        cur = buf2.next();
        Assert.assertNotNull((Object)cur);
        Assert.assertEquals((String)"symbol3", (Object)"TEST-SYM3", (Object)cur.getSymbol());
        Assert.assertEquals((String)"ets3", (long)(baseEts << 2), (long)cur.getEventTimeSequence());
        Assert.assertNull((String)"no next", (Object)buf2.next());
        buf1.rewind();
        buf1.next();
        RecordBuffer buf3 = RecordBuffer.getInstance((RecordMode)buf1.getMode());
        buf3.process((RecordSource)buf1);
        Assert.assertEquals((String)"buf3.size", (long)2L, (long)buf3.size());
        cur = buf3.next();
        Assert.assertNotNull((Object)cur);
        Assert.assertEquals((String)"symbol2", (Object)"TEST-SYM2", (Object)cur.getSymbol());
        Assert.assertEquals((String)"ets2", (long)(baseEts << 1), (long)cur.getEventTimeSequence());
        cur = buf3.next();
        Assert.assertNotNull((Object)cur);
        Assert.assertEquals((String)"symbol3", (Object)"TEST-SYM3", (Object)cur.getSymbol());
        Assert.assertEquals((String)"ets3", (long)(baseEts << 2), (long)cur.getEventTimeSequence());
        Assert.assertNull((String)"no next", (Object)buf3.next());
    }

    @Test
    public void testVoid() {
        Assert.assertNull((Object)RecordSource.VOID.current());
        Assert.assertNull((Object)RecordSource.VOID.next());
        Assert.assertEquals((long)0L, (long)RecordSource.VOID.getPosition());
        Assert.assertEquals((long)0L, (long)RecordSource.VOID.getLimit());
    }

    @Test
    public void removeRecordsExceptions() {
        RecordBuffer buf = this.createRecordBuffer();
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> buf.removeAt(Long.MAX_VALUE));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> buf.removeAt(Long.MIN_VALUE));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> buf.removeRange(0L, Long.MAX_VALUE));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> buf.removeRange(Long.MIN_VALUE, Long.MAX_VALUE));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> buf.removeRange(30L, 10L));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> buf.removeRange(0L, Long.MAX_VALUE));
    }

    @Test
    public void removeEmptyRange() {
        RecordBuffer buf = this.createRecordBuffer();
        int size = buf.size();
        buf.removeRange(0L, 0L);
        Assert.assertEquals((long)size, (long)buf.size());
        buf.removeRange(5L, 5L);
        Assert.assertEquals((long)size, (long)buf.size());
        while (buf.hasNext()) {
            buf.next();
        }
        long start = buf.getPosition();
        buf.removeRange(start, start);
        Assert.assertEquals((long)size, (long)buf.size());
    }

    @Test
    public void removeRecordAtAfterFullIteration() {
        for (int removeIndex = 1; removeIndex < 10; ++removeIndex) {
            this.removeRecordFullIteration(removeIndex);
        }
    }

    @Test
    public void removeRecordAtCursor() {
        for (int removeIndex = 1; removeIndex < 10; ++removeIndex) {
            for (int cursorPosition = 1; cursorPosition < 10; ++cursorPosition) {
                this.removeRecordAtCursorIntegrity(cursorPosition, removeIndex);
            }
        }
    }

    @Test
    public void removeRecordBufPosition() {
        for (int removeIndex = 1; removeIndex < 10; ++removeIndex) {
            for (int bufferPosition = 1; bufferPosition < 10; ++bufferPosition) {
                this.removeRecordAtBufPositionIntegrity(bufferPosition, bufferPosition);
            }
        }
    }

    @Test
    public void removeDifferentRangesOfRecords() {
        for (int start = 1; start < 10; ++start) {
            for (int end = start; end <= 10; ++end) {
                this.removeRangeOfRecords(start, end);
            }
        }
    }

    @Test
    public void removeRangeOfRecordsCursor() {
        for (int start = 1; start < 10; ++start) {
            for (int end = start; end <= 10; ++end) {
                for (int position = 1; position < 10; ++position) {
                    this.removeRecordAtCursorIntegrityRange(start, end, position);
                }
            }
        }
    }

    @Test
    public void removeRangeOfRecordsBufPosition() {
        for (int start = 1; start < 10; ++start) {
            for (int end = start; end <= 10; ++end) {
                for (int position = 1; position < 10; ++position) {
                    this.removeRecordAtBufPositionIntegrityRange(start, end, position);
                }
            }
        }
    }

    @Test
    public void replaceWithUninitializedCursors() {
        RecordBuffer buf = this.createRecordBuffer();
        RecordBuffer copy = new RecordBuffer(buf.getMode());
        copy.process((RecordSource)buf);
        copy.replaceSymbolAt(0L, 0, "SYMBOL_REPLACE1");
        copy.replaceRecordAt(0L, RECORD_REPLACE2);
        copy.current();
        copy.replaceSymbolAt(0L, 0, "SYMBOL_REPLACE2");
        copy.replaceRecordAt(0L, RECORD2);
        copy.writeCurrent();
        copy.replaceSymbolAt(0L, 0, "SYMBOL_REPLACE3");
        copy.replaceRecordAt(0L, RECORD_REPLACE2);
    }

    @Test
    public void replaceSymbolAt() {
        RecordBuffer buf = this.createRecordBuffer();
        int i = 0;
        while (buf.hasNext()) {
            long bufferPosition = buf.getPosition();
            RecordCursor readCursor = buf.current();
            RecordCursor writeCursor = buf.writeNext();
            Assert.assertNotNull((Object)readCursor);
            Assert.assertNotNull((Object)writeCursor);
            String symbol = "SYMBOL_REPLACE_" + i;
            int cipher = symbol.hashCode();
            buf.replaceSymbolAt(bufferPosition, cipher, symbol);
            Assert.assertEquals((Object)buf.getSymbolAt(bufferPosition), (Object)symbol);
            Assert.assertEquals((long)buf.getCipherAt(bufferPosition), (long)cipher);
            long writePosition = writeCursor.getPosition();
            buf.replaceSymbolAt(writePosition, cipher, symbol);
            Assert.assertEquals((Object)readCursor.getSymbol(), (Object)symbol);
            Assert.assertEquals((long)readCursor.getCipher(), (long)cipher);
            Assert.assertEquals((Object)writeCursor.getSymbol(), (Object)symbol);
            Assert.assertEquals((long)writeCursor.getCipher(), (long)cipher);
            ++i;
        }
    }

    @Test
    public void replaceRecordAt() {
        RecordBuffer buf = this.createRecordBuffer();
        while (buf.hasNext()) {
            long bufferPosition = buf.getPosition();
            RecordCursor readCursor = buf.current();
            RecordCursor writeCursor = buf.writeNext();
            Assert.assertNotNull((Object)readCursor);
            Assert.assertNotNull((Object)writeCursor);
            DataRecord record = buf.getRecordAt(bufferPosition);
            if (record == RECORD) {
                buf.replaceRecordAt(bufferPosition, RECORD_REPLACE);
                Assert.assertEquals((Object)readCursor.getRecord(), (Object)RECORD_REPLACE);
                Assert.assertEquals((Object)writeCursor.getRecord(), (Object)RECORD_REPLACE);
                continue;
            }
            if (record != RECORD2) continue;
            buf.replaceRecordAt(bufferPosition, RECORD_REPLACE2);
            Assert.assertEquals((Object)readCursor.getRecord(), (Object)RECORD_REPLACE2);
            Assert.assertEquals((Object)writeCursor.getRecord(), (Object)RECORD_REPLACE2);
        }
    }

    private void removeRangeOfRecords(int start, int end) {
        RecordCursor cursor;
        RecordBuffer buf = this.createRecordBuffer();
        long startPosition = 0L;
        long endPosition = -1L;
        ArrayList<String> records = new ArrayList<String>();
        int i = 1;
        while (buf.hasNext()) {
            cursor = buf.next();
            if (cursor != null) {
                if (i == start) {
                    startPosition = cursor.getPosition();
                }
                if (i == end) {
                    endPosition = cursor.getPosition();
                }
                if (i < start || i >= end) {
                    records.add(this.createStr(cursor));
                }
            }
            ++i;
        }
        if (endPosition == -1L) {
            endPosition = buf.getPosition();
        }
        buf.removeRange(startPosition, endPosition);
        buf.rewind();
        Assert.assertEquals((long)buf.size(), (long)records.size());
        i = 0;
        while (buf.hasNext()) {
            cursor = buf.next();
            Assert.assertNotNull((Object)cursor);
            Assert.assertEquals((Object)this.createStr(cursor), records.get(i));
            ++i;
        }
    }

    private void removeRecordAtCursorIntegrityRange(int start, int end, int cursorPosition) {
        RecordBuffer buf = this.createRecordBuffer();
        long startPosition = 0L;
        long endPosition = -1L;
        int i = 1;
        while (buf.hasNext()) {
            RecordCursor cursor = buf.next();
            if (cursor != null) {
                if (i == start) {
                    startPosition = cursor.getPosition();
                }
                if (i == end) {
                    endPosition = cursor.getPosition();
                }
            }
            ++i;
        }
        if (endPosition == -1L) {
            endPosition = buf.getPosition();
        }
        buf.rewind();
        RecordCursor read = null;
        RecordCursor write = null;
        int i2 = 1;
        while (buf.hasNext()) {
            RecordCursor cursor = buf.next();
            if (cursor != null) {
                long tmp = cursor.getPosition();
                if (i2 == cursorPosition) {
                    read = buf.cursorAt(tmp);
                    write = buf.writeCursorAt(tmp);
                    break;
                }
            }
            ++i2;
        }
        Assert.assertNotNull(read);
        Assert.assertNotNull(write);
        String readCursorStr = this.createStr(read);
        String writeCursorStr = this.createStr(write);
        buf.removeRange(startPosition, endPosition);
        if (cursorPosition >= start && cursorPosition < end) {
            Assert.assertEquals((long)this.getCursorIntOffset(read), (long)-2000000000L);
            Assert.assertEquals((long)this.getCursorObjOffset(read), (long)-2000000000L);
            Assert.assertEquals((long)this.getCursorIntOffset(write), (long)-2000000000L);
            Assert.assertEquals((long)this.getCursorObjOffset(write), (long)-2000000000L);
        } else {
            Assert.assertEquals((Object)readCursorStr, (Object)this.createStr(read));
            Assert.assertEquals((Object)writeCursorStr, (Object)this.createStr(write));
        }
    }

    private void removeRecordAtBufPositionIntegrityRange(int start, int end, int bufferPosition) {
        RecordBuffer buf = this.createRecordBuffer();
        int count = buf.size();
        long startPosition = 0L;
        long endPosition = -1L;
        ArrayList<String> records = new ArrayList<String>();
        int i = 1;
        while (buf.hasNext()) {
            RecordCursor cursor = buf.next();
            if (cursor != null) {
                records.add(this.createStr(cursor));
                if (i == start) {
                    startPosition = cursor.getPosition();
                }
                if (i == end) {
                    endPosition = cursor.getPosition();
                }
            }
            ++i;
        }
        if (endPosition == -1L) {
            endPosition = buf.getPosition();
        }
        buf.rewind();
        for (i = 1; buf.hasNext() && i < bufferPosition; ++i) {
            buf.next();
        }
        RecordCursor cursor = buf.current();
        Assert.assertNotNull((Object)cursor);
        String cursorStr = this.createStr(cursor);
        buf.removeRange(startPosition, endPosition);
        cursor = buf.current();
        if (bufferPosition < start || bufferPosition >= end) {
            Assert.assertNotNull((Object)cursor);
            Assert.assertEquals((Object)cursorStr, (Object)this.createStr(cursor));
        } else if (end != count + 1) {
            Assert.assertNotNull((Object)cursor);
            Assert.assertEquals(records.get(end - 1), (Object)this.createStr(cursor));
        } else {
            Assert.assertNull((Object)cursor);
        }
    }

    public void removeRecordFullIteration(int removeAt) {
        RecordCursor cursor;
        RecordBuffer buf = this.createRecordBuffer();
        long position = 0L;
        ArrayList<String> records = new ArrayList<String>();
        int i = 1;
        while (buf.hasNext()) {
            cursor = buf.next();
            if (cursor != null) {
                if (i == removeAt) {
                    position = cursor.getPosition();
                } else {
                    records.add(this.createStr(cursor));
                }
            }
            ++i;
        }
        buf.removeAt(position);
        buf.rewind();
        Assert.assertEquals((long)buf.size(), (long)records.size());
        i = 0;
        while (buf.hasNext()) {
            cursor = buf.next();
            Assert.assertNotNull((Object)cursor);
            Assert.assertEquals((Object)this.createStr(cursor), records.get(i));
            ++i;
        }
    }

    private void removeRecordAtCursorIntegrity(int removeIndex, int cursorPosition) {
        RecordBuffer buf = this.createRecordBuffer();
        int count = buf.size();
        long removeAt = 0L;
        int i = 1;
        while (buf.hasNext()) {
            RecordCursor cursor = buf.next();
            if (cursor != null) {
                long tmp = cursor.getPosition();
                if (i == removeIndex) {
                    removeAt = tmp;
                    break;
                }
            }
            ++i;
        }
        buf.rewind();
        RecordCursor read = null;
        RecordCursor write = null;
        int i2 = 1;
        while (buf.hasNext()) {
            RecordCursor cursor = buf.next();
            if (cursor != null) {
                long tmp = cursor.getPosition();
                if (i2 == cursorPosition) {
                    read = buf.cursorAt(tmp);
                    write = buf.writeCursorAt(tmp);
                    break;
                }
            }
            ++i2;
        }
        Assert.assertNotNull(read);
        Assert.assertNotNull(write);
        String readCursorStr = this.createStr(read);
        String writeCursorStr = this.createStr(write);
        buf.removeAt(removeAt);
        Assert.assertEquals((long)buf.size(), (long)(count - 1));
        if (removeIndex == cursorPosition) {
            Assert.assertEquals((long)this.getCursorIntOffset(read), (long)-2000000000L);
            Assert.assertEquals((long)this.getCursorObjOffset(read), (long)-2000000000L);
            Assert.assertEquals((long)this.getCursorIntOffset(write), (long)-2000000000L);
            Assert.assertEquals((long)this.getCursorObjOffset(write), (long)-2000000000L);
        } else {
            try {
                Assert.assertEquals((Object)readCursorStr, (Object)this.createStr(read));
                Assert.assertEquals((Object)writeCursorStr, (Object)this.createStr(write));
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    private void removeRecordAtBufPositionIntegrity(int removeIndex, int bufferPosition) {
        RecordBuffer buf = this.createRecordBuffer();
        int count = buf.size();
        long removeAt = 0L;
        ArrayList<String> records = new ArrayList<String>();
        int i = 1;
        while (buf.hasNext()) {
            RecordCursor cursor = buf.next();
            if (cursor != null) {
                records.add(this.createStr(cursor));
                long tmp = cursor.getPosition();
                if (i == removeIndex) {
                    removeAt = tmp;
                }
            }
            ++i;
        }
        buf.rewind();
        for (i = 1; buf.hasNext() && i < bufferPosition; ++i) {
            buf.next();
        }
        RecordCursor cursor = buf.current();
        Assert.assertNotNull((Object)cursor);
        String cursorStr = this.createStr(cursor);
        buf.removeAt(removeAt);
        Assert.assertEquals((long)buf.size(), (long)(count - 1));
        cursor = buf.current();
        if (removeIndex != bufferPosition) {
            Assert.assertNotNull((Object)cursor);
            Assert.assertEquals((Object)cursorStr, (Object)this.createStr(cursor));
        } else if (bufferPosition < count) {
            Assert.assertNotNull((Object)cursor);
            Assert.assertEquals(records.get(bufferPosition), (Object)this.createStr(cursor));
        } else {
            Assert.assertNull((Object)cursor);
        }
    }

    private RecordBuffer createRecordBuffer() {
        RecordBuffer buf = new RecordBuffer(RecordMode.DATA.withEventTimeSequence());
        int chipper = 1000000000;
        for (int i = 1; i < 10; ++i) {
            int j;
            RecordCursor cur = buf.add(this.record(i), chipper + i, "SYMBOL_" + i);
            cur.setEventTimeSequence(this.eventTimeSequence(i));
            for (j = 0; j < cur.getIntCount(); ++j) {
                cur.setInt(j, this.iVal(i, j));
            }
            for (j = 0; j < cur.getObjCount(); ++j) {
                cur.setObj(j, this.oVal(i, j));
            }
        }
        return buf;
    }

    private String createStr(RecordCursor cursor) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(cursor.getCipher()).append("-").append(cursor.getIntCount()).append("-").append(cursor.getObjCount()).append("---");
        for (i = 0; i < cursor.getIntCount(); ++i) {
            sb.append(cursor.getInt(i)).append("-");
        }
        for (i = 0; i < cursor.getObjCount(); ++i) {
            sb.append(cursor.getObj(i)).append("-");
        }
        return sb.toString();
    }

    private int getCursorIntOffset(RecordCursor cursor) {
        return cursor.getIntPositionInternal() + cursor.getMode().intBufOffset;
    }

    private int getCursorObjOffset(RecordCursor cursor) {
        return cursor.getObjPositionInternal() + cursor.getMode().objBufOffset;
    }
}

