/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.test;

import com.devexperts.qd.DataIntField;
import com.devexperts.qd.DataObjField;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDAgent;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.QDFactory;
import com.devexperts.qd.SerialFieldType;
import com.devexperts.qd.SymbolCodec;
import com.devexperts.qd.kit.CompactIntField;
import com.devexperts.qd.kit.DefaultRecord;
import com.devexperts.qd.kit.DefaultScheme;
import com.devexperts.qd.kit.PentaCodec;
import com.devexperts.qd.ng.AbstractRecordSink;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.ng.RecordMode;
import com.devexperts.qd.ng.RecordSink;
import com.devexperts.qd.ng.RecordSource;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class VoidAgentTest {
    private static final DataRecord REC_0 = new DefaultRecord(0, "Rec0", true, VoidAgentTest.timeFields("Rec0"), new DataObjField[0]);
    private static final DataRecord REC_1 = new DefaultRecord(1, "Rec1", true, VoidAgentTest.timeFields("Rec1"), new DataObjField[0]);
    private static final DataScheme SCHEME = new DefaultScheme((SymbolCodec)PentaCodec.INSTANCE, new DataRecord[]{REC_0, REC_1});
    private QDAgent agent;

    private static DataIntField[] timeFields(String recName) {
        return new DataIntField[]{new CompactIntField(0, recName + ".Index0", SerialFieldType.COMPACT_INT), new CompactIntField(1, recName + ".Index1", SerialFieldType.COMPACT_INT)};
    }

    @Test
    public void testTickerVoidAgent() {
        this.agent = QDFactory.getDefaultFactory().createVoidAgentBuilder(QDContract.TICKER, SCHEME).build();
        this.assertSub(new Item[0]);
        this.addSub(REC_0, "TEST", 0L);
        this.assertSub(VoidAgentTest.item(REC_0, "TEST"));
        this.addSub(REC_0, "TEST", 0L);
        this.assertSub(VoidAgentTest.item(REC_0, "TEST"));
        this.addSub(REC_1, "TEST", 0L);
        this.assertSub(VoidAgentTest.item(REC_0, "TEST"), VoidAgentTest.item(REC_1, "TEST"));
        this.addSub(REC_1, "XX", 0L);
        this.assertSub(VoidAgentTest.item(REC_0, "TEST"), VoidAgentTest.item(REC_1, "TEST"), VoidAgentTest.item(REC_1, "XX"));
        this.removeSub(REC_1, "XX");
        this.assertSub(VoidAgentTest.item(REC_0, "TEST"), VoidAgentTest.item(REC_1, "TEST"));
        this.removeSub(REC_0, "TEST");
        this.assertSub(VoidAgentTest.item(REC_1, "TEST"));
        this.removeSub(REC_0, "TEST");
        this.assertSub(VoidAgentTest.item(REC_1, "TEST"));
        this.removeSub(REC_1, "TEST");
        this.assertSub(new Item[0]);
    }

    @Test
    public void testHistoryVoidAgent() {
        this.agent = QDFactory.getDefaultFactory().createVoidAgentBuilder(QDContract.HISTORY, SCHEME).build();
        this.assertSub(new Item[0]);
        this.addSub(REC_0, "TEST", 1L);
        this.assertSub(VoidAgentTest.item(REC_0, "TEST", 1L));
        this.addSub(REC_0, "TEST", 2L);
        this.assertSub(VoidAgentTest.item(REC_0, "TEST", 2L));
        this.addSub(REC_1, "TEST", 3L);
        this.assertSub(VoidAgentTest.item(REC_0, "TEST", 2L), VoidAgentTest.item(REC_1, "TEST", 3L));
        this.addSub(REC_1, "XX", 4L);
        this.assertSub(VoidAgentTest.item(REC_0, "TEST", 2L), VoidAgentTest.item(REC_1, "TEST", 3L), VoidAgentTest.item(REC_1, "XX", 4L));
        this.removeSub(REC_1, "XX");
        this.assertSub(VoidAgentTest.item(REC_0, "TEST", 2L), VoidAgentTest.item(REC_1, "TEST", 3L));
        this.removeSub(REC_0, "TEST");
        this.assertSub(VoidAgentTest.item(REC_1, "TEST", 3L));
        this.removeSub(REC_0, "TEST");
        this.assertSub(VoidAgentTest.item(REC_1, "TEST", 3L));
        this.removeSub(REC_1, "TEST");
        this.assertSub(new Item[0]);
    }

    @Test
    public void testTickerStress() {
        this.checkStress(QDContract.TICKER);
    }

    @Test
    public void testHistoryStress() {
        this.checkStress(QDContract.HISTORY);
    }

    private void checkStress(QDContract contract) {
        Random rnd = new Random(20140905L);
        this.agent = QDFactory.getDefaultFactory().createVoidAgentBuilder(contract, SCHEME).build();
        int n = 1000;
        HashMap<Item, Item> items = new HashMap<Item, Item>();
        for (int i = 0; i < n; ++i) {
            DataRecord record = rnd.nextBoolean() ? REC_0 : REC_1;
            String symbol = Integer.toString(rnd.nextInt(10 * n));
            long time = contract == QDContract.HISTORY ? rnd.nextLong() : 0L;
            this.addSub(record, symbol, time);
            Item item = VoidAgentTest.item(record, symbol, time);
            items.put(item, item);
        }
        this.assertSub(items.values().toArray(new Item[items.size()]));
        Iterator it = items.values().iterator();
        while (it.hasNext()) {
            Item item = (Item)it.next();
            if (!rnd.nextBoolean()) continue;
            this.removeSub(item.record, item.symbol);
            it.remove();
        }
        this.assertSub(items.values().toArray(new Item[items.size()]));
        this.assertSub(items.values().toArray(new Item[items.size()]));
        for (Item item : items.values()) {
            this.removeSub(item.record, item.symbol);
        }
        this.assertSub(new Item[0]);
    }

    private void assertSub(Item ... items) {
        Assert.assertEquals((long)items.length, (long)this.agent.getSubscriptionSize());
        final HashMap map = new HashMap();
        this.agent.examineSubscription((RecordSink)new AbstractRecordSink(){

            public void append(RecordCursor cursor) {
                Item item = VoidAgentTest.item(cursor.getRecord(), cursor.getDecodedSymbol(), cursor.getTime());
                Assert.assertNull((Object)map.put(item, item));
            }
        });
        Assert.assertEquals((long)items.length, (long)map.size());
        for (Item item : items) {
            Item other = (Item)map.get(item);
            Assert.assertNotNull((String)("Contains " + item.toString()), (Object)other);
            Assert.assertEquals((String)"time", (long)item.time, (long)other.time);
        }
    }

    private void addSub(DataRecord record, String symbol, long time) {
        RecordBuffer sub = RecordBuffer.getInstance((RecordMode)RecordMode.HISTORY_SUBSCRIPTION);
        sub.add(record, PentaCodec.INSTANCE.encode(symbol), symbol).setTime(time);
        this.agent.addSubscription((RecordSource)sub);
        sub.release();
    }

    private void removeSub(DataRecord record, String symbol) {
        RecordBuffer sub = RecordBuffer.getInstance((RecordMode)RecordMode.SUBSCRIPTION);
        sub.add(record, PentaCodec.INSTANCE.encode(symbol), symbol);
        this.agent.removeSubscription((RecordSource)sub);
        sub.release();
    }

    private static Item item(DataRecord record, String symbol) {
        return new Item(record, symbol, 0L);
    }

    private static Item item(DataRecord record, String symbol, long time) {
        return new Item(record, symbol, time);
    }

    private static class Item {
        final DataRecord record;
        final String symbol;
        final long time;

        private Item(DataRecord record, String symbol, long time) {
            this.record = record;
            this.symbol = symbol;
            this.time = time;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Item item = (Item)o;
            return this.record.equals(item.record) && this.symbol.equals(item.symbol);
        }

        public int hashCode() {
            return 31 * this.record.hashCode() + this.symbol.hashCode();
        }

        public String toString() {
            return "Item{record=" + this.record + ", symbol='" + this.symbol + '\'' + ", time=" + this.time + '}';
        }
    }
}

