/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.util;

import com.devexperts.qd.util.DxTimer;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class DxTimerTest {
    @Test(expected=NullPointerException.class)
    public void testInvalidSchedule() {
        DxTimer.getInstance().runOnce(null, 1000L);
    }

    @Test
    public void testRunOnce() throws InterruptedException {
        CountDownLatch invoke = new CountDownLatch(1);
        DxTimer.getInstance().runOnce(invoke::countDown, 0L);
        Assert.assertTrue((boolean)invoke.await(10L, TimeUnit.SECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRunDaily() throws InterruptedException {
        CountDownLatch invoke = new CountDownLatch(1);
        Instant invokeTime = Instant.now().plusSeconds(1L);
        DxTimer.Cancellable cancellable = DxTimer.getInstance().runDaily(invoke::countDown, LocalTime.from(ZonedDateTime.ofInstant(invokeTime, ZoneId.systemDefault())));
        try {
            Assume.assumeTrue((boolean)Instant.now().isBefore(invokeTime));
            Assert.assertTrue((boolean)invoke.await(10L, TimeUnit.SECONDS));
        }
        finally {
            cancellable.cancel();
        }
    }
}

