/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.util;

import com.devexperts.qd.util.RateLimiter;
import com.devexperts.util.TimePeriod;
import java.lang.reflect.Field;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RateLimiterTest {
    private static final long NANOS_PER_MICROSECOND = TimeUnit.MICROSECONDS.toNanos(1L);
    private static final long NANOS_PER_MILLISECOND = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final long NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
    private static final long START_TIME = 0L;
    private static final Field fieldRefillPeriodNanos;
    private static final Field fieldBucketSize;
    private RateLimiter rateLimiter;
    private long currentNanos;

    @Before
    public void setUp() {
        this.currentNanos = 0L;
    }

    @Test
    public void testAvailableOrWaitFirstBasicFlow() throws InterruptedException {
        this.rateLimiter = new TestableRateLimiter(1000L);
        this.assertState(1L, 0L);
        long tokens = this.rateLimiter.availableOrWait();
        this.assertState(0L, 1L);
        this.rateLimiter.reportConsumed(tokens);
        this.assertState(1L, 0L);
    }

    @Test
    public void testAvailableOrWaitSecondBasicFlow() {
        this.rateLimiter = new TestableRateLimiter(1000L);
        this.assertState(1L, 0L);
        this.rateLimiter.parkNanos(NANOS_PER_MILLISECOND);
        this.assertState(0L, 1L);
        long available = this.rateLimiter.available();
        this.rateLimiter.reportConsumed(available);
        this.assertState(1L, 0L);
    }

    @Test
    public void testTokenRefillAndTimeAdvancement() {
        this.rateLimiter = new TestableRateLimiter(1000L);
        this.assertState(1L, 0L);
        this.rateLimiter.reportConsumed(1L);
        this.assertState(2L, 0L);
        this.currentNanos += 1000000L;
        this.assertState(1L, 0L);
        this.currentNanos += 1000000L;
        this.assertState(0L, 1L);
        this.currentNanos += 0x3FFFFFFFFFFFFFFFL;
        this.assertState(0L, 1000L);
        this.rateLimiter.reportConsumed(1L);
        this.assertState(0L, 999L);
    }

    @Test
    public void testMaximumElapsedTimeAndOverflowHandling() {
        this.rateLimiter = new TestableRateLimiter(1000L);
        this.currentNanos += 2000000000L;
        this.rateLimiter.reportConsumed(1L);
        Assert.assertEquals((long)0L, (long)this.rateLimiter.waitTime());
        this.currentNanos += 9223372036854775L;
        this.rateLimiter.reportConsumed(1L);
        Assert.assertEquals((long)0L, (long)this.rateLimiter.waitTime());
        this.currentNanos += 5000L;
        this.rateLimiter.reportConsumed(1L);
        Assert.assertEquals((long)0L, (long)this.rateLimiter.waitTime());
        this.rateLimiter.reportConsumed(0x7FFFFFFFFFFFFFFEL);
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.rateLimiter.waitTime());
    }

    @Test
    public void testLargeTokenConsumptionWithoutOverflowBucketSize() {
        this.rateLimiter = new TestableRateLimiter(1000L);
        this.currentNanos += 2000000000000L;
        this.rateLimiter.reportConsumed(2000000L);
        this.rateLimiter.reportConsumed(9223372036853775807L);
        this.assertState(Long.MAX_VALUE, 0L);
    }

    @Test
    public void testLargeTokenConsumptionWithOverflowBucketSize() {
        this.rateLimiter = new TestableRateLimiter(1000L);
        this.currentNanos += 2000000000000L;
        this.rateLimiter.reportConsumed(2000000L);
        this.currentNanos += 2000000000000L;
        this.rateLimiter.reportConsumed(9223372036853775807L);
        this.assertState(Long.MAX_VALUE, 0L);
    }

    @Test
    public void testOverflowBucketSize() {
        this.rateLimiter = new TestableRateLimiter(Long.MAX_VALUE);
        this.currentNanos += 500000000L;
        this.rateLimiter.reportConsumed(Long.MAX_VALUE);
        this.currentNanos += 500000000L;
        this.rateLimiter.reportConsumed(Long.MAX_VALUE);
        this.currentNanos += 500000000L;
        this.rateLimiter.reportConsumed(Long.MAX_VALUE);
        this.assertState(1000L, 0L);
    }

    @Test
    public void testWaitNanoTimeLessThenOneToken() {
        this.rateLimiter = new TestableRateLimiter(10000000000L);
        Assert.assertEquals((long)1L, (long)this.rateLimiter.waitTime());
    }

    @Test
    public void testMaxRateAndDouble() {
        this.rateLimiter = new TestableRateLimiter(1000000L);
        this.rateLimiter.parkNanos(NANOS_PER_MILLISECOND);
        this.rateLimiter.reportConsumed(2L * this.rateLimiter.available());
        this.rateLimiter.parkNanos(this.rateLimiter.waitTime() * 1000000L);
        this.rateLimiter.parkNanos(NANOS_PER_MILLISECOND);
        this.rateLimiter.reportConsumed(2L * this.rateLimiter.available());
        this.rateLimiter.parkNanos(this.rateLimiter.waitTime() * 1000000L);
        Assert.assertEquals((long)0L, (long)this.rateLimiter.waitTime());
    }

    @Test
    public void testHighRateOverdraftWithLongTimePeriods() {
        this.rateLimiter = new TestableRateLimiter(1000000L);
        this.rateLimiter.parkNanos(NANOS_PER_MICROSECOND);
        this.rateLimiter.reportConsumed(2L * this.rateLimiter.available());
        this.rateLimiter.parkNanos(this.rateLimiter.waitTime() * 1000000L);
        this.rateLimiter.parkNanos(NANOS_PER_MICROSECOND);
        this.rateLimiter.reportConsumed(2L * this.rateLimiter.available());
        this.rateLimiter.parkNanos(this.rateLimiter.waitTime() * 1000000L);
        this.rateLimiter.parkNanos(NANOS_PER_MICROSECOND);
        this.rateLimiter.reportConsumed(2L * this.rateLimiter.available());
        this.rateLimiter.parkNanos(this.rateLimiter.waitTime() * 1000000L);
        this.rateLimiter.parkNanos(120000000000L);
        this.rateLimiter.reportConsumed(2L * this.rateLimiter.available());
        this.rateLimiter.parkNanos(this.rateLimiter.waitTime() * 1000000L);
        this.rateLimiter.parkNanos(120000000000L);
        this.rateLimiter.reportConsumed(2L * this.rateLimiter.available());
        this.rateLimiter.parkNanos(this.rateLimiter.waitTime() * 1000000L);
    }

    @Test
    public void testBucketCapacity() {
        this.rateLimiter = new TestableRateLimiter(1000L, TimePeriod.valueOf((String)"0.003s"));
        Assert.assertEquals((long)0L, (long)this.rateLimiter.available());
        this.currentNanos += NANOS_PER_SECOND;
        Assert.assertEquals((long)3L, (long)this.rateLimiter.available());
    }

    @Test
    public void testMultipleTokenConsumptionScaling() {
        this.rateLimiter = new TestableRateLimiter(1000L);
        this.rateLimiter.reportConsumed(5L);
        Assert.assertTrue((boolean)this.rateLimiter.needWait());
        Assert.assertEquals((long)6L, (long)this.rateLimiter.waitTime());
        this.currentNanos += 6000000L;
        Assert.assertFalse((boolean)this.rateLimiter.needWait());
    }

    @Test
    public void testBlockingConsumeWithOverflowScenarios() throws InterruptedException {
        this.rateLimiter = new TestableRateLimiter(1000L);
        this.rateLimiter.consume(4000000000000000000L);
        this.assertState(Long.MAX_VALUE, 0L);
    }

    @Test
    public void testConsumeThrow() throws InterruptedException {
        this.rateLimiter = new TestableRateLimiter(1000L, TimePeriod.valueOf((String)"1s"), true);
        this.rateLimiter.reportConsumed(1L);
        long tmp = this.currentNanos;
        Assert.assertThrows((String)"Should throw InterruptedException", InterruptedException.class, () -> this.rateLimiter.consume(1L));
        Assert.assertEquals((long)tmp, (long)this.currentNanos);
    }

    @Test
    public void testAvailableTokensOverTime() {
        this.rateLimiter = new TestableRateLimiter(1000L, TimePeriod.valueOf((String)"0.01s"));
        Assert.assertEquals((long)0L, (long)this.rateLimiter.available());
        this.assertState(1L, 0L);
        long tmp = this.currentNanos;
        this.currentNanos = tmp + 1000000L;
        Assert.assertEquals((long)1L, (long)this.rateLimiter.available());
        this.assertState(0L, 1L);
        this.currentNanos = tmp + 10000000L;
        Assert.assertEquals((long)10L, (long)this.rateLimiter.available());
        this.assertState(0L, 10L);
        this.currentNanos = tmp + NANOS_PER_SECOND;
        this.assertState(0L, 10L);
    }

    @Test
    public void testProcessedWithZeroTokens() throws InterruptedException {
        this.rateLimiter = new TestableRateLimiter(1000L);
        this.assertState(1L, 0L);
        this.rateLimiter.consume(0L);
        this.rateLimiter.reportConsumed(0L);
        this.assertState(1L, 0L);
        this.currentNanos = NANOS_PER_SECOND;
        this.rateLimiter.consume(0L);
        this.rateLimiter.reportConsumed(0L);
        this.assertState(0L, 1000L);
    }

    @Test
    public void testProcessedWithNegativeTokens() {
        this.rateLimiter = new TestableRateLimiter(1000L, TimePeriod.valueOf((String)"100s"));
        Assert.assertThrows((String)"Should throw IllegalArgumentException for negative tokens", IllegalArgumentException.class, () -> this.rateLimiter.reportConsumed(-1L));
    }

    @Test
    public void testUnlimitedRateLimiter() throws InterruptedException {
        this.rateLimiter = RateLimiter.UNLIMITED;
        this.assertState(0L, Long.MAX_VALUE);
        this.rateLimiter.consume(Long.MAX_VALUE);
        this.rateLimiter.reportConsumed(Long.MAX_VALUE);
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.rateLimiter.availableOrWait());
        this.assertState(0L, Long.MAX_VALUE);
    }

    @Test
    public void testAvailableOrWaitWhenTokensAvailable() throws InterruptedException {
        this.rateLimiter = new TestableRateLimiter(1000L);
        this.currentNanos += 5000000L;
        long currentNanoTime = this.rateLimiter.getCurrentNanoTime();
        long available = this.rateLimiter.availableOrWait();
        Assert.assertEquals((long)5L, (long)available);
        Assert.assertEquals((long)currentNanoTime, (long)this.rateLimiter.getCurrentNanoTime());
    }

    @Test
    public void testParkNanos() {
        RateLimiter limiter = RateLimiter.valueOf((String)"1000");
        long startTime = System.nanoTime();
        limiter.parkNanos(1000000L);
        long actualTime = System.nanoTime() - startTime;
        Assert.assertTrue((1L < actualTime && actualTime < 1000000000L ? 1 : 0) != 0);
    }

    @Test
    public void testConstructorValidation() {
        this.rateLimiter = RateLimiter.valueOf((String)"1000");
        this.assertConfig(NANOS_PER_SECOND, 1000L);
        this.rateLimiter = RateLimiter.valueOf((String)"1.1");
        this.assertConfig(NANOS_PER_SECOND, 1L);
        this.rateLimiter = RateLimiter.valueOf((String)"999.9");
        this.assertConfig(NANOS_PER_SECOND, 999L);
        this.rateLimiter = RateLimiter.valueOf((String)"1k");
        this.assertConfig(NANOS_PER_SECOND, 1000L);
        this.rateLimiter = RateLimiter.valueOf((String)"0.5k");
        this.assertConfig(NANOS_PER_SECOND, 500L);
        this.rateLimiter = RateLimiter.valueOf((String)"1.5K");
        this.assertConfig(NANOS_PER_SECOND, 1500L);
        this.rateLimiter = RateLimiter.of((double)1500.0);
        this.assertConfig(NANOS_PER_SECOND, 1500L);
        this.rateLimiter = RateLimiter.of((double)0.5, (TimePeriod)TimePeriod.valueOf((String)"2s"));
        this.assertConfig(2L * NANOS_PER_SECOND, 1L);
        this.rateLimiter = RateLimiter.of((double)1500.0, (TimePeriod)TimePeriod.valueOf((long)500L));
        this.assertConfig(NANOS_PER_SECOND / 2L, 750L);
        this.rateLimiter = RateLimiter.ofBucket((long)1500L, (long)NANOS_PER_SECOND);
        this.assertConfig(NANOS_PER_SECOND, 1500L);
        this.rateLimiter = RateLimiter.valueOf((String)"2m");
        this.assertConfig(NANOS_PER_SECOND, 2000000L);
        this.rateLimiter = RateLimiter.valueOf((String)"12.7M");
        this.assertConfig(NANOS_PER_SECOND, 12700000L, 5L);
        this.rateLimiter = RateLimiter.valueOf((String)"1000;2s");
        this.assertConfig(2L * NANOS_PER_SECOND, 2000L);
        Assert.assertEquals((Object)this.rateLimiter, (Object)RateLimiter.valueOf((String)this.rateLimiter.toString()));
        this.rateLimiter = RateLimiter.valueOf((String)"500;3s");
        this.assertConfig(3L * NANOS_PER_SECOND, 1500L);
        Assert.assertEquals((Object)this.rateLimiter, (Object)RateLimiter.valueOf((String)this.rateLimiter.toString()));
        this.rateLimiter = RateLimiter.valueOf((String)"2000;0.5s");
        this.assertConfig(NANOS_PER_SECOND / 2L, 1000L);
        Assert.assertEquals((Object)this.rateLimiter, (Object)RateLimiter.valueOf((String)this.rateLimiter.toString()));
        Assert.assertEquals((long)this.rateLimiter.hashCode(), (long)RateLimiter.valueOf((String)this.rateLimiter.toString()).hashCode());
        Assert.assertNotEquals((Object)RateLimiter.UNLIMITED, (Object)this.rateLimiter);
        Assert.assertFalse((boolean)this.rateLimiter.equals(new Object()));
        Assert.assertEquals((Object)RateLimiter.UNLIMITED, (Object)RateLimiter.valueOf((String)""));
        Assert.assertEquals((Object)RateLimiter.UNLIMITED, (Object)RateLimiter.valueOf((String)"unlimited"));
        Assert.assertEquals((Object)RateLimiter.UNLIMITED, (Object)RateLimiter.valueOf((String)"UNLIMITED"));
        Assert.assertEquals((Object)RateLimiter.UNLIMITED, (Object)RateLimiter.valueOf(null));
        Assert.assertEquals((Object)RateLimiter.UNLIMITED, (Object)RateLimiter.valueOf((String)RateLimiter.UNLIMITED.toString()));
        long bucketSize = RateLimiter.calculateBucketSize((double)9.223372036854776E18, (TimePeriod)TimePeriod.valueOf((String)"1s"));
        long refillPeriodNanos = TimePeriod.valueOf((String)"1s").getNanos();
        this.rateLimiter = new RateLimiter(bucketSize, refillPeriodNanos, RateLimiter.calculateConfig((long)bucketSize, (long)refillPeriodNanos));
        this.assertConfig(NANOS_PER_SECOND, Long.MAX_VALUE);
        Assert.assertThrows((String)"Should throw IllegalArgumentException for rate limit 0", IllegalArgumentException.class, () -> new TestableRateLimiter(0L));
        Assert.assertThrows((String)"Should throw IllegalArgumentException for negative rate limit", IllegalArgumentException.class, () -> new TestableRateLimiter(-1L));
        Assert.assertThrows((String)"Should throw IllegalArgumentException for zero refill period", IllegalArgumentException.class, () -> RateLimiter.ofBucket((long)1L, (long)0L));
        Assert.assertThrows((String)"Should throw IllegalArgumentException for negative bucket size", IllegalArgumentException.class, () -> RateLimiter.ofBucket((long)-1L, (long)1L));
        Assert.assertThrows((String)"Should throw IllegalArgumentException for bucket size to become less than one token", IllegalArgumentException.class, () -> RateLimiter.of((double)0.5));
        Assert.assertThrows((String)"Should throw IllegalArgumentException for amortisation limit more then Long.MAX_VALUE", IllegalArgumentException.class, () -> RateLimiter.of((double)9.223372036854776E18, (TimePeriod)TimePeriod.valueOf((String)"1.001S")));
        Assert.assertThrows((String)"Should throw IllegalArgumentException for non-numeric rate", IllegalArgumentException.class, () -> RateLimiter.valueOf((String)"invalid"));
        Assert.assertThrows((String)"Should throw IllegalArgumentException for invalid suffix", IllegalArgumentException.class, () -> RateLimiter.valueOf((String)"1000x"));
        Assert.assertThrows((String)"Should throw IllegalArgumentException for invalid time period", IllegalArgumentException.class, () -> RateLimiter.valueOf((String)"1000;invalid"));
    }

    private void assertState(long expectedWaitTime, long expectedAvailable) {
        Assert.assertEquals((long)expectedWaitTime, (long)this.rateLimiter.waitTime());
        Assert.assertEquals((Object)(expectedWaitTime > 0L ? 1 : 0), (Object)this.rateLimiter.needWait());
        Assert.assertEquals((long)expectedAvailable, (long)this.rateLimiter.available());
    }

    private void assertConfig(long expectedRefillPeriodNanos, long expectedBucketSize) {
        this.assertConfig(expectedRefillPeriodNanos, expectedBucketSize, 0L);
    }

    private void assertConfig(long expectedRefillPeriodNanos, long expectedBucketSize, long delta) {
        try {
            Assert.assertEquals((float)expectedRefillPeriodNanos, (float)fieldRefillPeriodNanos.getLong(this.rateLimiter), (float)delta);
            Assert.assertEquals((float)expectedBucketSize, (float)fieldBucketSize.getLong(this.rateLimiter), (float)delta);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            fieldRefillPeriodNanos = RateLimiter.class.getDeclaredField("refillPeriodNanos");
            fieldRefillPeriodNanos.setAccessible(true);
            fieldBucketSize = RateLimiter.class.getDeclaredField("bucketSize");
            fieldBucketSize.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private class TestableRateLimiter
    extends RateLimiter {
        private final boolean interrupt;

        TestableRateLimiter(long rateLimit) {
            this(rateLimit, TimePeriod.valueOf((String)"1s"), false);
        }

        TestableRateLimiter(long rateLimit, TimePeriod amortizationLimit) {
            this(rateLimit, amortizationLimit, false);
        }

        TestableRateLimiter(long rateLimit, TimePeriod amortizationLimit, boolean interrupt) {
            super(TestableRateLimiter.calculateBucketSize((double)rateLimit, (TimePeriod)amortizationLimit), amortizationLimit.getNanos(), TestableRateLimiter.calculateConfig((long)TestableRateLimiter.calculateBucketSize((double)rateLimit, (TimePeriod)amortizationLimit), (long)amortizationLimit.getNanos()));
            this.interrupt = interrupt;
        }

        long getCurrentNanoTime() {
            return RateLimiterTest.this.currentNanos;
        }

        void parkNanos(long nanos) {
            if (this.interrupt) {
                Thread.currentThread().interrupt();
            } else {
                RateLimiterTest.this.currentNanos = RateLimiterTest.this.currentNanos + nanos;
            }
        }
    }
}

