/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.util.test;

import com.devexperts.qd.kit.PentaCodec;
import com.devexperts.qd.util.SymbolSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class SymbolSetTest {
    private final SymbolSet set = SymbolSet.createInstance();
    private static final String[] STRINGS = new String[]{"A", "B", "C", "ZZZ", "UNBREAKABLE", "NOT HERE"};

    @Test
    public void testSymbolSet() {
        this.assertSet(new String[0]);
        Assert.assertTrue((boolean)this.add("A"));
        this.assertSet("A");
        Assert.assertFalse((boolean)this.add("A"));
        this.assertSet("A");
        Assert.assertTrue((boolean)this.add("B"));
        this.assertSet("A", "B");
        Assert.assertTrue((boolean)this.remove("A"));
        this.assertSet("B");
        Assert.assertFalse((boolean)this.remove("A"));
        this.assertSet("B");
        Assert.assertTrue((boolean)this.remove("B"));
        this.assertSet(new String[0]);
        Assert.assertTrue((boolean)this.add("UNBREAKABLE"));
        this.assertSet("UNBREAKABLE");
        Assert.assertTrue((boolean)this.add("C"));
        this.assertSet("UNBREAKABLE", "C");
        Assert.assertTrue((boolean)this.remove("UNBREAKABLE"));
        this.assertSet("C");
    }

    @Test
    public void testSymbolSetStress() {
        String symbol2;
        Random rnd = new Random(20140915L);
        int n = 1000;
        HashSet<String> symbols = new HashSet<String>();
        for (int i = 0; i < n; ++i) {
            while (!symbols.add(symbol2 = Integer.toString(rnd.nextInt(10 * n)))) {
            }
            Assert.assertTrue((boolean)this.add(symbol2));
        }
        this.assertSet(symbols.toArray(new String[0]));
        Iterator it = symbols.iterator();
        while (it.hasNext()) {
            symbol2 = (String)it.next();
            if (!rnd.nextBoolean()) continue;
            Assert.assertTrue((boolean)this.remove(symbol2));
            it.remove();
        }
        this.assertSet(symbols.toArray(new String[0]));
        for (int i = 0; i < n; ++i) {
            while (!symbols.add(symbol2 = Integer.toString(rnd.nextInt(10 * n)))) {
            }
            Assert.assertTrue((boolean)this.add(symbol2));
        }
        this.assertSet(symbols.toArray(new String[symbols.size()]));
        for (String symbol2 : symbols) {
            Assert.assertTrue((boolean)this.remove(symbol2));
        }
        this.assertSet(new String[0]);
    }

    private boolean add(String symbol) {
        return this.set.add(PentaCodec.INSTANCE.encode(symbol), symbol);
    }

    private boolean remove(String symbol) {
        return this.set.remove(PentaCodec.INSTANCE.encode(symbol), symbol);
    }

    private void assertSet(String ... symbols) {
        this.checkSet(this.set, symbols);
        this.checkSet(this.set.unmodifiable(), symbols);
    }

    private void checkSet(SymbolSet set, String[] symbols) {
        int cipher2;
        HashSet examined = new HashSet();
        set.examine((cipher, symbol) -> Assert.assertTrue((boolean)examined.add(PentaCodec.INSTANCE.decode(cipher, symbol))));
        Assert.assertEquals((long)symbols.length, (long)set.size());
        Assert.assertEquals((long)symbols.length, (long)examined.size());
        for (String symbol2 : symbols) {
            Assert.assertTrue((boolean)examined.contains(symbol2));
            cipher2 = PentaCodec.INSTANCE.encode(symbol2);
            Assert.assertTrue((boolean)set.contains(cipher2, symbol2));
            Assert.assertTrue((boolean)set.contains(cipher2, symbol2.toCharArray(), 0, symbol2.length()));
            if (cipher2 != 0) continue;
            Assert.assertEquals((Object)symbol2, (Object)set.getSymbol(symbol2.toCharArray(), 0, symbol2.length()));
        }
        for (String symbol2 : STRINGS) {
            if (examined.contains(symbol2)) continue;
            cipher2 = PentaCodec.INSTANCE.encode(symbol2);
            Assert.assertFalse((boolean)set.contains(cipher2, symbol2));
            Assert.assertFalse((boolean)set.contains(cipher2, symbol2.toCharArray(), 0, symbol2.length()));
        }
    }
}

