/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.kit;

import com.devexperts.qd.DataIntField;
import com.devexperts.qd.DataObjField;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.kit.ArrayListAttachmentStrategy;
import com.devexperts.qd.kit.DefaultRecord;
import com.devexperts.qd.ng.RecordCursor;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class ArrayListAttachmentStrategyTest {
    private static final DataRecord RECORD = new DefaultRecord(0, "Test", false, new DataIntField[0], new DataObjField[0]);
    Set<String> set = new HashSet<String>();
    ArrayListAttachmentStrategy<String, ArrayListAttachmentStrategyTest> alas = new ArrayListAttachmentStrategy<String, ArrayListAttachmentStrategyTest>(){

        public void process(RecordCursor cursor, String attachment, ArrayListAttachmentStrategyTest ctx) {
            if (attachment != null) {
                ArrayListAttachmentStrategyTest.this.set.add(attachment);
            } else {
                Assert.assertTrue((boolean)ArrayListAttachmentStrategyTest.this.set.isEmpty());
            }
        }
    };

    @Test
    public void testUpdateAttachment() {
        RecordCursor.Owner subOwner = RecordCursor.allocateOwner();
        RecordCursor.Owner dataOwner = RecordCursor.allocateOwner();
        subOwner.setRecord(RECORD);
        dataOwner.setRecord(RECORD);
        subOwner.setAttachment((Object)"ONE");
        dataOwner.setAttachment(this.alas.updateAttachment(null, subOwner.cursor(), false));
        this.assertSet(dataOwner.cursor(), "ONE");
        subOwner.setAttachment((Object)"TWO");
        dataOwner.setAttachment(this.alas.updateAttachment(dataOwner.cursor().getAttachment(), subOwner.cursor(), false));
        this.assertSet(dataOwner.cursor(), "ONE", "TWO");
        subOwner.setAttachment((Object)"THREE");
        dataOwner.setAttachment(this.alas.updateAttachment(dataOwner.cursor().getAttachment(), subOwner.cursor(), false));
        this.assertSet(dataOwner.cursor(), "ONE", "TWO", "THREE");
        subOwner.setAttachment((Object)"ONE");
        dataOwner.setAttachment(this.alas.updateAttachment(dataOwner.cursor().getAttachment(), subOwner.cursor(), true));
        this.assertSet(dataOwner.cursor(), "TWO", "THREE");
        subOwner.setAttachment((Object)"THREE");
        dataOwner.setAttachment(this.alas.updateAttachment(dataOwner.cursor().getAttachment(), subOwner.cursor(), true));
        this.assertSet(dataOwner.cursor(), "TWO");
        subOwner.setAttachment((Object)"TWO");
        dataOwner.setAttachment(this.alas.updateAttachment(dataOwner.cursor().getAttachment(), subOwner.cursor(), true));
        this.assertSet(dataOwner.cursor(), new String[0]);
        Assert.assertNull((Object)dataOwner.cursor().getAttachment());
    }

    private void assertSet(RecordCursor data, String ... ss) {
        this.set.clear();
        this.alas.processEach(data, (Object)this);
        Assert.assertEquals((long)ss.length, (long)this.set.size());
        for (String s : ss) {
            Assert.assertTrue((boolean)this.set.contains(s));
        }
    }
}

