/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.kit;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDFilter;
import com.devexperts.qd.SymbolCodec;
import com.devexperts.qd.kit.DefaultScheme;
import com.devexperts.qd.kit.PentaCodec;
import com.devexperts.qd.kit.RangeFilter;
import com.devexperts.qd.kit.RangeUtil;
import org.junit.Assert;
import org.junit.Test;

public class RangeFilterTest {
    private static final DataScheme SCHEME = new DefaultScheme((SymbolCodec)PentaCodec.INSTANCE, new DataRecord[0]);

    @Test
    public void testInvalidRangeFilter() {
        RangeFilterTest.assertInvalidFilter("range");
        RangeFilterTest.assertInvalidFilter("range-");
        RangeFilterTest.assertInvalidFilter("rangeABC");
        RangeFilterTest.assertInvalidFilter("rangexAxB");
        RangeFilterTest.assertInvalidFilter("range-A-B--");
        RangeFilterTest.assertInvalidFilter("range-A--B-");
        RangeFilterTest.assertInvalidFilter("rangexAxBxx");
        RangeFilterTest.assertInvalidFilter("range-A-A-");
        RangeFilterTest.assertInvalidFilter("range-B-A-");
    }

    @Test
    public void testInvalidSymbolRangeFilter() {
        RangeFilterTest.assertInvalidFilter("range-#-%-");
        RangeFilterTest.assertInvalidFilter("range-\u1234-\u5678-");
        RangeFilterTest.assertInvalidFilter("range-A-B-\n");
        RangeFilterTest.assertInvalidFilter("range-A-B-123");
        RangeFilterTest.assertInvalidFilter("range-A12345678-B-");
        RangeFilterTest.assertInvalidFilter("range-A-B12345678-");
    }

    @Test
    public void testValidSymbolRangeFilter() {
        Assert.assertNotNull((Object)RangeFilterTest.filter("range---"));
        Assert.assertNotNull((Object)RangeFilterTest.filter("range-A--"));
        Assert.assertNotNull((Object)RangeFilterTest.filter("range--B-"));
        Assert.assertNotNull((Object)RangeFilterTest.filter("range-A-B-"));
        Assert.assertNotNull((Object)RangeFilterTest.filter("range-A1234567-B1234567-"));
    }

    @Test
    public void testUniversalFilter() {
        Assert.assertSame((Object)QDFilter.ANYTHING, (Object)RangeFilterTest.filter("range---"));
    }

    @Test
    public void testSimpleRangeFilter() {
        QDFilter f = RangeFilterTest.filter("range-A-B-");
        RangeFilterTest.assertFilter(f, "0", false);
        RangeFilterTest.assertFilter(f, "A", true);
        RangeFilterTest.assertFilter(f, "ABCD", true);
        RangeFilterTest.assertFilter(f, ".A", true);
        RangeFilterTest.assertFilter(f, "./A", true);
        RangeFilterTest.assertFilter(f, "B", false);
        RangeFilterTest.assertFilter(f, "C", false);
    }

    @Test
    public void testSpreadSymbol() {
        QDFilter f = RangeFilterTest.filter("range-A-B-");
        RangeFilterTest.assertFilter(f, "=A", true);
        RangeFilterTest.assertFilter(f, "=-A", true);
        RangeFilterTest.assertFilter(f, "=-2*A", true);
        RangeFilterTest.assertFilter(f, "=-2.2*A", true);
        RangeFilterTest.assertFilter(f, "=-2.2*.A", true);
        RangeFilterTest.assertFilter(f, "=-2.2*./A", true);
        RangeFilterTest.assertFilter(f, "=-2.2*.AC-100.0", true);
        RangeFilterTest.assertFilter(f, "=-2.2*.AP-100.0", true);
    }

    @Test
    public void testLeftRangeSymbol() {
        QDFilter f = RangeFilterTest.filter("range--AAA-");
        RangeFilterTest.assertFilter(f, "", true);
        RangeFilterTest.assertFilter(f, "0", true);
        RangeFilterTest.assertFilter(f, "000000000000", true);
        RangeFilterTest.assertFilter(f, "A", true);
        RangeFilterTest.assertFilter(f, "AA", true);
        RangeFilterTest.assertFilter(f, "AA0", true);
        RangeFilterTest.assertFilter(f, "AA0000000000", true);
        RangeFilterTest.assertFilter(f, "AA1", true);
    }

    @Test
    public void testRightRangeSymbol() {
        QDFilter f = RangeFilterTest.filter("range-AAA--");
        RangeFilterTest.assertFilter(f, "AAA", true);
        RangeFilterTest.assertFilter(f, ".AAA", true);
        RangeFilterTest.assertFilter(f, "/AAA", true);
        RangeFilterTest.assertFilter(f, "=AAA", true);
        RangeFilterTest.assertFilter(f, "AAAA", true);
        RangeFilterTest.assertFilter(f, "AAA000000000", true);
        RangeFilterTest.assertFilter(f, ".AAA00000000", true);
        RangeFilterTest.assertFilter(f, "/AAA00000000", true);
        RangeFilterTest.assertFilter(f, "=-2.*AAA00000000", true);
        RangeFilterTest.assertFilter(f, "ZZZZZZZZZZZZ", true);
        RangeFilterTest.assertFilter(f, "aaa", true);
        RangeFilterTest.assertFilter(f, "zzz", true);
    }

    @Test
    public void testAllRangeSymbol() {
        QDFilter f = RangeFilterTest.filter("range---");
        RangeFilterTest.assertFilter(f, "AAA", true);
        RangeFilterTest.assertFilter(f, "@", true);
        RangeFilterTest.assertFilter(f, "{}", true);
        RangeFilterTest.assertFilter(f, "\uffff", true);
    }

    @Test
    public void testEncodingSymbol() {
        String pseudoAA = "A\u0141";
        Assert.assertNotEquals((long)RangeUtil.encodeSymbol((String)"AA"), (long)RangeUtil.encodeSymbol((String)pseudoAA));
        QDFilter f = RangeFilterTest.filter("range-AA-AB-");
        RangeFilterTest.assertFilter(f, "AA", true);
        RangeFilterTest.assertFilter(f, pseudoAA, false);
    }

    @Test
    public void testOutOfRangeSymbol() {
        QDFilter f = RangeFilterTest.filter("range--A-");
        RangeFilterTest.assertFilter(f, "~", true);
        RangeFilterTest.assertFilter(f, "\u007f", true);
        RangeFilterTest.assertFilter(f, "\u00ff", true);
        RangeFilterTest.assertFilter(f, "{|}", true);
    }

    @Test
    public void testOutOfRangeCipher() {
        QDFilter f = RangeFilterTest.filter("range--A-");
        RangeFilterTest.assertFilter(f, "~", true);
        RangeFilterTest.assertFilter(f, "{|}", true);
    }

    @Test
    public void testOutOfRangeInvalidSymbol() {
        QDFilter f = RangeFilterTest.filter("range-A-a-");
        RangeFilterTest.assertFilter(f, "[^]", false);
    }

    @Test
    public void testSimpleCode() {
        QDFilter f = RangeFilterTest.filter("range-A-B-");
        RangeFilterTest.assertFilter(f, "0", false);
        RangeFilterTest.assertFilter(f, "A", true);
        RangeFilterTest.assertFilter(f, "ABCD", true);
        RangeFilterTest.assertFilter(f, ".A", true);
        RangeFilterTest.assertFilter(f, "./A", true);
        RangeFilterTest.assertFilter(f, "=A-B", true);
        RangeFilterTest.assertFilter(f, "B", false);
        RangeFilterTest.assertFilter(f, "C", false);
    }

    private static QDFilter filter(String spec) {
        return RangeFilter.valueOf((DataScheme)SCHEME, (String)spec);
    }

    private static void assertFilter(QDFilter filter, String s, boolean condition) {
        int cipher = SCHEME.getCodec().encode(s);
        if (cipher != 0) {
            Assert.assertEquals((String)("Symbol " + s + " with filter " + filter), (Object)condition, (Object)filter.accept(null, null, cipher, null));
        }
        Assert.assertEquals((String)("Symbol " + s + " with filter " + filter), (Object)condition, (Object)filter.accept(null, null, 0, s));
    }

    private static void assertInvalidFilter(String spec) {
        Assert.assertThrows(IllegalArgumentException.class, () -> RangeFilterTest.filter(spec));
    }
}

