/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.kit;

import com.devexperts.qd.kit.RangeUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;

public class RangePrefixTest {
    static Matcher matcher = Pattern.compile("(?:=[-+]?[0-9]+(?:\\.[0-9]*)?\\*)?[^a-zA-Z0-9]*(.*)").matcher("");

    @Test
    public void testSymbolPrefix() {
        RangePrefixTest.assertPrefix(".|A");
        RangePrefixTest.assertPrefix("./|A");
        RangePrefixTest.assertPrefix("$|A");
        RangePrefixTest.assertPrefix("?^%#$^@|A");
        RangePrefixTest.assertPrefix("[]{}()$|A");
        RangePrefixTest.assertPrefix("|1234");
    }

    @Test
    public void testSymbolNoPrefix() {
        RangePrefixTest.assertPrefix("?^%#$^@|");
        RangePrefixTest.assertPrefix("\u1234\u4321|");
    }

    @Test
    public void testSpreadPrefix() {
        RangePrefixTest.assertPrefix("=|A");
        RangePrefixTest.assertPrefix("=-|A");
        RangePrefixTest.assertPrefix("=+|A");
        RangePrefixTest.assertPrefix("=2*|A");
        RangePrefixTest.assertPrefix("=+2.*|A");
        RangePrefixTest.assertPrefix("=0.2*|A");
        RangePrefixTest.assertPrefix("=-0.2*|A");
        RangePrefixTest.assertPrefix("=-2*|A");
        RangePrefixTest.assertPrefix("=-2.2*|A");
        RangePrefixTest.assertPrefix("=-2.2*|1234");
        RangePrefixTest.assertPrefix("=-2.*|1234");
        RangePrefixTest.assertPrefix("=2*|");
        RangePrefixTest.assertPrefix("=-2.5*|");
        RangePrefixTest.assertPrefix("=-|2.2.2*IBM+MSFT");
        RangePrefixTest.assertPrefix("=|2.2.2*IBM+MSFT");
        RangePrefixTest.assertPrefix("=|2@2*IBM+MSFT");
        RangePrefixTest.assertPrefix("=|2IBM+2*MSFT");
        RangePrefixTest.assertPrefix("=+|2IBM+2*MSFT");
        RangePrefixTest.assertPrefix("=|2.5IBM+2*MSFT");
        RangePrefixTest.assertPrefix("=-2.5*-|MSFT");
        RangePrefixTest.assertPrefix("=|1234+2345");
        RangePrefixTest.assertPrefix("=|1234-2345");
        RangePrefixTest.assertPrefix("=-|1234-2345");
        RangePrefixTest.assertPrefix("=-1.*|A");
        RangePrefixTest.assertPrefix("=-0.1*|A");
        RangePrefixTest.assertPrefix("=.|1234");
        RangePrefixTest.assertPrefix("=0.12*.|12");
    }

    private static void assertPrefix(String s) {
        int expected = s.indexOf(124);
        if (expected < 0) {
            Assert.fail((String)("Illegal test string: " + s));
        }
        String clean = s.replaceAll("\\|", "");
        int actual = RangeUtil.skipPrefix((String)clean, (int)clean.length());
        Assert.assertEquals((String)("Invalid prefix skip for " + clean), (long)expected, (long)actual);
        matcher.reset(clean);
        Assert.assertTrue((boolean)matcher.matches());
        Assert.assertEquals((String)("Invalid prefix skip for " + clean), (long)matcher.start(1), (long)actual);
    }
}

