/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.kit;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDFilter;
import com.devexperts.qd.SymbolCodec;
import com.devexperts.qd.kit.CompositeFilters;
import com.devexperts.qd.kit.DefaultScheme;
import com.devexperts.qd.kit.MonoStriper;
import com.devexperts.qd.kit.PentaCodec;
import com.devexperts.qd.kit.RangeFilter;
import com.devexperts.qd.kit.RangeStriper;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class RangeStriperTest {
    private static final DataScheme SCHEME = new DefaultScheme((SymbolCodec)PentaCodec.INSTANCE, new DataRecord[0]);

    @Test
    public void testRangeStriperMono() {
        Assert.assertThrows(NullPointerException.class, () -> RangeStriper.valueOf((DataScheme)SCHEME, (String)null));
        Assert.assertThrows(NullPointerException.class, () -> RangeStriper.valueOf((DataScheme)SCHEME, (List)null));
        Assert.assertSame((Object)MonoStriper.INSTANCE, (Object)RangeStriper.valueOf((DataScheme)SCHEME, new ArrayList()));
    }

    @Test
    public void testInvalidRangeStriper() {
        RangeStriperTest.assertInvalidStriper("byrange");
        RangeStriperTest.assertInvalidStriper("byrange-");
        RangeStriperTest.assertInvalidStriper("byrange--");
        RangeStriperTest.assertInvalidStriper("byrangeABC");
        RangeStriperTest.assertInvalidStriper("byrange-A-B");
        RangeStriperTest.assertInvalidStriper("byrangeA-B-C-");
        RangeStriperTest.assertInvalidStriper("byrangeAB-C-");
        RangeStriperTest.assertInvalidStriper("byrange-A-B--");
        RangeStriperTest.assertInvalidStriper("byrangeA-A-");
        RangeStriperTest.assertInvalidStriper("byrange-A-A-");
        RangeStriperTest.assertInvalidStriper("byrange-B-A-");
        RangeStriperTest.assertInvalidStriper("byrange-B-B-");
        RangeStriperTest.assertInvalidStriper("byrange-A12456678-B12345678-");
    }

    @Test
    public void testValidRangeStriper() {
        RangeStriperTest.assertValidStriper("byrange-A-");
        RangeStriperTest.assertValidStriper("byrange-A-B-");
        RangeStriperTest.assertValidStriper("byrange-AAA-AAAA-");
        RangeStriperTest.assertValidStriper("byrange-AAAAAAAA-AAAAAAAB-");
    }

    @Test
    public void testValidFilters() {
        RangeStriperTest.assertStriperFilter("byrange-A-", "--A-", "-A--");
        RangeStriperTest.assertStriperFilter("byrange-A-B-", "--A-", "-A-B-", "-B--");
        RangeStriperTest.assertStriperFilter("byrange-AAAAA-aaaaa-", "--AAAAA-", "-AAAAA-aaaaa-", "-aaaaa--");
    }

    @Test
    public void testShortRange() {
        RangeStriper striper = RangeStriper.valueOf((DataScheme)SCHEME, (String)"byrange-B-D-F-");
        RangeStriperTest.assertStriper(striper, "A", 0);
        RangeStriperTest.assertStriper(striper, "B", 1);
        RangeStriperTest.assertStriper(striper, "C", 1);
        RangeStriperTest.assertStriper(striper, "D", 2);
        RangeStriperTest.assertStriper(striper, "E", 2);
        RangeStriperTest.assertStriper(striper, "F", 3);
        RangeStriperTest.assertStriper(striper, "G", 3);
    }

    @Test
    public void testShortRangeLongSymbol() {
        RangeStriper striper = RangeStriper.valueOf((DataScheme)SCHEME, (String)"byrange-B-D-F-");
        RangeStriperTest.assertStriper(striper, "AAAAAAAAAA", 0);
        RangeStriperTest.assertStriper(striper, "BBBBBBBBBB", 1);
        RangeStriperTest.assertStriper(striper, "CCCCCCCCCC", 1);
        RangeStriperTest.assertStriper(striper, "DDDDDDDDDD", 2);
        RangeStriperTest.assertStriper(striper, "EEEEEEEEEE", 2);
        RangeStriperTest.assertStriper(striper, "FFFFFFFFFF", 3);
        RangeStriperTest.assertStriper(striper, "GGGGGGGGGG", 3);
    }

    @Test
    public void testCustomRange() {
        RangeStriper striper = RangeStriper.valueOf((DataScheme)SCHEME, (String)"byrange-B1234567-");
        RangeStriperTest.assertStriper(striper, "B12345669", 0);
        RangeStriperTest.assertStriper(striper, "B1234567", 1);
        RangeStriperTest.assertStriper(striper, "B1234568", 1);
        RangeStriperTest.assertStriper(striper, "B12345679", 1);
    }

    @Test
    public void testRangeStriperFilterCache() {
        RangeStriper striper = RangeStriper.valueOf((DataScheme)SCHEME, (String)"byrange-A-B-C-");
        Assert.assertNotNull((Object)striper);
        Assert.assertSame((Object)striper.getStripeFilter(2), (Object)striper.getStripeFilter(2));
    }

    @Test
    public void testChar() {
        RangeStriper striper1 = RangeStriper.valueOf((DataScheme)SCHEME, (String)"byrange-S-");
        RangeStriper striper2 = RangeStriper.valueOf((DataScheme)SCHEME, (String)"byrange-K-S-");
        RangeStriper striper3 = RangeStriper.valueOf((DataScheme)SCHEME, (String)"byrange-K-S-U-");
        RangeStriperTest.assertStriper(striper1, "IBM", 0);
        RangeStriperTest.assertStriper(striper1, "EUD/USD", 0);
        RangeStriperTest.assertStriper(striper2, "IBM", 0);
        RangeStriperTest.assertStriper(striper2, "EUD/USD", 0);
        RangeStriperTest.assertStriper(striper3, "IBM", 0);
        RangeStriperTest.assertStriper(striper3, "EUD/USD", 0);
    }

    @Test
    public void testIntersects() {
        RangeStriper striper = RangeStriper.valueOf((DataScheme)SCHEME, (String)"byrange-C-K-P-");
        RangeStriperTest.assertIntersect(striper, "range--A-", "1000");
        RangeStriperTest.assertIntersect(striper, "range--C-", "1000");
        RangeStriperTest.assertIntersect(striper, "range-A-B-", "1000");
        RangeStriperTest.assertIntersect(striper, "range-C-K-", "0100");
        RangeStriperTest.assertIntersect(striper, "range-D-E-", "0100");
        RangeStriperTest.assertIntersect(striper, "range-K-P-", "0010");
        RangeStriperTest.assertIntersect(striper, "range-M-O-", "0010");
        RangeStriperTest.assertIntersect(striper, "range-P--", "0001");
        RangeStriperTest.assertIntersect(striper, "range-T--", "0001");
        RangeStriperTest.assertIntersect(striper, "range-T-V-", "0001");
        RangeStriperTest.assertIntersect(striper, "range--K-", "1100");
        RangeStriperTest.assertIntersect(striper, "range--E-", "1100");
        RangeStriperTest.assertIntersect(striper, "range-B-E-", "1100");
        RangeStriperTest.assertIntersect(striper, "range-C-M-", "0110");
        RangeStriperTest.assertIntersect(striper, "range-E-M-", "0110");
        RangeStriperTest.assertIntersect(striper, "range-C-P-", "0110");
        RangeStriperTest.assertIntersect(striper, "range-K--", "0011");
        RangeStriperTest.assertIntersect(striper, "range-M--", "0011");
        RangeStriperTest.assertIntersect(striper, "range-M-T-", "0011");
        RangeStriperTest.assertIntersect(striper, "range--P-", "1110");
        RangeStriperTest.assertIntersect(striper, "range--M-", "1110");
        RangeStriperTest.assertIntersect(striper, "range-A-M-", "1110");
        RangeStriperTest.assertIntersect(striper, "range-C--", "0111");
        RangeStriperTest.assertIntersect(striper, "range-D--", "0111");
        RangeStriperTest.assertIntersect(striper, "range-C-T-", "0111");
        RangeStriperTest.assertIntersect(striper, "range-D-T-", "0111");
        RangeStriperTest.assertIntersect(striper, "range-B--", "1111");
        RangeStriperTest.assertIntersect(striper, "range-A-T-", "1111");
        RangeStriperTest.assertIntersect(striper, "range--T-", "1111");
    }

    @Test
    public void testIntersectsUnknownFilter() {
        RangeStriper striper = RangeStriper.valueOf((DataScheme)SCHEME, (String)"byrange-C-K-P-");
        Assert.assertNull((Object)striper.getIntersectingStripes(QDFilter.ANYTHING));
        Assert.assertNull((Object)striper.getIntersectingStripes(QDFilter.NOTHING));
        Assert.assertNull((Object)striper.getIntersectingStripes(CompositeFilters.valueOf((String)"A*", (DataScheme)SCHEME)));
    }

    private static void assertInvalidStriper(String spec) {
        Assert.assertThrows(IllegalArgumentException.class, () -> RangeStriper.valueOf((DataScheme)SCHEME, (String)spec));
    }

    private static void assertValidStriper(String spec) {
        RangeStriper rangeStriper = RangeStriper.valueOf((DataScheme)SCHEME, (String)spec);
        Assert.assertEquals((Object)spec, (Object)rangeStriper.toString());
    }

    private static void assertStriperFilter(String spec, String ... filterSpec) {
        RangeStriper s = RangeStriper.valueOf((DataScheme)SCHEME, (String)spec);
        Assert.assertEquals((long)filterSpec.length, (long)s.getStripeCount());
        for (int i = 0; i < filterSpec.length; ++i) {
            Assert.assertEquals((String)("Invalid filter " + i + " of " + s), (Object)("range" + filterSpec[i]), (Object)s.getStripeFilter(i).toString());
        }
    }

    private static void assertStriper(RangeStriper striper, String s, int index) {
        int cipher = SCHEME.getCodec().encode(s);
        if (cipher != 0) {
            Assert.assertEquals((String)("Index for symbol " + s + " in " + striper), (long)index, (long)striper.getStripeIndex(cipher, null));
        }
        Assert.assertEquals((String)("Index for symbol " + s + " in " + striper), (long)index, (long)striper.getStripeIndex(0, s));
        Assert.assertEquals((String)("Index for symbol " + s + " in " + striper), (long)index, (long)striper.getStripeIndex(s.toCharArray(), 0, s.length()));
        for (int i = 0; i < striper.getStripeCount(); ++i) {
            Assert.assertEquals((Object)(i == index ? 1 : 0), (Object)striper.getStripeFilter(i).accept(null, null, cipher, s));
        }
    }

    private static void assertIntersect(RangeStriper striper, String filter, String stripes) {
        BitSet intersect = striper.getIntersectingStripes(RangeFilter.valueOf((DataScheme)SCHEME, (String)filter));
        if (stripes.length() != striper.getStripeCount()) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < stripes.length(); ++i) {
            if (stripes.charAt(i) == '1') {
                Assert.assertTrue((String)(filter + " should intersect with " + striper.getStripeFilter(i)), (boolean)intersect.get(i));
                continue;
            }
            Assert.assertFalse((String)(filter + " should not intersect with " + striper.getStripeFilter(i)), (boolean)intersect.get(i));
        }
    }
}

