/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.test;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.QDFilter;
import com.devexperts.qd.SymbolCodec;
import com.devexperts.qd.kit.CompositeFilters;
import com.devexperts.qd.kit.DefaultScheme;
import com.devexperts.qd.kit.PentaCodec;
import org.junit.Assert;
import org.junit.Test;

public class DynamicFilterTest {
    private static final DataScheme SCHEME = new DefaultScheme((SymbolCodec)PentaCodec.INSTANCE, new DataRecord[0]);
    TestFilter one = new TestFilter(SCHEME, "one");
    TestFilter two = new TestFilter(SCHEME, "two");
    QDFilter curFilter;
    TestListener filter = new TestListener();

    @Test
    public void testDynamicCompositeFireAlways() {
        this.curFilter = CompositeFilters.makeAnd((QDFilter)this.one, (QDFilter)this.two);
        this.curFilter.getUpdated().addUpdateListener((QDFilter.UpdateListener)this.filter);
        this.assertCurValid();
        this.assertTracking();
        for (int i = 0; i < 100; ++i) {
            this.one.updateIt();
            this.assertFired();
            this.assertTracking();
            this.two.updateIt();
            this.assertFired();
            this.assertTracking();
        }
        this.curFilter.getUpdated().removeUpdateListener((QDFilter.UpdateListener)this.filter);
        this.assertCurValid();
        this.assertNotTracking();
        this.one.updateIt();
        this.assertNotFired();
    }

    @Test
    public void testDynamicCompositeFireOnce() {
        this.curFilter = CompositeFilters.makeAnd((QDFilter)this.one, (QDFilter)this.two);
        this.curFilter.addUpdateListener((QDFilter.UpdateListener)this.filter);
        this.assertCurValid();
        this.assertTracking();
        this.one.updateIt();
        this.assertFired();
        this.assertNotTracking();
        this.two.updateIt();
        this.assertNotFired();
        this.assertNotTracking();
    }

    private void assertCurValid() {
        Assert.assertEquals((Object)"one&two", (Object)this.curFilter.toString());
    }

    private void update() {
        this.one = (TestFilter)this.one.getUpdatedFilter();
        this.two = (TestFilter)this.two.getUpdatedFilter();
    }

    private void assertTracking() {
        this.update();
        Assert.assertTrue((boolean)this.one.dynamicTracking);
        Assert.assertTrue((boolean)this.two.dynamicTracking);
    }

    private void assertNotTracking() {
        this.update();
        Assert.assertFalse((boolean)this.one.dynamicTracking);
        Assert.assertFalse((boolean)this.two.dynamicTracking);
    }

    private void assertFired() {
        Assert.assertNotNull((Object)this.filter.fired);
        Assert.assertSame((Object)this.filter.fired, (Object)this.curFilter);
        this.curFilter = this.curFilter.getUpdatedFilter();
        Assert.assertNotSame((Object)this.curFilter, (Object)this.filter.fired);
        this.filter.fired = null;
        this.assertCurValid();
    }

    private void assertNotFired() {
        Assert.assertNull((Object)this.filter.fired);
    }

    private class TestListener
    implements QDFilter.UpdateListener {
        QDFilter fired;

        private TestListener() {
        }

        public void filterUpdated(QDFilter filter) {
            Assert.assertNull((Object)this.fired);
            Assert.assertSame((Object)filter, (Object)DynamicFilterTest.this.curFilter);
            this.fired = filter;
        }
    }

    private static class TestFilter
    extends QDFilter {
        boolean dynamicTracking;

        TestFilter(DataScheme scheme, String name) {
            super(scheme);
            this.setName(name);
        }

        TestFilter(DataScheme scheme, QDFilter source) {
            super(scheme, source);
            this.setName(source.toString());
        }

        public boolean accept(QDContract contract, DataRecord record, int cipher, String symbol) {
            return false;
        }

        public boolean isDynamic() {
            return true;
        }

        public void updateIt() {
            this.fireFilterUpdated(new TestFilter(this.getScheme(), this));
        }

        protected void dynamicTrackingStart() {
            Assert.assertFalse((boolean)this.dynamicTracking);
            this.dynamicTracking = true;
        }

        protected void dynamicTrackingStop() {
            Assert.assertTrue((boolean)this.dynamicTracking);
            this.dynamicTracking = false;
        }
    }
}

