/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.util;

import com.devexperts.qd.qtp.AddressSyntaxException;
import com.devexperts.qd.util.QDConfig;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class QDConfigTest {
    @Test
    public void testSplitParenthesisSeparated() {
        Assert.assertEquals(Arrays.asList("a"), (Object)QDConfig.splitParenthesisSeparatedString((String)"a"));
        Assert.assertEquals(Arrays.asList("a(b)c"), (Object)QDConfig.splitParenthesisSeparatedString((String)"a(b)c"));
        Assert.assertEquals(Arrays.asList("(a)"), (Object)QDConfig.splitParenthesisSeparatedString((String)"((a))"));
        Assert.assertEquals(Arrays.asList("a", "b"), (Object)QDConfig.splitParenthesisSeparatedString((String)"(a)(b)"));
        Assert.assertEquals(Arrays.asList("a", "(b)", "c"), (Object)QDConfig.splitParenthesisSeparatedString((String)"(a)((b))(c)"));
        Assert.assertEquals(Arrays.asList("a(b)c"), (Object)QDConfig.splitParenthesisSeparatedString((String)"(a(b)c)"));
    }

    @Test
    public void testExpectedError() {
        QDConfigTest.assertSyntaxError("(abc");
        QDConfigTest.assertSyntaxError("(abc)de");
        QDConfigTest.assertSyntaxError("(:Quote&(IBM,MSFT)@:12345");
    }

    private static void assertSyntaxError(String s) {
        Assert.assertThrows((String)("Should have failed:" + s), AddressSyntaxException.class, () -> QDConfig.splitParenthesisSeparatedString((String)s));
    }
}

