/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp.file;

import com.devexperts.io.BufferedOutput;
import com.devexperts.io.Chunk;
import com.devexperts.io.ChunkList;
import com.devexperts.io.ChunkedOutput;
import com.devexperts.qd.qtp.FileConstants;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class ParallelWriter
implements Closeable {
    private static final Task CLOSE_THREAD_TASK = new Task();
    private static final Task EMPTY_TASK = new Task();
    private final TaskQueue todoQueue;
    private final TaskQueue doneQueue;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicReference<Throwable> throwable = new AtomicReference();
    private final Worker worker;
    private final Output output;

    ParallelWriter(String name, int taskQueueSize) {
        this.todoQueue = new TaskQueue(taskQueueSize);
        this.doneQueue = new TaskQueue(taskQueueSize);
        this.worker = new Worker(name);
        this.output = new Output(taskQueueSize);
    }

    public void start() {
        if (this.closed.get()) {
            throw new IllegalStateException("closed");
        }
        this.worker.start();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        this.todoQueue.put(CLOSE_THREAD_TASK);
        try {
            this.worker.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.checkThrowable();
    }

    public BufferedOutput open(Opener opener, Runnable closeHandler) {
        if (this.output.isOpen || this.closed.get()) {
            throw new IllegalStateException();
        }
        this.output.isOpen = true;
        this.output.opener = opener;
        this.output.closeHandler = closeHandler;
        return this.output;
    }

    private void checkThrowable() throws IOException {
        Throwable t = this.throwable.getAndSet(null);
        if (t == null) {
            return;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        throw new RuntimeException(t);
    }

    private static class TaskQueue {
        private final Lock lock = new ReentrantLock(true);
        private final Condition notFull = this.lock.newCondition();
        private final Condition notEmpty = this.lock.newCondition();
        private final int n;
        private final Task[] a;
        private int head;
        private int tail;

        TaskQueue(int maxSize) {
            this.n = maxSize + 1;
            this.a = new Task[maxSize + 1];
        }

        public Task poll() {
            this.lock.lock();
            try {
                Task task = this.pollImpl();
                return task;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Task poll(long time, TimeUnit unit) {
            this.lock.lock();
            try {
                if (this.head == this.tail) {
                    try {
                        this.notEmpty.await(time, unit);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                Task task = this.pollImpl();
                return task;
            }
            finally {
                this.lock.unlock();
            }
        }

        public Task take() {
            this.lock.lock();
            try {
                while (this.head == this.tail) {
                    this.notEmpty.awaitUninterruptibly();
                }
                Task task = this.pollImpl();
                return task;
            }
            finally {
                this.lock.unlock();
            }
        }

        private Task pollImpl() {
            if (this.head == this.tail) {
                return null;
            }
            Task task = this.a[this.head];
            this.head = (this.head + 1) % this.n;
            this.notFull.signalAll();
            return task;
        }

        public void put(Task task) {
            this.lock.lock();
            try {
                while (!this.offerImpl(task)) {
                    this.notFull.awaitUninterruptibly();
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        public boolean offer(Task task) {
            this.lock.lock();
            try {
                boolean bl = this.offerImpl(task);
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        boolean offerImpl(Task task) {
            int nextTail = (this.tail + 1) % this.n;
            if (nextTail == this.head) {
                return false;
            }
            this.a[this.tail] = task;
            this.tail = nextTail;
            this.notEmpty.signalAll();
            return true;
        }
    }

    private class Worker
    extends Thread {
        private OutputStream out;
        private long nextFlushTime;

        Worker(String name) {
            super(name);
        }

        @Override
        public void run() {
            Task task;
            while ((task = ParallelWriter.this.todoQueue.poll(FileConstants.MAX_BUFFER_TIME, TimeUnit.MILLISECONDS)) != CLOSE_THREAD_TASK) {
                try {
                    this.runTask(task == null ? EMPTY_TASK : task);
                }
                catch (Throwable t) {
                    ParallelWriter.this.throwable.set(t);
                }
                if (task == null) continue;
                ParallelWriter.this.doneQueue.offer(task);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runTask(Task task) throws IOException {
            try {
                long currentTime = System.currentTimeMillis();
                if (task.opener != null) {
                    assert (this.out == null);
                    this.out = task.opener.open();
                    this.nextFlushTime = currentTime + FileConstants.MAX_BUFFER_TIME;
                    task.opener = null;
                }
                if (task.chunks != null) {
                    Chunk chunk;
                    while ((chunk = task.chunks.poll((Object)this)) != null) {
                        this.out.write(chunk.getBytes(), chunk.getOffset(), chunk.getLength());
                        chunk.recycle((Object)this);
                    }
                    task.chunks.recycle((Object)this);
                }
                if (this.out != null && !task.close && currentTime >= this.nextFlushTime) {
                    this.out.flush();
                    this.nextFlushTime = currentTime + FileConstants.MAX_BUFFER_TIME;
                }
            }
            finally {
                if (task.close && this.out != null) {
                    OutputStream toBeClosed = this.out;
                    this.out = null;
                    toBeClosed.close();
                    if (task.closeHandler != null) {
                        task.closeHandler.run();
                    }
                }
            }
        }
    }

    private class Output
    extends ChunkedOutput {
        private boolean isOpen;
        private boolean closeOnFlush;
        private Opener opener;
        private Runnable closeHandler;
        private int taskQueueSize;

        Output(int taskQueueSize) {
            this.taskQueueSize = taskQueueSize;
        }

        public synchronized void flush() throws IOException {
            ChunkList chunks = this.getOutput(ParallelWriter.this.worker);
            if (chunks != null && !chunks.isEmpty()) {
                this.queueTask(chunks);
            }
        }

        protected synchronized void needSpace() throws IOException {
            super.needSpace();
        }

        public synchronized void writeFromChunk(Chunk chunk, Object owner) throws IOException {
            super.writeFromChunk(chunk, owner);
        }

        public synchronized void writeAllFromChunkList(ChunkList chunks, Object owner) throws IOException {
            super.writeAllFromChunkList(chunks, owner);
        }

        public synchronized void close() throws IOException {
            if (!this.isOpen) {
                throw new IllegalStateException();
            }
            this.isOpen = false;
            this.closeOnFlush = true;
            this.flush();
            if (this.closeOnFlush) {
                this.queueTask(null);
            }
        }

        private void queueTask(ChunkList chunks) throws IOException {
            Task writeTask = ParallelWriter.this.doneQueue.poll();
            if (writeTask == null) {
                if (this.taskQueueSize > 0) {
                    writeTask = new Task();
                    --this.taskQueueSize;
                } else {
                    writeTask = ParallelWriter.this.doneQueue.take();
                }
            }
            writeTask.opener = this.opener;
            writeTask.closeHandler = this.closeHandler;
            writeTask.chunks = chunks;
            writeTask.close = this.closeOnFlush;
            this.opener = null;
            if (this.closeOnFlush) {
                this.closeHandler = null;
            }
            this.closeOnFlush = false;
            ParallelWriter.this.todoQueue.put(writeTask);
            ParallelWriter.this.checkThrowable();
        }
    }

    private static class Task {
        Opener opener;
        Runnable closeHandler;
        ChunkList chunks;
        boolean close;

        private Task() {
        }
    }

    public static interface Opener {
        public OutputStream open() throws IOException;
    }
}

