/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp.text;

import com.devexperts.io.BufferedOutput;
import com.devexperts.logging.Logging;
import com.devexperts.qd.DataField;
import com.devexperts.qd.DataIntField;
import com.devexperts.qd.DataObjField;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.kit.VoidIntField;
import com.devexperts.qd.ng.EventFlag;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.qtp.AbstractQTPComposer;
import com.devexperts.qd.qtp.HeartbeatPayload;
import com.devexperts.qd.qtp.MessageType;
import com.devexperts.qd.qtp.ProtocolDescriptor;
import com.devexperts.qd.qtp.RuntimeQTPException;
import com.devexperts.qd.qtp.text.TextCoding;
import com.devexperts.qd.qtp.text.TextDelimiters;
import com.devexperts.qd.util.TimeSequenceUtil;
import com.devexperts.util.SystemProperties;
import com.devexperts.util.TimeFormat;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class TextQTPComposer
extends AbstractQTPComposer {
    private static final boolean USE_LEGACY_QD_PREFIX = SystemProperties.getBooleanProperty((String)"com.devexperts.qd.qtp.text.TextByteArrayComposer.useLegacyQDPrefix", (boolean)false);
    private static final boolean USE_LOCAL_NAMES = SystemProperties.getBooleanProperty((String)"com.devexperts.qd.qtp.text.TextByteArrayComposer.useLocalNames", (boolean)false);
    private static final Logging log = Logging.getLogging(TextQTPComposer.class);
    private static final byte[] lineSeparator;
    private MessageType currentMessageType;
    private MessageType prevMessageType;
    private boolean newLine = true;
    private TextDelimiters delimiters = TextDelimiters.TAB_SEPARATED;

    public TextQTPComposer(DataScheme scheme) {
        super(scheme, true);
    }

    public void setDelimiters(TextDelimiters delimiters) {
        this.delimiters = delimiters;
    }

    protected boolean acceptField(DataField f) {
        return !(f instanceof VoidIntField);
    }

    public void resetSession() {
        super.resetSession();
        this.currentMessageType = null;
        this.newLine = true;
    }

    protected void writeDescribeProtocolMessage(BufferedOutput out, ProtocolDescriptor descriptor) throws IOException {
        String prefix = this.delimiters.messageTypePrefix;
        if (prefix == null) {
            return;
        }
        this.write(prefix + "DXP3");
        for (String token : descriptor.convertToTextTokens()) {
            this.separator();
            this.write(token);
        }
        this.writeln();
        this.finishComposingMessage(out);
    }

    protected void writeEmptyHeartbeatMessage(BufferedOutput out) throws IOException {
        String prefix = this.delimiters.messageTypePrefix;
        if (prefix == null) {
            return;
        }
        this.write(prefix);
        this.writeln();
        this.finishComposingMessage(out);
    }

    protected void writeHeartbeatMessage(BufferedOutput out, HeartbeatPayload heartbeatPayload) throws IOException {
        String prefix = this.delimiters.messageTypePrefix;
        if (prefix == null) {
            return;
        }
        this.write(prefix);
        for (String token : heartbeatPayload.convertToTextTokens()) {
            this.separator();
            this.write(token);
        }
        this.writeln();
        this.finishComposingMessage(out);
    }

    protected void writeMessageHeader(MessageType messageType) {
        this.writeln();
        this.prevMessageType = this.currentMessageType;
        if (this.currentMessageType == messageType) {
            return;
        }
        this.currentMessageType = messageType;
        if (messageType != null) {
            String prefix = this.delimiters.messageTypePrefix;
            if (prefix != null) {
                this.write(prefix + (USE_LEGACY_QD_PREFIX ? "QD_" : "") + messageType.toString());
                this.writeln();
            }
        } else {
            log.error("Unknown message in composer: " + messageType);
        }
    }

    protected void undoWriteMessageHeaderStateChange() {
        this.currentMessageType = this.prevMessageType;
        this.prevMessageType = null;
    }

    protected void finishComposingMessage(BufferedOutput out) throws IOException {
        this.writeln();
        super.finishComposingMessage(out);
    }

    protected void writeHistorySubscriptionTime(DataRecord record, long time) {
        this.separator();
        if (!record.hasTime()) {
            throw new IllegalArgumentException("Met history subscription for record with no time coordinate.");
        }
        if (time != 0L) {
            this.writeIntField(record.getIntField(0), (int)(time >>> 32));
            this.writeIntField(record.getIntField(1), (int)time);
        }
    }

    protected int writeRecordHeader(DataRecord record, int cipher, String symbol, int eventFlags) {
        this.writeln();
        this.write(record.getName());
        this.separator();
        this.write(record.getScheme().getCodec().decode(cipher, symbol));
        return eventFlags;
    }

    protected void writeRecordPayload(RecordCursor cursor, int eventFlags) throws IOException {
        String s;
        super.writeRecordPayload(cursor, eventFlags);
        if (eventFlags != 0 && !(s = EventFlag.formatEventFlags((int)eventFlags, (MessageType)this.currentMessageType)).isEmpty()) {
            this.separator();
            this.write("EventFlags=" + s);
        }
    }

    protected void writeEventTimeSequence(long eventTimeSequence) throws IOException {
        this.separator();
        this.write(TimeFormat.DEFAULT.withTimeZone().withMillis().format(TimeSequenceUtil.getTimeMillisFromTimeSequence((long)eventTimeSequence)));
    }

    protected void writeIntField(DataIntField field, int value) {
        if (this.acceptField((DataField)field)) {
            this.separator();
            this.write(field.toString(value));
        }
    }

    protected void writeObjField(DataObjField field, Object value) {
        if (this.acceptField((DataField)field)) {
            this.separator();
            this.write(field.toString(value));
        }
    }

    protected void writeField(DataField field, RecordCursor cursor) {
        if (this.acceptField(field)) {
            this.separator();
            this.write(field.getString(cursor));
        }
    }

    protected void describeRecord(DataRecord record) {
        this.writeln();
        this.writeDescribeRecordLine(record);
    }

    protected final void writeDescribeRecordLine(DataRecord record) {
        DataIntField field;
        int i;
        this.write(this.delimiters.describePrefix + record.getName());
        this.separator();
        this.write(USE_LOCAL_NAMES ? "Symbol" : "EventSymbol");
        if (this.writeEventTimeSequence) {
            this.separator();
            this.write("EventTime");
        }
        for (i = 0; i < record.getIntFieldCount(); ++i) {
            field = record.getIntField(i);
            if (!this.acceptField((DataField)field)) continue;
            this.separator();
            this.write(USE_LOCAL_NAMES ? field.getLocalName() : field.getPropertyName());
        }
        for (i = 0; i < record.getObjFieldCount(); ++i) {
            field = record.getObjField(i);
            if (!this.acceptField((DataField)field)) continue;
            this.separator();
            this.write(USE_LOCAL_NAMES ? field.getLocalName() : field.getPropertyName());
        }
        this.writeln();
    }

    protected void write(String token) {
        boolean quote = (token = TextCoding.encode(token)).indexOf(32) >= 0 || token.isEmpty() || token.indexOf(this.delimiters.fieldSeparatorChar) >= 0;
        try {
            if (quote) {
                this.msg.write(34);
            }
            this.msg.writeBytes(token);
            if (quote) {
                this.msg.write(34);
            }
        }
        catch (IOException e) {
            throw new RuntimeQTPException((Throwable)e);
        }
        this.newLine = false;
    }

    protected void writeln() {
        if (!this.newLine) {
            try {
                this.msg.write(lineSeparator);
            }
            catch (IOException e) {
                throw new RuntimeQTPException((Throwable)e);
            }
            this.newLine = true;
        }
    }

    protected void separator() {
        try {
            this.msg.writeByte((int)this.delimiters.fieldSeparatorChar);
        }
        catch (IOException e) {
            throw new RuntimeQTPException((Throwable)e);
        }
        this.newLine = false;
    }

    static {
        try {
            lineSeparator = SystemProperties.getProperty((String)"line.separator", (String)"\n").getBytes("ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

