/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp.file;

import com.devexperts.io.BufferedInput;
import com.devexperts.logging.Logging;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.qtp.BinaryQTPParser;
import com.devexperts.qd.qtp.MessageType;
import com.devexperts.qd.qtp.QTPConstants;
import com.devexperts.util.SystemProperties;
import java.io.EOFException;
import java.io.IOException;

public class BinaryFileQTPParser
extends BinaryQTPParser {
    private static final int MAX_RESYNC_MESSAGE_LENGTH = SystemProperties.getIntProperty(BinaryFileQTPParser.class, (String)"maxResyncMessageLength", (int)(QTPConstants.COMPOSER_THRESHOLD + 100));
    private static final Logging log = Logging.getLogging(BinaryFileQTPParser.class);
    private MessageType resyncOn;
    private boolean inSync;
    private int skippedToResync = 0;
    private boolean schemeKnown;

    public BinaryFileQTPParser(DataScheme scheme) {
        super(scheme);
    }

    public void setResyncOn(MessageType resyncOn) {
        this.resyncOn = resyncOn;
    }

    public boolean isSchemeKnown() {
        return this.schemeKnown;
    }

    public void setSchemeKnown(boolean schemeKnown) {
        this.schemeKnown = schemeKnown;
    }

    protected boolean resyncOnParse(BufferedInput in) throws IOException {
        if (this.inSync || this.resyncOn == null) {
            return true;
        }
        return this.resyncImpl(in);
    }

    private boolean resyncImpl(BufferedInput in) throws IOException {
        while (in.hasAvailable()) {
            in.mark();
            boolean ok = false;
            try {
                int length = in.readCompactInt();
                if (length > 0 && length < MAX_RESYNC_MESSAGE_LENGTH) {
                    ok = MessageType.findById((int)in.readCompactInt()) == this.resyncOn;
                }
            }
            catch (EOFException e) {
                in.unmark();
                return false;
            }
            in.reset();
            if (ok) {
                if (this.skippedToResync > 0) {
                    log.info("Skipped " + this.skippedToResync + " bytes to resync stream on " + this.resyncOn + " message at most " + MAX_RESYNC_MESSAGE_LENGTH + " bytes long");
                    this.skippedToResync = 0;
                }
                this.inSync = true;
                return true;
            }
            in.read();
            ++this.skippedToResync;
        }
        return false;
    }

    protected boolean resyncOnCorrupted(BufferedInput in) throws IOException {
        if (this.resyncOn == null) {
            return false;
        }
        in.reset();
        in.read();
        ++this.skippedToResync;
        this.inSync = false;
        return true;
    }
}

