/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp.file;

import com.devexperts.qd.qtp.file.FileUtils;
import com.devexperts.qd.qtp.file.TimestampedFile;
import com.devexperts.util.InvalidFormatException;
import com.devexperts.util.TimeFormat;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;

class TimestampedFilenameFilter
implements FilenameFilter {
    private static final Pattern TIMESTAMP_PATTERN = Pattern.compile("\\d{8}-\\d{6}[+-]\\d{4}");
    private final File directory;
    private final String fileNamePrefix;
    private final String containerExtension;
    private final String fullSuffix;
    private long startTime = Long.MIN_VALUE;
    private long prevTime = Long.MIN_VALUE;
    private long stopTime = Long.MAX_VALUE;
    private long lastTimeForPath = 0L;
    private boolean requireTimeFile;

    public static TimestampedFilenameFilter create(File file, String containerExtension) {
        String shortName = file.getName();
        if (!shortName.endsWith(containerExtension)) {
            throw new IllegalArgumentException();
        }
        int timestampPos = (shortName = shortName.substring(0, shortName.length() - containerExtension.length())).indexOf("~");
        if (timestampPos == -1) {
            return null;
        }
        String prefix = shortName.substring(0, timestampPos);
        String suffix = shortName.substring(timestampPos + "~".length());
        int anotherTimestampPos = suffix.indexOf("~");
        if (anotherTimestampPos != -1) {
            throw new InvalidFormatException("There can be only one timestamp label in file name");
        }
        File dir = file.getParentFile();
        return new TimestampedFilenameFilter(dir == null ? new File(".") : dir, prefix, suffix, containerExtension);
    }

    private TimestampedFilenameFilter(File directory, String fileNamePrefix, String fileNameSuffix, String containerExtension) {
        this.directory = directory;
        this.fileNamePrefix = fileNamePrefix;
        this.containerExtension = containerExtension;
        this.fullSuffix = fileNameSuffix + containerExtension;
    }

    private static long getDateFromFile(File file, TimestampedFilenameFilter filter) {
        String fileName = file.getName();
        String dateStr = fileName.substring(filter.fileNamePrefix.length(), fileName.length() - filter.fullSuffix.length());
        return TimeFormat.DEFAULT.parse(dateStr).getTime();
    }

    public String getPathForTime(long time) {
        this.lastTimeForPath = Math.max(this.lastTimeForPath + 1000L, time);
        return new File(this.directory, this.fileNamePrefix + TimeFormat.DEFAULT.withTimeZone().format(this.lastTimeForPath) + this.fullSuffix).getPath();
    }

    public TimestampedFile[] listTimestampedFiles() {
        File[] files = this.directory.listFiles(this);
        ArrayList<TimestampedFile> timestampedFiles = new ArrayList<TimestampedFile>(files == null ? 0 : files.length);
        if (files != null) {
            for (File file : files) {
                timestampedFiles.add(new TimestampedFile(file, TimestampedFilenameFilter.getDateFromFile(file, this)));
            }
        }
        Collections.sort(timestampedFiles);
        int first = 0;
        for (TimestampedFile file : timestampedFiles) {
            if (file.time > this.startTime) continue;
            ++first;
        }
        if (first > 0) {
            --first;
        }
        List timestampedFileList = timestampedFiles.subList(first, timestampedFiles.size());
        return timestampedFileList.toArray(new TimestampedFile[0]);
    }

    @Override
    public boolean accept(File directory, String name) {
        if (!name.startsWith(this.fileNamePrefix)) {
            return false;
        }
        String rest = name.substring(this.fileNamePrefix.length());
        if (!rest.endsWith(this.fullSuffix)) {
            return false;
        }
        if (!TIMESTAMP_PATTERN.matcher(rest = rest.substring(0, rest.length() - this.fullSuffix.length())).matches()) {
            return false;
        }
        try {
            Date time = TimeFormat.DEFAULT.parse(rest);
            if (time.getTime() <= this.prevTime || time.getTime() >= this.stopTime) {
                return false;
            }
        }
        catch (InvalidFormatException e) {
            return false;
        }
        if (this.requireTimeFile) {
            File timeFile = new File(directory, FileUtils.getTimeFilePath(name, FileUtils.retrieveExtension(name.substring(0, name.length() - this.containerExtension.length())), this.containerExtension));
            return timeFile.exists();
        }
        return true;
    }

    public void filterByStartTime(long startTime) {
        this.startTime = startTime;
        this.prevTime = Long.MIN_VALUE;
    }

    public void filterByStartAndPreviousFileTime(long startTime, long prevTime) {
        this.startTime = startTime;
        this.prevTime = prevTime;
    }

    public void filterByPreviousFileTime(long prevTime) {
        this.prevTime = prevTime;
        this.startTime = Long.MIN_VALUE;
    }

    public void filterByStopTime(long stopTime) {
        this.stopTime = stopTime;
    }

    public void requireTimeFile() {
        this.requireTimeFile = true;
    }
}

