/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp.text;

import com.devexperts.io.BufferedInput;
import com.devexperts.qd.qtp.text.CorruptedTextFormatException;
import com.devexperts.qd.qtp.text.StringDecoder;
import com.devexperts.qd.qtp.text.TextDelimiters;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class LineTokenizer {
    private TextDelimiters delimiters;
    private final StringDecoder sharedBuf = new StringDecoder();
    private ArrayList<String> tokens;
    private int nextIndex;
    private BufferedInput in;
    private byte cur;
    private boolean lineEnd;

    LineTokenizer() {
        this.setDelimiters(TextDelimiters.TAB_SEPARATED);
        this.tokens = new ArrayList();
        this.nextIndex = 0;
    }

    public void setDelimiters(TextDelimiters delimiters) {
        if (delimiters == null) {
            throw new NullPointerException();
        }
        this.delimiters = delimiters;
    }

    public TextDelimiters getDelimiters() {
        return this.delimiters;
    }

    public List<String> getTokens() {
        return this.tokens;
    }

    public int getNextIndex() {
        return this.nextIndex;
    }

    public String nextToken() {
        return this.nextIndex < this.tokens.size() ? this.tokens.get(this.nextIndex++) : null;
    }

    public boolean hasMoreTokens() {
        return this.nextIndex < this.tokens.size();
    }

    public boolean reset(BufferedInput in) throws CorruptedTextFormatException, IOException {
        this.tokens.clear();
        this.nextIndex = 0;
        this.lineEnd = false;
        this.in = in;
        if (!in.hasAvailable()) {
            return false;
        }
        in.mark();
        this.cur = in.readByte();
        while (this.parseToken()) {
        }
        if (this.lineEnd) {
            return true;
        }
        in.reset();
        in.unmark();
        this.tokens.clear();
        return false;
    }

    private boolean parseToken() throws CorruptedTextFormatException, IOException {
        if (!this.skipSpaces()) {
            return false;
        }
        if (this.cur == 34) {
            if (!this.nextCharacter()) {
                return false;
            }
            if (!this.readToken(true)) {
                return false;
            }
            if (!this.nextCharacter()) {
                return false;
            }
        } else if (!this.readToken(false)) {
            return false;
        }
        if (this.delimiters == TextDelimiters.COMMA_SEPARATED) {
            if (!this.skipSpaces()) {
                return false;
            }
            if (this.cur != 44) {
                throw new CorruptedTextFormatException("Missing comma after token");
            }
            if (!this.nextCharacter()) {
                return false;
            }
        }
        return true;
    }

    private boolean skipSpaces() throws IOException {
        do {
            if (this.isEndOfLineChar(this.cur)) {
                this.lineEnd = true;
                return false;
            }
            if (this.isSpaceChar(this.cur)) continue;
            return true;
        } while (this.nextCharacter());
        return false;
    }

    private boolean readToken(boolean endByQuote) throws IOException {
        long tokenStart = this.in.totalPosition();
        byte prev = 0;
        while (!(endByQuote ? this.isQuoteChar(this.cur) : this.isTokenEndChar(this.cur)) || prev == 92) {
            prev = this.cur;
            if (!this.nextCharacter()) {
                return false;
            }
            if (!this.isEndOfLineChar(this.cur)) continue;
            if (endByQuote) {
                throw new CorruptedTextFormatException("End of line inside quoted token");
            }
            this.lineEnd = true;
            this.addToken(tokenStart);
            return false;
        }
        this.addToken(tokenStart);
        return true;
    }

    private void addToken(long tokenStart) throws CorruptedTextFormatException, IOException {
        int length = (int)(this.in.totalPosition() - tokenStart);
        this.in.rewind((long)(length + 1));
        this.tokens.add(this.sharedBuf.decode(this.in, length));
        this.nextCharacter();
    }

    private boolean isEndOfLineChar(byte c) {
        return c == 13 || c == 10;
    }

    private boolean isSpaceChar(byte c) {
        return c == 32 || c == 9;
    }

    private boolean isQuoteChar(byte c) {
        return c == 34;
    }

    private boolean isTokenEndChar(byte c) {
        return c == 32 || c == 9 || c == 44 && this.delimiters == TextDelimiters.COMMA_SEPARATED;
    }

    private boolean nextCharacter() throws IOException {
        int read = this.in.read();
        if (read < 0) {
            return false;
        }
        this.cur = (byte)read;
        return true;
    }
}

