/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp.text;

import com.devexperts.qd.qtp.text.CorruptedTextFormatException;

public class TextCoding {
    private static final int MIN_GOOD_SYMBOL = 32;
    private static final int MAX_GOOD_SYMBOL = 126;
    private static final char[] HEX = "0123456789ABCDEF".toCharArray();

    public static String encode(String s) {
        if (s == null) {
            return "\\NULL";
        }
        if (s.equals("\u0000")) {
            return "\\0";
        }
        StringBuilder sb = null;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c < ' ' || c > '~' || c == '\\' || c == '\"') {
                if (sb == null) {
                    sb = new StringBuilder((s.length() << 1) - i);
                    sb.append(s, 0, i);
                }
                TextCoding.escapeChar(c, sb);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        return sb == null ? s : sb.toString();
    }

    private static void escapeChar(char c, StringBuilder sb) {
        switch (c) {
            case '\u0000': {
                sb.append("\\0");
                break;
            }
            case '\t': {
                sb.append("\\t");
                break;
            }
            case '\n': {
                sb.append("\\n");
                break;
            }
            case '\r': {
                sb.append("\\r");
                break;
            }
            case '\f': {
                sb.append("\\f");
                break;
            }
            case '\\': {
                sb.append("\\\\");
                break;
            }
            case '\"': {
                sb.append("\\\"");
                break;
            }
            default: {
                sb.append("\\u");
                sb.append(HEX[c >> 12]).append(HEX[c >> 8 & 0xF]).append(HEX[c >> 4 & 0xF]).append(HEX[c & 0xF]);
            }
        }
    }

    static void checkCharRange(byte c) {
        if (c < 32 || c > 126) {
            throw new CorruptedTextFormatException("Invalid character");
        }
    }
}

