/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp.file;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.qtp.AbstractQTPComposer;
import com.devexperts.qd.qtp.AbstractQTPParser;
import com.devexperts.qd.qtp.BinaryQTPComposer;
import com.devexperts.qd.qtp.MessageType;
import com.devexperts.qd.qtp.blob.BlobQTPComposer;
import com.devexperts.qd.qtp.blob.BlobQTPParser;
import com.devexperts.qd.qtp.file.BinaryFileQTPParser;
import com.devexperts.qd.qtp.file.TimestampsType;
import com.devexperts.qd.qtp.text.TextDelimiters;
import com.devexperts.qd.qtp.text.TextQTPComposer;
import com.devexperts.qd.qtp.text.TextQTPParser;
import com.devexperts.util.InvalidFormatException;
import java.util.Locale;

public class FileFormat {
    public static final FileFormat BINARY = new FileFormat(Type.BINARY, null, null);
    public static final FileFormat TEXT = new FileFormat(Type.TEXT, null, null);
    public static final FileFormat CSV = new FileFormat(Type.CSV, null, null);
    private final Type type;
    private final String record;
    private final String symbol;

    public static FileFormat valueOf(String desc) {
        Type type;
        if (desc == null) {
            return null;
        }
        String[] ss = desc.split(":");
        try {
            type = Type.valueOf(ss[0].toUpperCase(Locale.US));
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException("Wrong format specification \"" + ss[0] + "\"");
        }
        if (type == Type.BLOB) {
            if (ss.length != 3) {
                throw new InvalidFormatException("Wrong format specification for BLOB. Must be \"blob:<record>:<symbol>\"");
            }
            return new FileFormat(type, ss[1], ss[2]);
        }
        if (ss.length != 1) {
            throw new InvalidFormatException("Wrong format specification for " + (Object)((Object)type) + ". Cannot have additional options");
        }
        return new FileFormat(type, null, null);
    }

    public static FileFormat detectFormat(byte[] buffer) {
        if (FileFormat.isTextFileInBuffer(buffer, TextDelimiters.TAB_SEPARATED)) {
            return TEXT;
        }
        if (FileFormat.isTextFileInBuffer(buffer, TextDelimiters.COMMA_SEPARATED)) {
            return CSV;
        }
        return BINARY;
    }

    private static boolean isTextFileInBuffer(byte[] buffer, TextDelimiters delimiters) {
        int n;
        String s = delimiters.messageTypePrefix;
        if (s == null) {
            s = delimiters.describePrefix;
        }
        if (buffer.length < (n = s.length())) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (buffer[i] == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private FileFormat(Type type, String record, String symbol) {
        this.type = type;
        this.record = record;
        this.symbol = symbol;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isBareBones() {
        return this.type == Type.CSV || this.type == Type.BLOB;
    }

    private DataRecord getRecord(DataScheme scheme) {
        return scheme.findRecordByName(this.record);
    }

    public AbstractQTPParser createQTPParser(DataScheme scheme) {
        switch (this.type) {
            case BINARY: {
                return new BinaryFileQTPParser(scheme);
            }
            case TEXT: {
                return new TextQTPParser(scheme, null);
            }
            case CSV: {
                TextQTPParser parser = new TextQTPParser(scheme, MessageType.STREAM_DATA);
                parser.setDelimiters(TextDelimiters.COMMA_SEPARATED);
                return parser;
            }
            case BLOB: {
                return new BlobQTPParser(this.getRecord(scheme), this.symbol);
            }
        }
        throw new AssertionError();
    }

    public AbstractQTPComposer createQTPComposer(DataScheme scheme) {
        switch (this.type) {
            case BINARY: {
                BinaryQTPComposer composer = new BinaryQTPComposer(scheme, true);
                composer.setWriteHeartbeat(true);
                return composer;
            }
            case TEXT: {
                TextQTPComposer composer = new TextQTPComposer(scheme);
                composer.setWriteEventTimeSequence(true);
                return composer;
            }
            case CSV: {
                TextQTPComposer textComposer = new TextQTPComposer(scheme);
                textComposer.setWriteEventTimeSequence(true);
                textComposer.setDelimiters(TextDelimiters.COMMA_SEPARATED);
                return textComposer;
            }
            case BLOB: {
                return new BlobQTPComposer(this.getRecord(scheme), this.symbol);
            }
        }
        throw new AssertionError();
    }

    public TimestampsType getTimestampsType() {
        switch (this.type) {
            case BINARY: {
                return TimestampsType.MESSAGE;
            }
            case TEXT: 
            case CSV: {
                return TimestampsType.FIELD;
            }
            case BLOB: {
                return TimestampsType.NONE;
            }
        }
        throw new AssertionError();
    }

    public String getContentType() {
        switch (this.type) {
            case BINARY: {
                return "application/x.qds.binary";
            }
            case TEXT: {
                return "text/plain; charset=UTF-8";
            }
            case CSV: {
                return "text/csv; charset=UTF-8";
            }
            case BLOB: {
                return "application/x.qds.blob";
            }
        }
        throw new AssertionError();
    }

    public String toString() {
        return this.symbol == null ? this.type.toString() : (Object)((Object)this.type) + ":" + this.record + ":" + this.symbol;
    }

    public static enum Type {
        BINARY,
        TEXT,
        CSV,
        BLOB;

    }
}

