/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix.management.impl;

import com.devexperts.management.Management;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.impl.matrix.Collector;
import com.devexperts.qd.impl.matrix.management.impl.CollectorMXBean;
import com.devexperts.qd.impl.matrix.management.impl.CollectorManagementImplBase;
import com.devexperts.qd.impl.matrix.management.impl.CollectorManagementImplOneContract;
import com.devexperts.util.JMXNameBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class CollectorManagementImplAnyContract
extends CollectorManagementImplBase {
    private static final Map<DataScheme, String> SCHEMES = new HashMap<DataScheme, String>();
    private static final Set<String> SCHEME_NAMES = new HashSet<String>();
    private static final Map<String, CollectorManagementImplAnyContract> INSTANCES = new HashMap<String, CollectorManagementImplAnyContract>();
    private static final String[] NAME_SUFFIXES = new String[]{"DataScheme", "Scheme", "Schema"};
    private final List<CollectorManagementImplOneContract> impls = new CopyOnWriteArrayList<CollectorManagementImplOneContract>();
    Management.Registration registration;

    public static synchronized CollectorManagementImplAnyContract getInstance(DataScheme scheme) {
        String name = CollectorManagementImplAnyContract.getBeanName(scheme);
        CollectorManagementImplAnyContract management = INSTANCES.get(name);
        if (management != null) {
            return management;
        }
        management = new CollectorManagementImplAnyContract(scheme, name);
        INSTANCES.put(name, management);
        return management;
    }

    public static String getBeanName(DataScheme scheme) {
        JMXNameBuilder builder = new JMXNameBuilder("com.devexperts.qd.impl.matrix");
        builder.append("scheme", CollectorManagementImplAnyContract.getSchemeName(scheme));
        builder.append("c", "Any");
        return builder.toString();
    }

    public static synchronized String getSchemeName(DataScheme scheme) {
        String name = SCHEMES.get(scheme);
        if (name != null) {
            return name;
        }
        name = scheme.getClass().getSimpleName();
        for (String suffix : NAME_SUFFIXES) {
            if (name.length() <= suffix.length() || !name.endsWith(suffix)) continue;
            name = name.substring(0, name.length() - suffix.length());
            break;
        }
        String unique = name;
        int i = 0;
        while (SCHEME_NAMES.contains(unique)) {
            unique = name + "-" + i;
            ++i;
        }
        SCHEMES.put(scheme, unique);
        SCHEME_NAMES.add(unique);
        return unique;
    }

    public CollectorManagementImplAnyContract(DataScheme scheme, String name) {
        super(scheme, null, "", name);
    }

    public synchronized void addImpl(CollectorManagementImplOneContract o) {
        this.impls.add(o);
        if (this.registration == null) {
            this.registration = Management.registerMBean((Object)this, CollectorMXBean.class, (String)CollectorManagementImplAnyContract.getBeanName(this.scheme));
        }
    }

    public synchronized void removeImpl(CollectorManagementImplOneContract o) {
        this.impls.remove(o);
        if (this.impls.isEmpty() && this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
    }

    @Override
    public QDContract getContract() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resetToDefaults() {
        for (CollectorManagementImplOneContract impl : this.impls) {
            impl.resetToDefaults();
        }
    }

    @Override
    public int getSubscriptionBucket() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSubscriptionBucket(int bucket) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getDistributionBucket() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDistributionBucket(int bucket) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInterleave() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInterleave(int interleave) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getAgentBufferSizeDefault() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAgentBufferSizeDefault(int size) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxDistributionSpins() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMaxDistributionSpins(int spins) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getBufferOverflowLogInterval() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBufferOverflowLogInterval(String bufferOverflowLogInterval) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getLockWaitLogInterval() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLockWaitLogInterval(String lockWaitLogIntervalSecs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getUseLockPriority() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setUseLockPriority(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getUseLockCounters() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setUseLockCounters(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected List<Collector> getCollectors() {
        ArrayList<Collector> result = new ArrayList<Collector>();
        for (CollectorManagementImplOneContract impl : this.impls) {
            result.addAll(impl.getCollectors());
        }
        return result;
    }

    @Override
    public String getFatalError() {
        StringBuilder sb = new StringBuilder();
        for (CollectorManagementImplOneContract impl : this.impls) {
            String s = impl.getFatalError();
            if (s.length() <= 0) continue;
            if (sb.length() > 0) {
                sb.append("\r\n\r\n");
            }
            sb.append(s);
        }
        return sb.toString();
    }
}

