/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix.management.impl;

import com.devexperts.logging.Logging;
import com.devexperts.management.Management;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.impl.matrix.Collector;
import com.devexperts.qd.impl.matrix.management.CollectorCounters;
import com.devexperts.qd.impl.matrix.management.CollectorManagement;
import com.devexperts.qd.impl.matrix.management.dump.DebugDumpExclude;
import com.devexperts.qd.impl.matrix.management.impl.CollectorCountersImpl;
import com.devexperts.qd.impl.matrix.management.impl.CollectorMXBean;
import com.devexperts.qd.impl.matrix.management.impl.CollectorManagementImplAnyContract;
import com.devexperts.qd.impl.matrix.management.impl.CollectorManagementImplBase;
import com.devexperts.qd.impl.matrix.management.impl.FatalError;
import com.devexperts.qd.util.QDConfig;
import com.devexperts.util.JMXNameBuilder;
import com.devexperts.util.TimePeriod;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CollectorManagementImplOneContract
extends CollectorManagementImplBase {
    public static final String DEFAULT_USE_LOCK_COUNTERS = ".*";
    private static final Logging log = Logging.getLogging(CollectorManagement.class);
    private static final Map<String, CollectorManagementImplOneContract> INSTANCES = new HashMap<String, CollectorManagementImplOneContract>();
    @DebugDumpExclude
    private final List<WeakReference<Collector>> collectors = new LinkedList<WeakReference<Collector>>();
    @DebugDumpExclude
    private Management.Registration registration;
    private FatalError fatalError;

    public static synchronized CollectorManagementImplOneContract getInstance(DataScheme scheme, QDContract contract, String keyProperties) {
        String name = CollectorManagementImplOneContract.getBeanName(scheme, contract, keyProperties);
        CollectorManagementImplOneContract management = INSTANCES.get(name);
        if (management != null) {
            return management;
        }
        management = new CollectorManagementImplOneContract(scheme, contract, keyProperties, name);
        INSTANCES.put(name, management);
        return management;
    }

    public static String getBeanName(DataScheme scheme, QDContract contract, String keyProperties) {
        JMXNameBuilder builder = new JMXNameBuilder("com.devexperts.qd.impl.matrix");
        builder.appendKeyProperties(keyProperties);
        builder.append("scheme", CollectorManagementImplAnyContract.getSchemeName(scheme));
        builder.append("c", contract.toString());
        return builder.toString();
    }

    private CollectorManagementImplOneContract(DataScheme scheme, QDContract contract, String keyProperties, String name) {
        super(scheme, contract, keyProperties, name);
        this.useLockCounters = new CollectorManagement.OperationSet(DEFAULT_USE_LOCK_COUNTERS);
        this.resetConfiguredDefaults();
    }

    @Override
    public void resetToDefaults() {
        log.info("Resetting to defaults");
        this.resetBuiltInDefaults();
        this.resetConfiguredDefaults();
    }

    private void resetConfiguredDefaults() {
        QDConfig.setDefaultProperties((Object)this, CollectorMXBean.class, (String)"com.devexperts.qd.impl.matrix.Collector");
        QDConfig.setDefaultProperties((Object)this, CollectorMXBean.class, (String)("com.devexperts.qd.impl.matrix." + this.contract));
    }

    private void resetBuiltInDefaults() {
        Class<?> clazz = this.getClass();
        for (QDConfig.Property prop : QDConfig.getProperties(CollectorMXBean.class)) {
            try {
                Object value = clazz.getField(this.getConstantName(prop)).get(null);
                prop.getSetterMethod().invoke((Object)this, value);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to reset property '" + prop.getName() + "' to builtin default", e);
            }
        }
    }

    private String getConstantName(QDConfig.Property prop) {
        String suffix = prop.getSuffix();
        StringBuilder sb = new StringBuilder("DEFAULT");
        for (int i = 0; i < suffix.length(); ++i) {
            char c = suffix.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                sb.append('_');
            }
            sb.append(Character.toUpperCase(c));
        }
        return sb.toString();
    }

    @Override
    public void setSubscriptionBucket(int subscriptionBucket) {
        if (subscriptionBucket < 1) {
            throw new IllegalArgumentException("subscriptionBucket=" + subscriptionBucket);
        }
        if (subscriptionBucket != this.subscriptionBucket) {
            CollectorManagementImplOneContract.logSet("subscriptionBucket", subscriptionBucket);
            this.subscriptionBucket = subscriptionBucket;
        }
    }

    @Override
    public void setDistributionBucket(int distributionBucket) {
        if (distributionBucket < 1) {
            throw new IllegalArgumentException("distributionBucket=" + distributionBucket);
        }
        if (distributionBucket != this.distributionBucket) {
            CollectorManagementImplOneContract.logSet("distributionBucket", distributionBucket);
            this.distributionBucket = distributionBucket;
        }
    }

    @Override
    public void setInterleave(int interleave) {
        if (interleave != this.interleave) {
            CollectorManagementImplOneContract.logSet("interleave", interleave);
            this.interleave = interleave;
        }
    }

    @Override
    public void setAgentBufferSizeDefault(int agentBufferSizeDefault) {
        if (agentBufferSizeDefault < 1) {
            throw new IllegalArgumentException("agentBufferSizeDefault=" + agentBufferSizeDefault);
        }
        if (agentBufferSizeDefault != this.agentBufferSizeDefault) {
            CollectorManagementImplOneContract.logSet("agentBufferSizeDefault", agentBufferSizeDefault);
            this.agentBufferSizeDefault = agentBufferSizeDefault;
        }
    }

    @Override
    public String getUseLockPriority() {
        return this.useLockPriority.toString();
    }

    @Override
    public void setUseLockPriority(String string) {
        if (!string.equals(this.useLockPriority.toString())) {
            CollectorManagementImplOneContract.logSet("useLockPriority", string);
            this.useLockPriority = new CollectorManagement.OperationSet(string);
        }
    }

    @Override
    public String getUseLockCounters() {
        return this.useLockCounters.toString();
    }

    @Override
    public void setUseLockCounters(String string) {
        if (!string.equals(this.useLockCounters.toString())) {
            CollectorManagementImplOneContract.logSet("useLockCounters", string);
            this.useLockCounters = new CollectorManagement.OperationSet(string);
        }
    }

    @Override
    public void setMaxDistributionSpins(int maxDistributionSpins) {
        if (maxDistributionSpins < 1) {
            throw new IllegalArgumentException("maxDistributionSpins=" + maxDistributionSpins);
        }
        if (maxDistributionSpins != this.maxDistributionSpins) {
            CollectorManagementImplOneContract.logSet("maxDistributionSpins", maxDistributionSpins);
            this.maxDistributionSpins = maxDistributionSpins;
        }
    }

    @Override
    public String getBufferOverflowLogInterval() {
        return this.bufferOverflowLogInterval.toString();
    }

    @Override
    public void setBufferOverflowLogInterval(String bufferOverflowLogInterval) {
        TimePeriod tp = TimePeriod.valueOf((String)bufferOverflowLogInterval);
        if (tp.getTime() <= 0L) {
            throw new IllegalArgumentException("bufferOverflowLogInterval must be positive");
        }
        if (!tp.equals((Object)this.bufferOverflowLogInterval)) {
            CollectorManagementImplOneContract.logSet("bufferOverflowLogInterval", tp);
            this.bufferOverflowLogInterval = tp;
        }
    }

    @Override
    public String getLockWaitLogInterval() {
        return this.lockWaitLogInterval.toString();
    }

    @Override
    public void setLockWaitLogInterval(String lockWaitLogInterval) {
        TimePeriod tp = TimePeriod.valueOf((String)lockWaitLogInterval);
        if (tp.getTime() <= 0L) {
            throw new IllegalArgumentException("lockWaitLogInterval must be positive");
        }
        if (!tp.equals((Object)this.lockWaitLogInterval)) {
            CollectorManagementImplOneContract.logSet("lockWaitLogInterval", tp);
            this.lockWaitLogInterval = tp;
        }
    }

    @Override
    public synchronized List<Collector> getCollectors() {
        ArrayList<Collector> result = new ArrayList<Collector>(this.collectors.size());
        Iterator<WeakReference<Collector>> it = this.collectors.iterator();
        while (it.hasNext()) {
            Collector c = (Collector)it.next().get();
            if (c == null) {
                it.remove();
                continue;
            }
            result.add(c);
        }
        return result;
    }

    public CollectorCounters createCounters() {
        return new CollectorCountersImpl(this.scheme);
    }

    public synchronized void addCollector(Collector c) {
        this.collectors.add(new WeakReference<Collector>(c));
        this.cleanupCollectors();
        if (this.registration == null) {
            this.registration = Management.registerMBean((Object)this, CollectorMXBean.class, (String)CollectorManagementImplOneContract.getBeanName(this.scheme, this.contract, this.keyProperties));
            CollectorManagementImplAnyContract.getInstance(this.scheme).addImpl(this);
        }
    }

    public synchronized void removeCollector(Collector collector) {
        Iterator<WeakReference<Collector>> it = this.collectors.iterator();
        while (it.hasNext()) {
            WeakReference<Collector> weakReference = it.next();
            if (weakReference.get() != collector) continue;
            it.remove();
        }
        this.cleanupCollectors();
        if (this.collectors.isEmpty() && this.registration != null) {
            CollectorManagementImplAnyContract.getInstance(this.scheme).removeImpl(this);
            this.registration.unregister();
            this.registration = null;
        }
    }

    private void cleanupCollectors() {
        Iterator<WeakReference<Collector>> it = this.collectors.iterator();
        while (it.hasNext()) {
            if (it.next().get() != null) continue;
            it.remove();
        }
    }

    @Override
    public String getFatalError() {
        FatalError fatalError = this.fatalError;
        return fatalError == null ? "" : fatalError.toString();
    }

    public void setFatalError(Throwable error) {
        this.fatalError = new FatalError(error);
    }

    public String toString() {
        return this.contract + " management";
    }

    private static void logSet(String property, Object value) {
        log.info("Setting " + property + "=" + value);
    }
}

