/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.monitoring;

import com.devexperts.logging.Logging;
import com.devexperts.qd.monitoring.JmxConnector;
import com.devexperts.qd.monitoring.JmxHtml;
import com.devexperts.qd.monitoring.JmxRmi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class JMXEndpoint {
    public static final String JMX_HTML_PORT_PROPERTY = "jmx.html.port";
    public static final String JMX_HTML_BIND_PROPERTY = "jmx.html.bind";
    public static final String JMX_HTML_SSL_PROPERTY = "jmx.html.ssl";
    public static final String JMX_HTML_AUTH_PROPERTY = "jmx.html.auth";
    public static final String JMX_RMI_PORT_PROPERTY = "jmx.rmi.port";
    private static final Logging log = Logging.getLogging(JMXEndpoint.class);
    private static final Map<Builder, JMXEndpoint> INSTANCES = new HashMap<Builder, JMXEndpoint>();
    private final Builder builder;
    private final List<JmxConnector> jmxConnectors;
    private int refCounter;

    public static Builder newBuilder() {
        return new Builder();
    }

    public JMXEndpoint(Builder builder, List<JmxConnector> jmxConnectors) {
        this.builder = builder;
        this.jmxConnectors = jmxConnectors;
    }

    void acquire() {
        ++this.refCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Map<Builder, JMXEndpoint> map = INSTANCES;
        synchronized (map) {
            if (--this.refCounter > 0) {
                return;
            }
            INSTANCES.remove(this.builder);
            for (JmxConnector jmxConnector : this.jmxConnectors) {
                log.info("Stopping JMX Connector " + jmxConnector);
                try {
                    jmxConnector.stop();
                }
                catch (Exception e) {
                    log.error("Failed to stop JMX Connector " + jmxConnector, (Throwable)e);
                }
            }
        }
    }

    public static class Builder {
        private static final Set<String> SUPPORTED_PROPERTIES = new LinkedHashSet<String>(Arrays.asList("jmx.html.port", "jmx.html.bind", "jmx.html.ssl", "jmx.html.auth", "jmx.rmi.port"));
        private final Properties props = new Properties();

        Builder() {
        }

        public final Builder withProperty(String key, String value) {
            if (key == null || value == null) {
                throw new NullPointerException();
            }
            if (this.supportsProperty(key)) {
                this.props.setProperty(key, value);
            }
            return this;
        }

        public final Builder withProperties(Properties props) {
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                this.withProperty((String)entry.getKey(), (String)entry.getValue());
            }
            return this;
        }

        public boolean supportsProperty(String key) {
            return SUPPORTED_PROPERTIES.contains(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JMXEndpoint acquire() {
            Map map = INSTANCES;
            synchronized (map) {
                JMXEndpoint endpoint = (JMXEndpoint)INSTANCES.get(this);
                if (endpoint == null) {
                    endpoint = this.build();
                    INSTANCES.put(this, endpoint);
                }
                endpoint.acquire();
                return endpoint;
            }
        }

        private JMXEndpoint build() {
            JmxConnector connector;
            for (String key : SUPPORTED_PROPERTIES) {
                if (!this.props.containsKey(key)) continue;
                String v = this.props.getProperty(key);
                log.info("JMXEndpoint with " + key + "=" + (JMXEndpoint.JMX_HTML_AUTH_PROPERTY.equals(key) ? "****" : v));
            }
            ArrayList<JmxConnector> jmxConnectors = new ArrayList<JmxConnector>();
            if (this.props.containsKey(JMXEndpoint.JMX_HTML_PORT_PROPERTY)) {
                try {
                    connector = JmxHtml.init(this.props);
                    if (connector != null) {
                        jmxConnectors.add(connector);
                    }
                }
                catch (Throwable e) {
                    log.error("Failed to initialize JMX HTML Adaptor", e);
                }
            }
            if (this.props.containsKey(JMXEndpoint.JMX_RMI_PORT_PROPERTY)) {
                try {
                    connector = JmxRmi.init(this.props);
                    if (connector != null) {
                        jmxConnectors.add(connector);
                    }
                }
                catch (Throwable e) {
                    log.error("Failed to initialize JMX RMI Connector", e);
                }
            }
            JMXEndpoint endpoint = new JMXEndpoint(this, jmxConnectors);
            return endpoint;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Builder && this.props.equals(((Builder)o).props);
        }

        public int hashCode() {
            return this.props.hashCode();
        }
    }
}

