/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.stats;

import com.devexperts.logging.Logging;
import com.devexperts.management.Management;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.impl.matrix.management.impl.CollectorCountersImpl;
import com.devexperts.qd.stats.JMXStatsNameBuilder;
import com.devexperts.qd.stats.QDStats;
import com.devexperts.util.IndexedSet;
import com.devexperts.util.QuickSort;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLongArray;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class JMXStats
extends QDStats
implements DynamicMBean,
MBeanRegistration {
    private static final Logging log;
    private static final String LONG_CLASS_NAME;
    private static final String LONG_ARRAY_CLASS_NAME;
    private static final String STRING_CLASS_NAME;
    private static final MBeanAttributeInfo CHILDREN;
    private static final MBeanAttributeInfo PARENT;
    private static final int BASIC_ATTRIBUTE_COUNT = 2;
    private static final String ARRAY_ATTR_SUFFIX = "Array*";
    private static final String TOP_ATTR_SUFFIX = "Top*";
    private static final int TOP_COUNT = 5;
    private static final Map<String, MBeanAttributeInfo> ATTRIBUTE_MAP;
    private static final boolean[] SHOULD_REGISTER;
    private static final MBeanInfo[] MBEAN_INFO;
    private static final Comparator<ObjectName> NAMES_COMPARATOR;
    private JmxInfo jmx;
    private int index;
    private IndexedSet<String, ChildIndex> childIndexerByCollectorType;
    private volatile Map<String, AddedMBeanEntry> addedMBeans;

    private static MBeanAttributeInfo createJXMAttr(String name, String className) {
        return new MBeanAttributeInfo(name, className, name, true, false, false);
    }

    public static RootRegistration createRoot(String name, DataScheme scheme) {
        int i = 0;
        while (true) {
            String s = i == 0 ? name : name + "#" + i;
            JMXStats rootStats = new JMXStats("name=" + s);
            rootStats.initRoot(QDStats.SType.ANY, scheme);
            Management.Registration registration = Management.registerMBean((Object)rootStats, null, (String)JMXStats.getRootStatsObjectName(s));
            if (!registration.hasExisted()) {
                return new RootRegistration(rootStats, registration);
            }
            ++i;
            ++i;
        }
    }

    private static String getRootStatsObjectName(String name) {
        return "com.devexperts.qd.stats:name=" + name + ",type=Any";
    }

    public JMXStats() {
    }

    public JMXStats(String keyProperties) {
        super(keyProperties);
    }

    protected QDStats newInstance(QDStats.SType type, boolean unmanaged) {
        if (unmanaged && (type == QDStats.SType.AGENT || type == QDStats.SType.DISTRIBUTOR)) {
            return new QDStats();
        }
        return new JMXStats();
    }

    protected JMXStats getParent() {
        return (JMXStats)super.getParent();
    }

    protected void initChild(QDStats child, QDStats.SType type, String keyProperties, int ridCount, DataScheme scheme) {
        ChildIndex childIndex;
        super.initChild(child, type, keyProperties, ridCount, scheme);
        if (!(child instanceof JMXStats)) {
            return;
        }
        JMXStats jmxChild = (JMXStats)child;
        String childCollectorType = jmxChild.getCollectorType();
        if (this.childIndexerByCollectorType == null) {
            this.childIndexerByCollectorType = IndexedSet.create(ChildIndex::getCollectorType);
        }
        if ((childIndex = (ChildIndex)this.childIndexerByCollectorType.getByKey((Object)childCollectorType)) == null) {
            childIndex = new ChildIndex(childCollectorType);
            this.childIndexerByCollectorType.add((Object)childIndex);
        }
        jmxChild.index = childIndex.index++;
        if (jmxChild.shouldRegister()) {
            this.registerChildBean(jmxChild);
        }
    }

    private boolean shouldRegister() {
        return SHOULD_REGISTER[this.getType().getFlag()];
    }

    private JmxInfo getJmxInfoFromAncestors() {
        for (JMXStats stats = this; stats != null; stats = stats.getParent()) {
            if (stats.jmx == null) continue;
            return stats.jmx;
        }
        return null;
    }

    private void registerChildBean(JMXStats jmxChild) {
        JmxInfo jmx = this.getJmxInfoFromAncestors();
        if (jmx != null) {
            try {
                jmx.server.registerMBean(jmxChild, jmx.name);
            }
            catch (InstanceAlreadyExistsException e) {
                log.warn("Already registered JMX bean " + e.getMessage());
            }
            catch (Exception e) {
                log.error("Unexpected exception while registering JMX children bean of " + jmx.name, (Throwable)e);
            }
        }
    }

    protected void closeImpl() {
        if (this.jmx != null) {
            this.unregisterMBean();
        } else {
            this.unregisterChildrenRec();
        }
    }

    protected void registerAddedMBeans() {
        if (this.jmx != null && this.addedMBeans != null) {
            for (Map.Entry<String, AddedMBeanEntry> entry : this.addedMBeans.entrySet()) {
                this.registerAddedMBean(entry.getKey(), entry.getValue());
            }
        }
    }

    private void registerAddedMBean(String type, AddedMBeanEntry mbe) {
        if (this.jmx != null && mbe.name == null) {
            String name = this.constructName(this.jmx.name.getDomain(), type, this.jmx.name.getKeyPropertyListString());
            try {
                mbe.name = this.jmx.server.registerMBean(mbe.mbean, new ObjectName(name)).getObjectName();
            }
            catch (Exception e) {
                log.error("Unexpected exception registering JMX bean " + name, (Throwable)e);
            }
        }
    }

    protected void unregisterAddedMBeans() {
        if (this.jmx != null && this.addedMBeans != null) {
            for (Map.Entry<String, AddedMBeanEntry> entry : this.addedMBeans.entrySet()) {
                this.unregisterAddedMBean(entry.getValue());
            }
        }
    }

    private void unregisterAddedMBean(AddedMBeanEntry mbe) {
        if (this.jmx != null && mbe.name != null) {
            try {
                if (this.jmx.server.isRegistered(mbe.name)) {
                    this.jmx.server.unregisterMBean(mbe.name);
                }
                mbe.name = null;
            }
            catch (Exception e) {
                log.error("Unexpected exception unregistering JMX bean " + mbe.name, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMBean(String type, Object mbean) {
        AddedMBeanEntry mbe;
        if (this.addedMBeans == null) {
            JMXStats jMXStats = this;
            synchronized (jMXStats) {
                if (this.addedMBeans == null) {
                    this.addedMBeans = new ConcurrentHashMap<String, AddedMBeanEntry>();
                }
            }
        }
        if ((mbe = this.addedMBeans.get(type)) != null) {
            this.unregisterAddedMBean(mbe);
        }
        mbe = new AddedMBeanEntry(Management.wrapMBean((Object)mbean, null));
        this.registerAddedMBean(type, mbe);
        this.addedMBeans.put(type, mbe);
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException {
        try {
            MBeanAttributeInfo attr = ATTRIBUTE_MAP.get(attribute);
            if (attr == null) {
                throw new AttributeNotFoundException(attribute);
            }
            if (attr == CHILDREN) {
                ArrayList<ObjectName> names = new ArrayList<ObjectName>(this.getChildren().length);
                this.addChildrenNamesRec(names);
                QuickSort.sort(names, NAMES_COMPARATOR);
                return names.toArray(new ObjectName[0]);
            }
            if (attr == PARENT) {
                return this.getParentNameRec();
            }
            String name = attr.getName();
            if (attr.getType().equals(LONG_CLASS_NAME)) {
                return this.getValue(QDStats.SValue.valueOf((String)name), false);
            }
            if (attr.getType().equals(LONG_ARRAY_CLASS_NAME) && name.endsWith(ARRAY_ATTR_SUFFIX)) {
                long[] v = new long[this.getRidCount()];
                this.addValues(QDStats.SValue.valueOf((String)name.substring(0, name.length() - ARRAY_ATTR_SUFFIX.length())), false, v);
                return v;
            }
            if (attr.getType().equals(STRING_CLASS_NAME) && name.endsWith(TOP_ATTR_SUFFIX)) {
                long[] v = new long[this.getRidCount()];
                this.addValues(QDStats.SValue.valueOf((String)name.substring(0, name.length() - TOP_ATTR_SUFFIX.length())), false, v);
                return this.findTop(v);
            }
            throw new AttributeNotFoundException(attribute);
        }
        catch (RuntimeException e) {
            log.error("Unexpected JMX exception", (Throwable)e);
            throw e;
        }
    }

    private void addChildrenNamesRec(List<ObjectName> names) {
        QDStats[] children;
        for (QDStats child : children = this.getChildren()) {
            if (!(child instanceof JMXStats)) continue;
            JMXStats jmxChild = (JMXStats)child;
            if (jmxChild.jmx != null) {
                names.add(jmxChild.jmx.name);
                continue;
            }
            jmxChild.addChildrenNamesRec(names);
        }
    }

    public ObjectName getParentNameRec() {
        for (JMXStats stats = this.getParent(); stats != null; stats = stats.getParent()) {
            if (stats.jmx == null) continue;
            return stats.jmx.name;
        }
        return null;
    }

    private String reportCounters(String format, int topSize) {
        LinkedHashMap<String, AtomicLongArray> counters = new LinkedHashMap<String, AtomicLongArray>();
        for (MBeanAttributeInfo attr : this.getMBeanInfo().getAttributes()) {
            String name = attr.getName();
            if (!attr.getType().equals(STRING_CLASS_NAME) || !name.endsWith(TOP_ATTR_SUFFIX)) continue;
            long[] v = new long[this.getRidCount()];
            this.addValues(QDStats.SValue.valueOf((String)name.substring(0, name.length() - TOP_ATTR_SUFFIX.length())), false, v);
            counters.put(name, new AtomicLongArray(v));
        }
        return CollectorCountersImpl.reportCounters(this.getScheme(), counters, format, topSize);
    }

    private String findTop(long[] v) {
        if (v.length == 0) {
            return "";
        }
        PriorityQueue<IndexedValue> pq = new PriorityQueue<IndexedValue>(v.length);
        for (int i = 0; i < v.length; ++i) {
            pq.add(new IndexedValue(i, v[i]));
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 5 && !pq.isEmpty(); ++i) {
            IndexedValue iv = (IndexedValue)pq.remove();
            if (iv.value == 0L) break;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.getScheme() != null && iv.index < this.getScheme().getRecordCount() ? this.getScheme().getRecord(iv.index).getName() : "[" + iv.index + "]");
            sb.append('=').append(iv.value);
        }
        return sb.toString();
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException {
        throw new AttributeNotFoundException(attribute.getName());
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList al = new AttributeList();
        for (String attribute : attributes) {
            try {
                al.add(new Attribute(attribute, this.getAttribute(attribute)));
            }
            catch (Exception e) {
                log.error("Unexpected JMX exception", (Throwable)e);
            }
        }
        return al;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList al = new AttributeList();
        for (Object attribute : attributes) {
            try {
                Attribute a = (Attribute)attribute;
                al.add(new Attribute(a.getName(), this.getAttribute(a.getName())));
            }
            catch (Exception e) {
                log.error("Unexpected JMX exception", (Throwable)e);
            }
        }
        return al;
    }

    @Override
    public Object invoke(String action, Object[] params, String[] signature) throws ReflectionException {
        if (action.equalsIgnoreCase("reportCounters")) {
            String format = (String)params[0];
            Integer topSize = (Integer)params[1];
            int top = topSize == null ? 5 : topSize;
            return this.reportCounters(format, top);
        }
        throw new ReflectionException(new NoSuchMethodException(action));
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return MBEAN_INFO[this.getType().getFlag()];
    }

    protected ObjectName constructName(String domain, String keyProperties) throws MalformedObjectNameException {
        return new ObjectName(this.constructName(domain, this.getType().getName() + "Stats", keyProperties));
    }

    protected String constructName(String domain, String type, String keyProperties) {
        QDStats parent;
        JMXStatsNameBuilder nb = new JMXStatsNameBuilder(domain);
        nb.appendKeyProperties(this.getFullKeyProperties());
        JMXStats child = this;
        while ((parent = child.getParent()) != null) {
            if (child.isSum()) {
                nb.insertSumModeFlag();
            } else {
                nb.insertId(child.index);
            }
            child = parent;
        }
        nb.append("c", this.getCollectorFromAncestors());
        nb.appendType(type);
        nb.doneId();
        nb.appendKeyProperties(keyProperties);
        return nb.toString();
    }

    private String getCollector() {
        if (this.getType() == QDStats.SType.TICKER) {
            return "Ticker";
        }
        if (this.getType() == QDStats.SType.STREAM) {
            return "Stream";
        }
        if (this.getType() == QDStats.SType.HISTORY) {
            return "History";
        }
        return null;
    }

    private String getCollectorFromAncestors() {
        String collector = this.getCollector();
        for (JMXStats stats = this.getParent(); collector == null && stats != null; stats = stats.getParent()) {
            collector = stats.getCollector();
        }
        return collector == null ? "Any" : collector;
    }

    private String getCollectorType() {
        return this.getCollectorFromAncestors() + "-" + this.getType();
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (this.jmx != null) {
            this.unregisterMBean();
        }
        this.jmx = new JmxInfo(server, name == null ? this.constructName(server.getDefaultDomain(), null) : this.constructName(name.getDomain(), name.getKeyPropertyListString()));
        this.registerChildrenRec();
        this.registerAddedMBeans();
        return this.jmx.name;
    }

    private void registerChildrenRec() {
        QDStats[] children;
        for (QDStats child : children = this.getChildren()) {
            JMXStats jmxChild;
            if (!(child instanceof JMXStats) || (jmxChild = (JMXStats)child).getParent() != this) continue;
            if (jmxChild.shouldRegister()) {
                this.registerChildBean(jmxChild);
                continue;
            }
            jmxChild.registerChildrenRec();
        }
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        if (registrationDone == null || !registrationDone.booleanValue()) {
            this.jmx = null;
        }
    }

    @Override
    public void preDeregister() {
        this.unregisterAddedMBeans();
        this.unregisterChildrenRec();
    }

    private void unregisterChildrenRec() {
        QDStats[] children;
        for (QDStats child : children = this.getChildren()) {
            JMXStats jmxChild;
            if (!(child instanceof JMXStats) || (jmxChild = (JMXStats)child).getParent() != this) continue;
            if (jmxChild.jmx != null) {
                jmxChild.unregisterMBean();
                continue;
            }
            jmxChild.unregisterChildrenRec();
        }
    }

    @Override
    public void postDeregister() {
        this.jmx = null;
    }

    private void unregisterMBean() {
        try {
            this.jmx.server.unregisterMBean(this.jmx.name);
        }
        catch (Exception e) {
            log.error("Unexpected exception while unregistering JMX bean " + this.jmx.name, (Throwable)e);
        }
    }

    public String toString() {
        return this.jmx == null ? super.toString() : this.jmx.name.toString();
    }

    static {
        Object value;
        int i;
        log = Logging.getLogging(JMXStats.class);
        LONG_CLASS_NAME = Long.TYPE.getName();
        LONG_ARRAY_CLASS_NAME = long[].class.getName();
        STRING_CLASS_NAME = String.class.getName();
        CHILDREN = JMXStats.createJXMAttr("+Children", ObjectName[].class.getName());
        PARENT = JMXStats.createJXMAttr("+Parent", ObjectName.class.getName());
        ATTRIBUTE_MAP = new HashMap<String, MBeanAttributeInfo>();
        SHOULD_REGISTER = new boolean[32];
        MBEAN_INFO = new MBeanInfo[32];
        NAMES_COMPARATOR = Comparator.comparing(ObjectName::getDomain).thenComparing(ObjectName::getKeyPropertyListString);
        ArrayList[] al = new ArrayList[32];
        for (int f = 0; f < 32; ++f) {
            al[f] = new ArrayList();
            al[f].add(CHILDREN);
            al[f].add(PARENT);
        }
        for (i = 0; i < QDStats.SValue.getValueCount(); ++i) {
            value = QDStats.SValue.getValue((int)i);
            MBeanAttributeInfo attr = JMXStats.createJXMAttr(value.getName(), LONG_CLASS_NAME);
            for (int f = 0; f < 32; ++f) {
                if (!value.supportsFlag(f)) continue;
                al[f].add(attr);
            }
        }
        for (i = 0; i < QDStats.SValue.getValueCount(); ++i) {
            value = QDStats.SValue.getValue((int)i);
            if (!value.isRid()) continue;
            MBeanAttributeInfo arrayAttr = JMXStats.createJXMAttr(value.getName() + ARRAY_ATTR_SUFFIX, LONG_ARRAY_CLASS_NAME);
            MBeanAttributeInfo topAttr = JMXStats.createJXMAttr(value.getName() + TOP_ATTR_SUFFIX, STRING_CLASS_NAME);
            for (int f = 0; f < 32; ++f) {
                if ((f & 4) == 0 || !value.supportsFlag(f)) continue;
                al[f].add(arrayAttr);
                al[f].add(topAttr);
            }
        }
        ArrayList allAttributes = al[31];
        for (MBeanAttributeInfo attr : allAttributes) {
            ATTRIBUTE_MAP.put(attr.getName(), attr);
        }
        for (int f = 0; f < 32; ++f) {
            JMXStats.SHOULD_REGISTER[f] = al[f].size() > 2;
            JMXStats.MBEAN_INFO[f] = new MBeanInfo(JMXStats.class.getName(), "JMXStats", al[f].toArray(new MBeanAttributeInfo[0]), null, new MBeanOperationInfo[]{new MBeanOperationInfo("reportCounters", "Reports performance counters", new MBeanParameterInfo[]{new MBeanParameterInfo("format", "java.lang.String", "html (default) or csv"), new MBeanParameterInfo("topSize", "java.lang.Integer", "max size of TOP tables, 5 by default")}, "java.lang.String", 0)}, null);
        }
    }

    private static class ChildIndex {
        final String collectorType;
        int index;

        ChildIndex(String collectorType) {
            this.collectorType = collectorType;
        }

        String getCollectorType() {
            return this.collectorType;
        }
    }

    private static class JmxInfo {
        final MBeanServer server;
        final ObjectName name;

        JmxInfo(MBeanServer server, ObjectName name) {
            this.server = server;
            this.name = name;
        }
    }

    private static class IndexedValue
    implements Comparable<IndexedValue> {
        final int index;
        final long value;

        IndexedValue(int index, long value) {
            this.index = index;
            this.value = value;
        }

        @Override
        public int compareTo(IndexedValue o) {
            return Long.compare(o.value, this.value);
        }
    }

    private static class AddedMBeanEntry {
        final DynamicMBean mbean;
        ObjectName name;

        AddedMBeanEntry(DynamicMBean mbean) {
            this.mbean = mbean;
        }
    }

    public static class RootRegistration {
        private final QDStats rootStats;
        private final Management.Registration registration;

        public RootRegistration(QDStats rootStats, Management.Registration registration) {
            this.rootStats = rootStats;
            this.registration = registration;
        }

        public QDStats getRootStats() {
            return this.rootStats;
        }

        public void unregister() {
            this.registration.unregister();
        }
    }
}

