/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.monitoring;

import com.devexperts.logging.Logging;
import com.devexperts.management.Management;
import com.devexperts.qd.monitoring.JmxConnector;
import com.devexperts.qd.monitoring.JmxConnectors;
import com.devexperts.util.SystemProperties;
import com.devexperts.util.TimePeriod;
import com.sun.jdmk.comm.AuthInfo;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.HtmlAdaptorServer;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Properties;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocketFactory;

class JmxHtml {
    private static final Logging log = Logging.getLogging(JmxHtml.class);
    static final long BIND_RETRY_DELAY = TimePeriod.valueOf((String)SystemProperties.getProperty(JmxHtml.class, (String)"bindRetryDelay", (String)"10s")).getTime();

    JmxHtml() {
    }

    static JmxConnector init(Properties props) {
        Integer port = Integer.decode(props.getProperty("jmx.html.port"));
        InetAddress bindAddress = JmxHtml.tryResolve(props.getProperty("jmx.html.bind"));
        boolean ssl = props.getProperty("jmx.html.ssl") != null;
        String auth = props.getProperty("jmx.html.auth");
        if (!JmxConnectors.isPortAvailable(port)) {
            return null;
        }
        String name = "com.devexperts.qd.monitoring:type=HtmlAdaptor,port=" + port;
        JmxHtmlAdaptorServer server = new JmxHtmlAdaptorServer(bindAddress, ssl);
        server.setPort(port);
        Connector connector = new Connector(port, name, server);
        if (!JmxConnectors.addConnector(connector)) {
            return null;
        }
        if (auth != null && auth.length() > 0) {
            for (String token : auth.split(",")) {
                String[] info = token.split(":", 2);
                if (info.length != 2) {
                    log.error("jmx.html.auth should contain comma-separated list of <login>:<password> pairs");
                    continue;
                }
                server.addUserAuthenticationInfo(new AuthInfo(info[0], info[1]));
            }
        }
        connector.setRegistration(Management.registerMBean((Object)((Object)server), null, (String)name));
        server.start();
        return connector;
    }

    private static InetAddress tryResolve(String bind) {
        if (bind != null && bind.length() > 0) {
            try {
                return InetAddress.getByName(bind);
            }
            catch (UnknownHostException e) {
                log.error("Could not resolve bind address, will use unbound socket", (Throwable)e);
            }
        }
        return null;
    }

    private static class Connector
    extends JmxConnector {
        private final HtmlAdaptorServer server;

        Connector(int port, String name, HtmlAdaptorServer server) {
            super(port, name);
            this.server = server;
        }

        @Override
        public void stop() throws IOException {
            super.stop();
            this.server.stop();
        }
    }

    static class JmxHtmlAdaptorServer
    extends HtmlAdaptorServer {
        private final InetAddress bindAddress;
        private final boolean ssl;
        private Field serverSocketField;

        JmxHtmlAdaptorServer(InetAddress bindAddress, boolean ssl) {
            this.bindAddress = bindAddress;
            this.ssl = ssl;
            try {
                Field field = HtmlAdaptorServer.class.getDeclaredField("sockListen");
                field.setAccessible(true);
                field.set((Object)this, null);
                this.serverSocketField = field;
            }
            catch (NoSuchFieldException e) {
                log.error("Could not resolve socket field, will use default socket", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error("Could not access socket field, will use default socket", (Throwable)e);
            }
        }

        protected void doBind() throws CommunicationException, InterruptedException {
            while (true) {
                try {
                    this.tryBind();
                    log.info("HTML management port is " + this.getPort() + (this.ssl ? " [SSL]" : "") + (this.bindAddress != null ? " bound to " + this.bindAddress : ""));
                    return;
                }
                catch (CommunicationException e) {
                    log.error("Failed to bind HTML management port", (Throwable)e);
                    if (BIND_RETRY_DELAY == 0L) {
                        return;
                    }
                    Thread.sleep(BIND_RETRY_DELAY);
                    continue;
                }
                break;
            }
        }

        private void tryBind() throws InterruptedException {
            ServerSocket serverSocket;
            if (this.serverSocketField == null) {
                super.doBind();
                return;
            }
            try {
                ServerSocketFactory ssf = this.ssl ? SSLServerSocketFactory.getDefault() : ServerSocketFactory.getDefault();
                serverSocket = ssf.createServerSocket(this.getPort(), 2 * this.getMaxActiveClientCount(), this.bindAddress);
            }
            catch (SocketException e) {
                if (e.getMessage().equals("Interrupted system call")) {
                    throw new InterruptedException(e.toString());
                }
                throw new CommunicationException((Throwable)e);
            }
            catch (InterruptedIOException e) {
                throw new InterruptedException(e.toString());
            }
            catch (IOException e) {
                throw new CommunicationException((Throwable)e);
            }
            try {
                this.serverSocketField.set((Object)this, serverSocket);
            }
            catch (IllegalAccessException e) {
                throw new CommunicationException((Throwable)e, "Unexpected error");
            }
        }

        protected void doError(Exception e) throws CommunicationException {
            log.error("HTML management adaptor initialization error", (Throwable)e);
            super.doError(e);
        }
    }
}

