/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.monitoring;

import com.devexperts.qd.monitoring.DeltaCounter;
import com.devexperts.qd.monitoring.SumDeltaCounter;
import com.devexperts.qd.qtp.MessageConnector;
import com.devexperts.qd.stats.QDStats;

class IOCounter {
    static final int READ_BYTES = 0;
    static final int WRITE_BYTES = 1;
    static final int READ_RTTS = 2;
    static final int WRITE_RTTS = 3;
    static final int SUB_READ_RECORDS = 4;
    static final int SUB_WRITE_RECORDS = 5;
    static final int DATA_READ_RECORDS = 6;
    static final int DATA_WRITE_RECORDS = 7;
    static final int DATA_READ_LAGS = 8;
    static final int DATA_WRITE_LAGS = 9;
    static final int COUNTER_COUNT = 10;
    static final QDStats.SValue[] VALUES = new QDStats.SValue[]{QDStats.SValue.IO_READ_BYTES, QDStats.SValue.IO_WRITE_BYTES, QDStats.SValue.IO_READ_RTTS, QDStats.SValue.IO_WRITE_RTTS, QDStats.SValue.IO_SUB_READ_RECORDS, QDStats.SValue.IO_SUB_WRITE_RECORDS, QDStats.SValue.IO_DATA_READ_RECORDS, QDStats.SValue.IO_DATA_WRITE_RECORDS, QDStats.SValue.IO_DATA_READ_LAGS, QDStats.SValue.IO_DATA_WRITE_LAGS};
    private final MessageConnector connector;
    private final QDStats stats;
    private final DeltaCounter[] counters;
    boolean unused;

    IOCounter(MessageConnector connector, QDStats stats) {
        this.connector = connector;
        this.stats = stats;
        this.counters = new DeltaCounter[10];
        for (int i = 0; i < 10; ++i) {
            this.counters[i] = new DeltaCounter();
        }
    }

    MessageConnector getConnector() {
        return this.connector;
    }

    QDStats getStats() {
        return this.stats;
    }

    void resetUnused() {
        this.unused = true;
    }

    public boolean isUnused() {
        return this.unused;
    }

    void collect() {
        this.unused = false;
        if (this.stats != null) {
            for (int i = 0; i < 10; ++i) {
                this.counters[i].collect(this.stats, VALUES[i]);
            }
        }
    }

    void aggregate(SumDeltaCounter[] sumCounters) {
        for (int i = 0; i < 10; ++i) {
            this.counters[i].aggregate(sumCounters[i]);
        }
    }
}

