/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.monitoring;

import com.devexperts.mars.common.MARSMonitoredBean;
import com.devexperts.mars.common.MARSNode;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.monitoring.IOCounter;
import com.devexperts.qd.monitoring.SumDeltaCounter;
import com.devexperts.qd.monitoring.VNode;
import com.devexperts.qd.qtp.MessageConnector;
import com.devexperts.qd.stats.QDStats;
import com.devexperts.util.LogUtil;
import java.text.NumberFormat;
import java.util.Arrays;

class IOCounters {
    private final String name;
    private final boolean stripeNode;
    private final MARSNode node;
    private final MARSNode address;
    private final MARSNode connections;
    private final MARSNode connectionsClosed;
    private final VNode bytesRead;
    private final VNode bytesWrite;
    private final VNode subRecordsRead;
    private final VNode subRecordsWrite;
    private final VNode dataRecordsRead;
    private final VNode dataRecordsWrite;
    private final VNode dataLagRead;
    private final VNode dataLagWrite;
    private final VNode rtt;
    private MessageConnector registeredConnector;
    private MARSMonitoredBean<?> monitoredConnectorBean;
    private final SumDeltaCounter[] totals;
    String displayName;
    String displayAddress;
    int connectionsCount;
    long oldConnectionsClosedTotal;
    long connectionsClosedTotal;
    long connectionsClosedDelta;
    private DataScheme scheme;
    private boolean isSchemeDiverge;
    private int recordCount;
    private boolean unused;
    private MessageConnector prevConnector;
    private int sameAddressCount;
    private int otherAddressCount;

    IOCounters(String name, MARSNode node) {
        this(name, node, false);
    }

    IOCounters(String name, MARSNode rootNode, boolean stripeNode) {
        this.name = name;
        this.node = name == null ? rootNode : rootNode.subNode(name, "Connector statistics for " + name);
        this.stripeNode = stripeNode;
        this.address = name == null ? null : this.node.subNode("address", "Address");
        this.connections = this.node.subNode("connections", "Number of connections");
        this.connectionsClosed = this.node.subNode("connections_closed", "Number of closed connections per reporting interval");
        this.bytesRead = new VNode(this.node, "bytes_read", "Number of bytes read per second");
        this.bytesWrite = new VNode(this.node, "bytes_write", "Number of bytes written per second");
        this.subRecordsRead = new VNode(this.node, "sub_records_read", "Number of subscription records read per second");
        this.subRecordsWrite = new VNode(this.node, "sub_records_write", "Number of subscription records written per second");
        this.dataRecordsRead = new VNode(this.node, "data_records_read", "Number of data records read per second");
        this.dataRecordsWrite = new VNode(this.node, "data_records_write", "Number of data records written per second");
        this.dataLagRead = new VNode(this.node, "data_lag_read", "Average record-weighted lag of read data records in us");
        this.dataLagWrite = new VNode(this.node, "data_lag_write", "Average record-weighted lag of written data records in us");
        this.rtt = new VNode(this.node, "rtt", "Average record-weighted connection round-trip time in us");
        this.totals = new SumDeltaCounter[10];
        for (int i = 0; i < 10; ++i) {
            this.totals[i] = new SumDeltaCounter(IOCounter.VALUES[i]);
        }
        this.beforeAggregate();
    }

    boolean isStripeNode() {
        return this.stripeNode;
    }

    void beforeAggregate() {
        this.unused = true;
        this.prevConnector = null;
        this.scheme = null;
        this.isSchemeDiverge = false;
        this.recordCount = 0;
        this.clearAddress();
        this.oldConnectionsClosedTotal = this.connectionsClosedTotal;
        this.connectionsCount = 0;
        this.connectionsClosedTotal = 0L;
        Arrays.stream(this.totals).forEach(SumDeltaCounter::clear);
    }

    void aggregate(IOCounter stats) {
        DataScheme statsScheme;
        this.unused = false;
        MessageConnector connector = stats.getConnector();
        if (this.name != null && this.prevConnector == null && !this.stripeNode) {
            if (this.registeredConnector != null && this.registeredConnector != connector) {
                this.unregisterConnector();
            }
            if (this.registeredConnector == null) {
                this.registeredConnector = connector;
                this.monitoredConnectorBean = MARSMonitoredBean.forInstance((MARSNode)this.node, (Object)connector);
            }
        }
        DataScheme dataScheme = statsScheme = connector.getStats() != null ? connector.getStats().getScheme() : null;
        if (!this.isSchemeDiverge && statsScheme != null && statsScheme != this.scheme) {
            if (this.scheme == null) {
                this.scheme = statsScheme;
                this.recordCount = this.scheme.getRecordCount();
            } else {
                this.isSchemeDiverge = true;
                this.recordCount = 0;
            }
            Arrays.stream(this.totals).forEach(d -> d.clearRid(this.recordCount));
        }
        if (this.stripeNode) {
            this.connectionsCount += stats.getStats().getAll(QDStats.SType.CONNECTION).size();
        } else if (connector != this.prevConnector) {
            this.connectionsCount += connector.getConnectionCount();
            this.connectionsClosedTotal += connector.getClosedConnectionCount();
            this.aggregateAddress(connector);
        }
        stats.aggregate(this.totals);
        this.prevConnector = connector;
    }

    boolean afterAggregate() {
        this.calculateNameAndAddress();
        this.connectionsClosedDelta = this.connectionsClosedTotal - this.oldConnectionsClosedTotal;
        if (this.unused) {
            this.unregisterConnector();
        }
        return this.unused;
    }

    private void clearAddress() {
        this.displayAddress = "";
        this.sameAddressCount = 0;
        this.otherAddressCount = 0;
    }

    private void aggregateAddress(MessageConnector connector) {
        String address = LogUtil.hideCredentials((Object)connector.getAddress());
        if (this.displayAddress.isEmpty()) {
            this.displayAddress = address;
            this.sameAddressCount = 1;
        } else if (address.equals(this.displayAddress)) {
            ++this.sameAddressCount;
        } else {
            ++this.otherAddressCount;
        }
    }

    private void calculateNameAndAddress() {
        int totalAddressCount = this.sameAddressCount + this.otherAddressCount;
        String string = this.displayName = totalAddressCount > 1 ? this.name + "*" + totalAddressCount : this.name;
        if (this.sameAddressCount > 1 && this.otherAddressCount > 0) {
            this.displayAddress = this.displayAddress + "*" + this.sameAddressCount;
        }
        if (this.otherAddressCount > 0) {
            this.displayAddress = this.displayAddress + ",<other>";
            if (this.otherAddressCount > 1) {
                this.displayAddress = this.displayAddress + "*" + this.otherAddressCount;
            }
        }
    }

    private void unregisterConnector() {
        if (this.registeredConnector != null) {
            this.registeredConnector = null;
            this.monitoredConnectorBean.close();
            this.monitoredConnectorBean = null;
        }
    }

    void report(NumberFormat format, long elapsedTime, StringBuilder buff) {
        if (this.name != null) {
            this.address.setValue(this.displayAddress);
        }
        this.connections.setIntValue(this.connectionsCount);
        this.connectionsClosed.setValue(String.valueOf(this.connectionsClosedDelta));
        if (this.monitoredConnectorBean != null) {
            this.monitoredConnectorBean.run();
        }
        this.bytesRead.set(IOCounters.rate(this.totals[0].totalDelta, elapsedTime));
        this.bytesWrite.set(IOCounters.rate(this.totals[1].totalDelta, elapsedTime));
        this.subRecordsRead.set(IOCounters.rate(this.totals[4].totalDelta, elapsedTime));
        this.subRecordsWrite.set(IOCounters.rate(this.totals[5].totalDelta, elapsedTime));
        this.dataRecordsRead.set(IOCounters.rate(this.totals[6].totalDelta, elapsedTime));
        this.dataRecordsWrite.set(IOCounters.rate(this.totals[7].totalDelta, elapsedTime));
        this.dataLagRead.set(this.frac(this.totals[8].totalDelta, this.totals[6].totalDelta));
        this.dataLagWrite.set(this.frac(this.totals[9].totalDelta, this.totals[7].totalDelta));
        this.rtt.set(this.frac(this.totals[2].totalDelta + this.totals[3].totalDelta, this.totals[6].totalDelta + this.totals[7].totalDelta + this.totals[4].totalDelta + this.totals[5].totalDelta));
        if (buff == null) {
            return;
        }
        buff.append("Read: ").append(format.format(this.bytesRead.v)).append(" Bps");
        this.optRps(buff, format, this.subRecordsRead.v, this.dataRecordsRead.v, this.dataLagRead.v);
        buff.append("; Write: ").append(format.format(this.bytesWrite.v)).append(" Bps");
        this.optRps(buff, format, this.subRecordsWrite.v, this.dataRecordsWrite.v, this.dataLagWrite.v);
        if (this.rtt.v != 0L) {
            buff.append("; rtt ").append(format.format(this.rtt.v)).append(" us");
        }
        if (this.scheme != null) {
            int topR = this.totals[0].findMaxRecord();
            int topW = this.totals[1].findMaxRecord();
            if (topR >= 0 || topW >= 0) {
                buff.append("; TOP bytes");
                String sep = this.totals[0].formatMax(this.scheme, buff, "read", topR, " ");
                this.totals[1].formatMax(this.scheme, buff, "write", topW, sep);
            }
        }
    }

    private static long rate(long delta, long elapsedTime) {
        return elapsedTime == 0L ? 0L : delta * 1000L / elapsedTime;
    }

    private long frac(long a, long b) {
        return b == 0L ? 0L : a / b;
    }

    private void optRps(StringBuilder sb, NumberFormat integerFormat, long subRps, long dataRps, long dataLag) {
        if (subRps == 0L && dataRps == 0L && dataLag == 0L) {
            return;
        }
        sb.append(" (");
        if (subRps != 0L) {
            sb.append("sub ").append(integerFormat.format(subRps)).append(" rps");
        }
        if (dataRps != 0L || dataLag != 0L) {
            if (subRps != 0L) {
                sb.append(' ');
            }
            sb.append("data ").append(integerFormat.format(dataRps)).append(" rps");
            if (dataLag != 0L) {
                sb.append(" lag ").append(integerFormat.format(dataLag)).append(" us");
            }
        }
        sb.append(")");
    }
}

