/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix.management.dump;

import com.devexperts.io.BufferedInput;
import com.devexperts.io.StreamInput;
import com.devexperts.qd.impl.matrix.Collector;
import com.devexperts.qd.impl.matrix.CollectorDebug;
import com.devexperts.qd.impl.matrix.FatalError;
import com.devexperts.qd.impl.matrix.management.dump.CollectorVisitor;
import com.devexperts.qd.impl.matrix.management.dump.DebugDumpCLI;
import com.devexperts.qd.impl.matrix.management.dump.TrackingInput;
import com.devexperts.util.IndexedSet;
import com.devexperts.util.IndexerFunction;
import com.devexperts.util.UnsafeHolder;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.InflaterInputStream;

public class DebugDumpReader {
    private final IndexedSet<Integer, ObjectReader> classMap = IndexedSet.createInt((IndexerFunction.IntKey & Serializable)reader -> reader.classId);
    private final IndexedSet<Integer, ObjectRef> objectMap = IndexedSet.createInt((IndexerFunction.IntKey & Serializable)ref -> ref.id);

    private DebugDumpReader() {
        this.classMap.put((Object)new ObjectReader(0, null));
        this.classMap.put((Object)new ObjectReader(-1, String.class));
        this.classMap.put((Object)new ObjectReader(-2, boolean[].class));
        this.classMap.put((Object)new ObjectReader(-3, byte[].class));
        this.classMap.put((Object)new ObjectReader(-4, short[].class));
        this.classMap.put((Object)new ObjectReader(-5, char[].class));
        this.classMap.put((Object)new ObjectReader(-6, int[].class));
        this.classMap.put((Object)new ObjectReader(-7, long[].class));
        this.classMap.put((Object)new ObjectReader(-8, float[].class));
        this.classMap.put((Object)new ObjectReader(-9, double[].class));
        this.objectMap.put((Object)new ObjectRef(0));
    }

    private void read(String fileName) {
        System.out.println("Reading " + fileName);
        try (StreamInput in = new StreamInput((InputStream)new InflaterInputStream(new TrackingInput(new RandomAccessFile(fileName, "r"))));){
            while (this.parse(in)) {
            }
        }
        catch (IOException e) {
            System.out.println("Exception while reading " + fileName);
            e.printStackTrace(System.out);
        }
    }

    private void resolve() {
        System.out.println("Resolving " + this.objectMap.size() + " objects from " + this.classMap.size() + " classes");
        this.objectMap.forEach(ObjectRef::resolveEnums);
        this.objectMap.forEach(ObjectRef::resolveFields);
        System.out.println("Snapshot reconstructed");
    }

    private boolean parse(StreamInput in) throws IOException {
        block6: {
            int id;
            try {
                id = in.readCompactInt();
            }
            catch (EOFException e) {
                return false;
            }
            try {
                if (id < 0) {
                    this.readClassDesc(in, id);
                    break block6;
                }
                if (id > 0) {
                    this.readObjectDesc(in, id);
                    break block6;
                }
                throw new IOException("Invalid");
            }
            catch (IOException e) {
                throw new IOException("Failed to parse id=" + id, e);
            }
        }
        return true;
    }

    private void readClassDesc(StreamInput in, int classId) throws IOException {
        Class<?> clazz;
        if (this.classMap.containsKey(classId)) {
            throw new IOException("Repeated classId=" + classId);
        }
        String className = in.readUTFString();
        int parentClassId = in.readCompactInt();
        if (!this.classMap.containsKey(parentClassId)) {
            throw new IOException("Parent class " + parentClassId + " is not found");
        }
        ObjectReader parent = (ObjectReader)this.classMap.getByKey(parentClassId);
        if (className == null) {
            ArrayDesc desc = new ArrayDesc(classId, parent.clazz);
            this.classMap.put((Object)desc);
            return;
        }
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            System.out.println("Cannot find class " + className);
            clazz = null;
        }
        int fieldCount = in.readCompactInt();
        ClassDesc desc = new ClassDesc(classId, parent, clazz, fieldCount);
        this.classMap.put((Object)desc);
        for (int i = 0; i < fieldCount; ++i) {
            String fieldName = in.readUTFString();
            int fieldType = in.readCompactInt();
            Field field = null;
            try {
                field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
            }
            catch (Exception e) {
                System.out.println("Cannot find field " + fieldName + " of " + className);
            }
            desc.fields[i] = new FieldDesc(field, fieldType);
            if (fieldType != 0) continue;
            ++desc.refCount;
        }
    }

    private void readObjectDesc(StreamInput in, int objectId) throws IOException {
        if (this.objectMap.containsKey(objectId)) {
            throw new IOException("Repeated objectId=" + objectId);
        }
        int classId = in.readCompactInt();
        ObjectReader reader = (ObjectReader)this.classMap.getByKey(classId);
        if (reader == null) {
            throw new IOException("Invalid classId=" + classId);
        }
        this.objectMap.put((Object)reader.readObject((BufferedInput)in, objectId));
    }

    public void dumpInfo() {
        Object owner = this.getOwner();
        Object version = this.getInstanceOrNull(2);
        Object systemProperties = this.getInstanceOrNull(3);
        Object exception = this.getInstanceOrNull(4);
        System.out.println("--- Dump information ---");
        System.out.println("Owner = " + owner);
        System.out.println("QDS   = " + version);
        System.out.println("JVM   = " + (systemProperties instanceof Map ? ((Map)systemProperties).get("java.version") : null));
        if (exception instanceof Throwable) {
            System.out.println("Error = " + exception);
            ((Throwable)exception).printStackTrace(System.out);
        }
    }

    public Object getOwner() {
        return this.getInstanceOrNull(1);
    }

    public CollectorDebug.RehashCrashInfo getRehashCrashInfo() {
        CollectorDebug.RehashCrashInfo rci = new CollectorDebug.RehashCrashInfo();
        Object exception = this.getInstanceOrNull(4);
        if (exception instanceof FatalError) {
            String message = ((FatalError)exception).getMessage();
            Matcher matcher = Pattern.compile("^Counter underflow for key=(\\d+),.*").matcher(message);
            if (matcher.matches()) {
                rci.agent = 1;
                rci.key = Integer.parseInt(matcher.group(1));
                System.out.println("Rehash crash detected at key " + rci.key);
            }
        }
        return rci;
    }

    public void visit(Object owner, CollectorVisitor visitor) {
        if (owner instanceof Collection) {
            for (Object o : (Collection)owner) {
                this.visit(o, visitor);
            }
        } else if (owner instanceof Collector) {
            visitor.visit((Collector)owner);
        }
    }

    private Object getInstanceOrNull(int objectId) {
        ObjectRef ref = (ObjectRef)this.objectMap.getByKey(objectId);
        return ref == null ? null : ref.instance;
    }

    private Object getInstanceOrClass(int objectId) {
        if (objectId >= 0) {
            ObjectRef ref = (ObjectRef)this.objectMap.getByKey(objectId);
            if (ref == null) {
                System.out.println("Cannot find object instance #" + objectId);
                return null;
            }
            return ref.instance;
        }
        ObjectReader reader = (ObjectReader)this.classMap.getByKey(objectId);
        if (reader == null) {
            System.out.println("Cannot find class #" + objectId);
            return null;
        }
        return reader.clazz;
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Usage: DebugDumpReader <file> [<command> [<args>]] [+ <command> ...]");
            return;
        }
        DebugDumpReader reader = new DebugDumpReader();
        reader.read(args[0]);
        reader.resolve();
        DebugDumpCLI cli = new DebugDumpCLI(reader);
        if (args.length == 1) {
            cli.interactive();
        } else {
            cli.execute(Arrays.copyOfRange(args, 1, args.length));
        }
    }

    class ClassDesc
    extends ObjectReader {
        final ClassDesc parent;
        final FieldDesc[] fields;
        int refCount;

        ClassDesc(int classId, ObjectReader parent, Class<?> clazz, int fieldCount) {
            super(classId, clazz);
            this.parent = parent instanceof ClassDesc ? (ClassDesc)parent : null;
            this.fields = new FieldDesc[fieldCount];
            this.refCount = this.parent == null ? 0 : this.parent.refCount;
        }

        @Override
        ObjectRef readObject(BufferedInput in, int objectId) throws IOException {
            Object instance;
            if (this.clazz == null || Modifier.isAbstract(this.clazz.getModifiers())) {
                this.skipInstanceFields(in);
                return new ObjectRef(objectId);
            }
            try {
                instance = UnsafeHolder.UNSAFE.allocateInstance(this.clazz);
            }
            catch (InstantiationException e) {
                throw new IOException("Cannot allocate instance " + objectId + " of " + this.clazz.getName(), e);
            }
            InstanceRef result = this.readInstanceFields(in, new InstanceRef(objectId, instance, this));
            return result;
        }

        private InstanceRef readInstanceFields(BufferedInput in, InstanceRef result) throws IOException {
            ClassDesc cur = this;
            Object instance = result.instance;
            int i = 0;
            do {
                block15: for (FieldDesc fd : cur.fields) {
                    try {
                        switch (fd.type) {
                            case 0: {
                                result.refs[i++] = in.readCompactInt();
                                break;
                            }
                            case -2: {
                                boolean booleanValue;
                                boolean bl = booleanValue = in.readByte() != 0;
                                if (fd.field == null) continue block15;
                                fd.field.setBoolean(instance, booleanValue);
                                break;
                            }
                            case -3: {
                                byte byteValue = in.readByte();
                                if (fd.field == null) continue block15;
                                fd.field.setByte(instance, byteValue);
                                break;
                            }
                            case -4: {
                                short shortValue = (short)in.readCompactInt();
                                if (fd.field == null) continue block15;
                                fd.field.setShort(instance, shortValue);
                                break;
                            }
                            case -5: {
                                char charValue = (char)in.readUTFChar();
                                if (fd.field == null) continue block15;
                                fd.field.setChar(instance, charValue);
                                break;
                            }
                            case -6: {
                                int intValue = in.readCompactInt();
                                if (fd.field == null) continue block15;
                                fd.field.setInt(instance, intValue);
                                break;
                            }
                            case -7: {
                                long longValue = in.readCompactLong();
                                if (fd.field == null) continue block15;
                                fd.field.setLong(instance, longValue);
                                break;
                            }
                            case -8: {
                                float floatValue = in.readFloat();
                                if (fd.field == null) continue block15;
                                fd.field.setFloat(instance, floatValue);
                                break;
                            }
                            case -9: {
                                double doubleValue = in.readDouble();
                                if (fd.field == null) continue block15;
                                fd.field.setDouble(instance, doubleValue);
                                break;
                            }
                            default: {
                                throw new IOException("Invalid field type " + fd.type);
                            }
                        }
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        System.out.println("Cannot set field " + fd.field.getName() + " on " + fd.field.getDeclaringClass().getName() + ": " + e);
                    }
                }
            } while ((cur = cur.parent) != null);
            return result;
        }

        private void skipInstanceFields(BufferedInput in) throws IOException {
            ClassDesc cur = this;
            do {
                block12: for (FieldDesc fd : cur.fields) {
                    switch (fd.type) {
                        case 0: {
                            in.readCompactInt();
                            continue block12;
                        }
                        case -2: {
                            in.readByte();
                            continue block12;
                        }
                        case -3: {
                            in.readByte();
                            continue block12;
                        }
                        case -4: {
                            in.readCompactInt();
                            continue block12;
                        }
                        case -5: {
                            in.readUTFChar();
                            continue block12;
                        }
                        case -6: {
                            in.readCompactInt();
                            continue block12;
                        }
                        case -7: {
                            in.readCompactLong();
                            continue block12;
                        }
                        case -8: {
                            in.readFloat();
                            continue block12;
                        }
                        case -9: {
                            in.readDouble();
                            continue block12;
                        }
                        default: {
                            throw new IOException("Invalid field type " + fd.type);
                        }
                    }
                }
            } while ((cur = cur.parent) != null);
        }
    }

    static class FieldDesc {
        final Field field;
        final int type;

        FieldDesc(Field field, int type) {
            this.field = field;
            this.type = type;
        }
    }

    class ArrayDesc
    extends ObjectReader {
        ArrayDesc(int classId, Class<?> parent) {
            super(classId, parent == null ? Object[].class : Array.newInstance(parent, 0).getClass());
        }

        @Override
        ObjectRef readObject(BufferedInput in, int objectId) throws IOException {
            int length = in.readCompactInt();
            ArrayRef result = new ArrayRef(objectId, this.clazz.getComponentType(), length);
            for (int i = 0; i < length; ++i) {
                result.refs[i] = in.readCompactInt();
            }
            return result;
        }
    }

    static class ObjectReader {
        final int classId;
        final Class<?> clazz;

        ObjectReader(int classId, Class<?> clazz) {
            this.classId = classId;
            this.clazz = clazz;
        }

        ObjectRef readObject(BufferedInput in, int objectId) throws IOException {
            if (this.classId == 0) {
                in.readUTFString();
                return new ObjectRef(objectId);
            }
            if (this.classId == -1) {
                return new ObjectRef(objectId, in.readUTFString());
            }
            int length = in.readCompactInt();
            switch (this.classId) {
                case -2: {
                    boolean[] booleanArr = new boolean[length];
                    for (int i = 0; i < length; ++i) {
                        booleanArr[i] = in.readByte() != 0;
                    }
                    return new ObjectRef(objectId, booleanArr);
                }
                case -3: {
                    byte[] byteArr = new byte[length];
                    for (int i = 0; i < length; ++i) {
                        byteArr[i] = in.readByte();
                    }
                    return new ObjectRef(objectId, byteArr);
                }
                case -4: {
                    short[] shortArr = new short[length];
                    for (int i = 0; i < length; ++i) {
                        shortArr[i] = (short)in.readCompactInt();
                    }
                    return new ObjectRef(objectId, shortArr);
                }
                case -5: {
                    char[] charArr = new char[length];
                    for (int i = 0; i < length; ++i) {
                        charArr[i] = (char)in.readUTFChar();
                    }
                    return new ObjectRef(objectId, charArr);
                }
                case -6: {
                    int[] intArr = new int[length];
                    for (int i = 0; i < length; ++i) {
                        intArr[i] = in.readCompactInt();
                    }
                    return new ObjectRef(objectId, intArr);
                }
                case -7: {
                    long[] longArr = new long[length];
                    for (int i = 0; i < length; ++i) {
                        longArr[i] = in.readCompactLong();
                    }
                    return new ObjectRef(objectId, longArr);
                }
                case -8: {
                    float[] floatArr = new float[length];
                    for (int i = 0; i < length; ++i) {
                        floatArr[i] = in.readFloat();
                    }
                    return new ObjectRef(objectId, floatArr);
                }
                case -9: {
                    double[] doubleArr = new double[length];
                    for (int i = 0; i < length; ++i) {
                        doubleArr[i] = in.readFloat();
                    }
                    return new ObjectRef(objectId, doubleArr);
                }
            }
            throw new IllegalArgumentException("classId=" + this.classId);
        }
    }

    class InstanceRef
    extends ObjectRef {
        int[] refs;
        final ClassDesc classDesc;

        InstanceRef(int id, Object instance, ClassDesc classDesc) {
            super(id, instance);
            this.refs = new int[classDesc.refCount];
            this.classDesc = classDesc;
        }

        @Override
        void resolveEnums() {
            if (this.instance instanceof Enum) {
                this.resolveFields();
                this.instance = this.resolveEnum((Enum)this.instance);
            }
        }

        @Override
        void resolveFields() {
            int i = 0;
            ClassDesc cur = this.classDesc;
            do {
                for (FieldDesc fd : cur.fields) {
                    if (fd.type != 0 || fd.field == null) continue;
                    int ref = this.refs[i++];
                    Object value = DebugDumpReader.this.getInstanceOrClass(ref);
                    try {
                        if (!fd.field.getType().isInstance(value)) continue;
                        fd.field.set(this.instance, value);
                    }
                    catch (Exception e) {
                        System.out.println("Cannot set field " + fd.field.getName() + " on object #" + this.id + " " + fd.field.getDeclaringClass().getName() + " to reference #" + ref + " " + value.getClass().getName());
                    }
                }
            } while ((cur = cur.parent) != null);
        }

        private Object resolveEnum(Enum<?> instance) {
            try {
                return Enum.valueOf(instance.getClass(), instance.name());
            }
            catch (IllegalArgumentException e) {
                System.out.println("Cannot resolveFields enum " + instance.getClass().getName() + " with name " + instance.name());
                return instance;
            }
        }
    }

    class ArrayRef
    extends ObjectRef {
        int[] refs;

        ArrayRef(int id, Class<?> componentType, int length) {
            super(id);
            this.instance = Array.newInstance(componentType, length);
            this.refs = new int[length];
        }

        @Override
        void resolveFields() {
            Object[] a = (Object[])this.instance;
            for (int i = 0; i < this.refs.length; ++i) {
                int ref = this.refs[i];
                Object value = DebugDumpReader.this.getInstanceOrClass(ref);
                try {
                    a[i] = value;
                    continue;
                }
                catch (ArrayStoreException e) {
                    System.out.println("Cannot store element " + i + " of array #" + this.id + " " + a.getClass().getComponentType().getName() + "[] to reference #" + ref + " " + value.getClass().getName());
                }
            }
        }
    }

    static class ObjectRef {
        final int id;
        Object instance;

        ObjectRef(int id) {
            this.id = id;
        }

        ObjectRef(int id, Object instance) {
            this.id = id;
            this.instance = instance;
        }

        void resolveEnums() {
        }

        void resolveFields() {
        }
    }
}

