/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix.management.dump;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDAgent;
import com.devexperts.qd.QDHistory;
import com.devexperts.qd.impl.matrix.Collector;
import com.devexperts.qd.impl.matrix.CollectorDebug;
import com.devexperts.qd.impl.matrix.management.dump.CollectorVisitor;
import com.devexperts.qd.impl.matrix.management.dump.DumpUtil;
import com.devexperts.qd.impl.matrix.management.dump.DumpVisitorBase;
import com.devexperts.qd.ng.AbstractRecordSink;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.ng.RecordSink;
import java.io.PrintStream;

class DumpSubscriptionVisitor
extends DumpVisitorBase
implements CollectorVisitor {
    DumpSubscriptionVisitor(PrintStream out, String filterSymbol, String filterRecord) {
        super(out, filterSymbol, filterRecord);
    }

    @Override
    public void visit(Collector collector) {
        collector.visitAgents((CollectorDebug.AgentVisitor)new DumpSubscriptionSink(collector instanceof QDHistory));
    }

    class DumpSubscriptionSink
    extends AbstractRecordSink
    implements CollectorDebug.AgentVisitor {
        private final boolean history;
        private QDAgent agent;

        DumpSubscriptionSink(boolean history) {
            this.history = history;
        }

        public void visitAgent(QDAgent agent) {
            this.agent = agent;
            agent.examineSubscription((RecordSink)this);
        }

        public void append(RecordCursor cursor) {
            String symbol;
            DataRecord record = cursor.getRecord();
            if (!DumpSubscriptionVisitor.this.matches(record, symbol = cursor.getDecodedSymbol())) {
                return;
            }
            if (this.agent != null) {
                DumpSubscriptionVisitor.this.out.print("--- Subscription from ");
                DumpSubscriptionVisitor.this.out.println(this.agent);
                this.agent = null;
            }
            DumpSubscriptionVisitor.this.out.print(record.getName());
            DumpSubscriptionVisitor.this.out.print('\t');
            DumpSubscriptionVisitor.this.out.print(symbol);
            if (this.history) {
                DumpUtil.printTime(DumpSubscriptionVisitor.this.out, record, cursor);
            }
            DumpSubscriptionVisitor.this.out.println();
        }
    }
}

