/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix.management.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

class ReportBuilder {
    static final String CSV = "csv";
    static final String TEXT = "text";
    static final int HEADER_LEVEL_COLLECTOR = 1;
    static final int HEADER_LEVEL_SECTION = 2;
    private boolean html;
    private boolean csv;
    private boolean text;
    private boolean firstLine;
    private final StringWriter string = new StringWriter();
    private final PrintWriter out = new PrintWriter(this.string);
    private int lineCount;
    private List<List<String>> table;

    ReportBuilder(String format) {
        if (format != null && format.equalsIgnoreCase(CSV)) {
            this.csv = true;
        } else if (format != null && format.equalsIgnoreCase(TEXT)) {
            this.text = true;
        } else {
            this.html = true;
        }
        this.firstLine = true;
    }

    int getLineCount() {
        return this.lineCount;
    }

    public String toString() {
        return this.string.toString();
    }

    ReportBuilder header(Object obj, int level) {
        if (this.table != null) {
            throw new IllegalStateException();
        }
        this.newLine();
        if (this.html) {
            int fontSize = level == 1 ? 130 : 110;
            int paddingTop = level == 1 ? 18 : 6;
            this.out.print("<div style='font-weight:bold; font-size:" + fontSize + "%; padding-top: " + paddingTop + "pt'>");
        }
        this.out.print(this.convert(obj));
        if (this.html) {
            this.out.print("</div>");
        }
        return this;
    }

    ReportBuilder message(Object obj) {
        if (this.table != null) {
            throw new IllegalStateException();
        }
        this.newLine();
        this.out.print(this.convert(obj));
        if (this.html) {
            this.out.print("<br>");
        }
        return this;
    }

    ReportBuilder beginTable() {
        if (this.table != null) {
            throw new IllegalStateException();
        }
        this.table = new ArrayList<List<String>>();
        return this;
    }

    ReportBuilder endTable() {
        if (this.table == null) {
            throw new IllegalStateException();
        }
        if (this.html) {
            this.flushHtmlTable();
        } else {
            this.flushTextOrCSVTable();
        }
        this.table = null;
        return this;
    }

    ReportBuilder newRow() {
        this.table.add(new ArrayList());
        return this;
    }

    ReportBuilder endTR() {
        return this;
    }

    ReportBuilder td(Object obj) {
        this.table.get(this.table.size() - 1).add(this.convert(obj));
        return this;
    }

    private void newLine() {
        ++this.lineCount;
        if (this.firstLine) {
            this.firstLine = false;
        } else {
            this.out.println();
        }
    }

    private String convert(Object obj) {
        String s = String.valueOf(obj);
        if (this.html) {
            s = this.quoteHtml(s);
        }
        if (this.csv) {
            s = this.quoteCsv(s);
        }
        return s;
    }

    private String quoteHtml(String s) {
        StringBuilder sb = new StringBuilder();
        block5: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block5;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block5;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        s = sb.toString();
        return s;
    }

    private String quoteCsv(String s) {
        StringBuilder sb = new StringBuilder();
        boolean quote = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\"");
                }
                case ' ': {
                    quote = true;
                }
            }
            sb.append(c);
        }
        if (quote) {
            sb.insert(0, '\"');
            sb.append('\"');
        }
        return sb.toString();
    }

    private void flushTextOrCSVTable() {
        ArrayList<Integer> widths = new ArrayList<Integer>();
        if (this.text) {
            List<String> headerRow = this.table.get(0);
            for (int i = 0; i < headerRow.size(); ++i) {
                headerRow.set(i, "[" + headerRow.get(i) + "]");
            }
            for (List<String> row : this.table) {
                while (widths.size() < row.size()) {
                    widths.add(0);
                }
                for (int j = 0; j < row.size(); ++j) {
                    String td = row.get(j);
                    if (td.length() <= (Integer)widths.get(j)) continue;
                    widths.set(j, td.length());
                }
            }
            if (widths.size() <= 2) {
                this.flushTextTableInline();
                return;
            }
        }
        for (List<String> row : this.table) {
            this.newLine();
            for (int j = 0; j < row.size(); ++j) {
                if (j > 0) {
                    this.out.print(this.text ? " " : ",");
                }
                String td = row.get(j);
                if (this.text) {
                    StringBuilder sb = new StringBuilder(td);
                    while (sb.length() < (Integer)widths.get(j)) {
                        sb.append(' ');
                    }
                    td = sb.toString();
                }
                this.out.print(td);
            }
        }
    }

    private void flushTextTableInline() {
        for (List<String> row : this.table) {
            this.out.print(' ');
            this.out.print(row.get(0));
            if (row.size() <= 1) continue;
            this.out.print('=');
            this.out.print(row.get(1));
        }
    }

    private void flushHtmlTable() {
        this.newLine();
        this.out.print("<table border=1>");
        for (int i = 0; i < this.table.size(); ++i) {
            List<String> row = this.table.get(i);
            this.newLine();
            this.out.print("<tr>");
            for (String td : row) {
                this.out.print(i == 0 ? "<th>" : "<td>");
                this.out.print(td);
                this.out.print(i == 0 ? "</th>" : "</td>");
            }
            this.out.print("</tr>");
        }
        this.out.print("</table>");
    }
}

