/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix.management.dump;

import com.devexperts.io.BufferedOutput;
import com.devexperts.io.StreamOutput;
import com.devexperts.logging.Logging;
import com.devexperts.qd.QDFactory;
import com.devexperts.qd.impl.matrix.management.DebugDump;
import com.devexperts.qd.impl.matrix.management.dump.DebugDumpExclude;
import com.devexperts.qd.impl.matrix.management.impl.Exec;
import com.devexperts.util.LogUtil;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.regex.Pattern;
import java.util.zip.DeflaterOutputStream;

public class DebugDumpImpl
implements DebugDump {
    private static final Logging log = Logging.getLogging(DebugDumpImpl.class);
    private static final Pattern DUMP_CLASS_PATTERN = Pattern.compile("com\\.devexperts\\.qd\\.impl\\..*|com\\.devexperts\\.qd\\.kit\\..*|com\\.devexperts\\.qd\\.ng\\..*|com\\.devexperts\\.qd\\.stats\\..*|com\\.devexperts\\.qd\\.util\\..*|com\\.devexperts\\.qd\\.[^.]*|com\\.devexperts\\.util\\..*|java\\..*");
    private static final Pattern EXCLUDE_CLASS_PATTERN = Pattern.compile("java\\.lang\\.Thread|.*\\$\\$Lambda\\$.*");
    private int nextClassId = -16;
    private int nextObjectId = 16;
    private final IdentityHashMap<Class, ObjectWriter> classMap = new IdentityHashMap();
    private final Queue<ObjectWriter> classQueue = new LinkedList<ObjectWriter>();
    private final IdentityHashMap<Object, Integer> objectMap = new IdentityHashMap();
    private final Queue<Object> objectQueue = new LinkedList<Object>();

    public DebugDumpImpl() {
        this.classMap.put(boolean[].class, new ObjectWriter(-2));
        this.classMap.put(byte[].class, new ObjectWriter(-3));
        this.classMap.put(short[].class, new ObjectWriter(-4));
        this.classMap.put(char[].class, new ObjectWriter(-5));
        this.classMap.put(int[].class, new ObjectWriter(-6));
        this.classMap.put(long[].class, new ObjectWriter(-7));
        this.classMap.put(float[].class, new ObjectWriter(-8));
        this.classMap.put(double[].class, new ObjectWriter(-9));
        this.classMap.put(String.class, new ObjectWriter(-1));
    }

    public static void makeDump(final String file, final Object owner) {
        Exec.EXEC.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    new DebugDumpImpl().makeDump(file, owner, null);
                }
                catch (Throwable t) {
                    log.error("Failed to dump to " + LogUtil.hideCredentials((Object)file), t);
                }
            }
        });
    }

    public void makeDump(String file, Object owner, Throwable t) throws IOException {
        log.info("Dumping objects in internal format to '" + LogUtil.hideCredentials((Object)file));
        this.putObject(owner, 1);
        this.putObject(QDFactory.getVersion(), 2);
        try {
            this.putObject(System.getProperties(), 3);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (t != null) {
            t.getStackTrace();
        }
        this.putObject(t, 4);
        this.dump(file);
        log.info("Debug dump completed");
    }

    private void dump(String file) throws IOException {
        try (StreamOutput out = new StreamOutput((OutputStream)new DeflaterOutputStream(new FileOutputStream(file)));){
            this.dump((BufferedOutput)out);
        }
    }

    private void dump(BufferedOutput out) throws IOException {
        int cnt = 0;
        while (!this.objectQueue.isEmpty()) {
            this.dumpObject(out, this.objectQueue.poll());
            ++cnt;
            this.processClassQueue(out);
        }
        log.info("Dumping done, written " + cnt + " object instances");
    }

    private void processClassQueue(BufferedOutput out) throws IOException {
        while (!this.classQueue.isEmpty()) {
            this.classQueue.poll().writeClass(out);
        }
    }

    private ObjectWriter defineClass(BufferedOutput out, Class clazz) throws IOException {
        if (clazz == null) {
            return null;
        }
        if (this.classMap.containsKey(clazz)) {
            return this.classMap.get(clazz);
        }
        if (clazz.isArray()) {
            return this.defineArrayClass(out, clazz);
        }
        String name = clazz.getName();
        if (!DUMP_CLASS_PATTERN.matcher(name).matches() || EXCLUDE_CLASS_PATTERN.matcher(name).matches()) {
            log.info("Skipped class " + name);
            ObjectWriter result = this.defineClass(out, clazz.getSuperclass());
            this.classMap.put(clazz, result);
            return result;
        }
        return this.defineRegularClass(out, clazz);
    }

    private ObjectWriter defineArrayClass(BufferedOutput out, Class clazz) throws IOException {
        ObjectWriter component = this.defineClass(out, clazz.getComponentType());
        int classId = this.nextClassId--;
        log.info("Dumping array description " + classId + " " + clazz.getName());
        ArrayDesc desc = new ArrayDesc(classId, component);
        this.classMap.put(clazz, desc);
        this.classQueue.add(desc);
        return desc;
    }

    private ObjectWriter defineRegularClass(BufferedOutput out, Class clazz) throws IOException {
        ClassDesc parent = (ClassDesc)this.defineClass(out, clazz.getSuperclass());
        int classId = this.nextClassId--;
        log.info("Dumping class description " + classId + " " + clazz.getName());
        ClassDesc desc = new ClassDesc(classId, clazz.getName(), parent);
        this.classMap.put(clazz, desc);
        for (Field f : clazz.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers()) || f.getAnnotation(DebugDumpExclude.class) != null) continue;
            f.setAccessible(true);
            int type = this.fieldClassToSerialType(f.getType());
            desc.fields.add(new FieldDesc(f, type));
        }
        this.classQueue.add(desc);
        return desc;
    }

    private void dumpObject(BufferedOutput out, Object obj) throws IOException {
        Class<?> clazz = obj.getClass();
        ObjectWriter writer = this.defineClass(out, clazz);
        this.processClassQueue(out);
        out.writeCompactInt(this.objectMap.get(obj).intValue());
        if (writer == null) {
            out.writeCompactInt(0);
            out.writeUTFString(obj.toString());
        } else {
            out.writeCompactInt(writer.classId);
            writer.writeObject(out, obj);
        }
    }

    private int fieldClassToSerialType(Class clazz) {
        if (clazz == Boolean.TYPE) {
            return -2;
        }
        if (clazz == Byte.TYPE) {
            return -3;
        }
        if (clazz == Short.TYPE) {
            return -4;
        }
        if (clazz == Character.TYPE) {
            return -5;
        }
        if (clazz == Integer.TYPE) {
            return -6;
        }
        if (clazz == Long.TYPE) {
            return -7;
        }
        if (clazz == Float.TYPE) {
            return -8;
        }
        if (clazz == Double.TYPE) {
            return -9;
        }
        return 0;
    }

    private void writeTypedField(BufferedOutput out, int type, Object value) throws IOException {
        switch (type) {
            case 0: {
                this.writeObjectReference(out, value);
                break;
            }
            case -2: {
                out.writeByte(value == null ? 0 : ((Boolean)value != false ? 1 : 0));
                break;
            }
            case -3: {
                out.writeByte(value == null ? 0 : (int)((Byte)value).byteValue());
                break;
            }
            case -4: {
                out.writeCompactInt(value == null ? 0 : (int)((Short)value).shortValue());
                break;
            }
            case -5: {
                out.writeUTFChar(value == null ? 0 : (int)((Character)value).charValue());
                break;
            }
            case -6: {
                out.writeCompactInt(value == null ? 0 : (Integer)value);
                break;
            }
            case -7: {
                out.writeCompactLong(value == null ? 0L : (Long)value);
                break;
            }
            case -8: {
                out.writeFloat(value == null ? 0.0f : ((Float)value).floatValue());
                break;
            }
            case -9: {
                out.writeDouble(value == null ? 0.0 : (Double)value);
            }
        }
    }

    private void writeObjectReference(BufferedOutput out, Object value) throws IOException {
        if (value instanceof Class) {
            ObjectWriter writer = this.defineClass(out, (Class)value);
            out.writeCompactInt(writer == null ? 0 : writer.classId);
        } else {
            out.writeCompactInt(this.addObject(value));
        }
    }

    public void putObject(Object obj, int objectId) {
        if (obj == null) {
            return;
        }
        this.objectMap.put(obj, objectId);
        this.objectQueue.add(obj);
    }

    private int addObject(Object obj) {
        if (obj == null) {
            return 0;
        }
        Integer id = this.objectMap.get(obj);
        if (id != null) {
            return id;
        }
        int objectId = this.nextObjectId++;
        this.putObject(obj, objectId);
        return objectId;
    }

    class ClassDesc
    extends ObjectWriter {
        final String name;
        final ClassDesc parent;
        final List<FieldDesc> fields;

        ClassDesc(int classId, String name, ClassDesc parent) {
            super(classId);
            this.fields = new ArrayList<FieldDesc>();
            this.name = name;
            this.parent = parent;
        }

        @Override
        void writeClass(BufferedOutput out) throws IOException {
            out.writeCompactInt(this.classId);
            out.writeUTFString(this.name);
            out.writeCompactInt(this.parent == null ? 0 : this.parent.classId);
            out.writeCompactInt(this.fields.size());
            for (FieldDesc fd : this.fields) {
                out.writeUTFString(fd.field.getName());
                out.writeCompactInt(fd.type);
            }
        }

        @Override
        void writeObject(BufferedOutput out, Object obj) throws IOException {
            ClassDesc cur = this;
            do {
                for (FieldDesc fd : cur.fields) {
                    DebugDumpImpl.this.writeTypedField(out, fd.type, fd.getValue(obj));
                }
            } while ((cur = cur.parent) != null);
        }
    }

    static final class FieldDesc {
        final Field field;
        final int type;

        FieldDesc(Field field, int type) {
            this.field = field;
            this.type = type;
        }

        private Object getValue(Object obj) {
            try {
                return this.field.get(obj);
            }
            catch (IllegalAccessException e) {
                log.error("Cannot access " + this.field.getName() + " of " + this.field.getType().getName(), (Throwable)e);
                return null;
            }
        }

        public String toString() {
            return this.field.getName();
        }
    }

    class ArrayDesc
    extends ObjectWriter {
        final ObjectWriter component;

        ArrayDesc(int classId, ObjectWriter component) {
            super(classId);
            this.component = component;
        }

        @Override
        void writeClass(BufferedOutput out) throws IOException {
            out.writeCompactInt(this.classId);
            out.writeUTFString(null);
            out.writeCompactInt(this.component.classId);
        }

        @Override
        void writeObject(BufferedOutput out, Object value) throws IOException {
            if (value == null) {
                out.writeCompactInt(-1);
                return;
            }
            out.writeCompactInt(((Object[])value).length);
            for (Object o : (Object[])value) {
                DebugDumpImpl.this.writeObjectReference(out, o);
            }
        }
    }

    class ObjectWriter {
        final int classId;

        ObjectWriter(int classId) {
            this.classId = classId;
        }

        void writeClass(BufferedOutput out) throws IOException {
        }

        void writeObject(BufferedOutput out, Object value) throws IOException {
            switch (this.classId) {
                case -1: {
                    out.writeUTFString((String)value);
                    break;
                }
                case -2: {
                    out.writeCompactInt(((boolean[])value).length);
                    for (boolean b : (boolean[])value) {
                        out.writeByte(b ? 1 : 0);
                    }
                    break;
                }
                case -3: {
                    out.writeCompactInt(((byte[])value).length);
                    for (byte b : (byte[])value) {
                        out.writeByte((int)b);
                    }
                    break;
                }
                case -4: {
                    out.writeCompactInt(((short[])value).length);
                    for (short i : (short[])value) {
                        out.writeCompactInt((int)i);
                    }
                    break;
                }
                case -5: {
                    out.writeCompactInt(((char[])value).length);
                    for (char c : (char[])value) {
                        out.writeUTFChar((int)c);
                    }
                    break;
                }
                case -6: {
                    out.writeCompactInt(((int[])value).length);
                    for (int i : (int[])value) {
                        out.writeCompactInt(i);
                    }
                    break;
                }
                case -7: {
                    out.writeCompactInt(((long[])value).length);
                    for (long i : (long[])value) {
                        out.writeCompactLong(i);
                    }
                    break;
                }
                case -8: {
                    out.writeCompactInt(((float[])value).length);
                    for (float x : (float[])value) {
                        out.writeFloat(x);
                    }
                    break;
                }
                case -9: {
                    out.writeCompactInt(((double[])value).length);
                    for (double x : (double[])value) {
                        out.writeDouble(x);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("classId=" + this.classId);
                }
            }
        }
    }
}

