/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix.management.dump;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;

public class TrackingInput
extends InputStream {
    private static final PrintStream PS = System.out;
    private final RandomAccessFile file;
    private final long length;
    private int percent;

    public TrackingInput(RandomAccessFile file) throws IOException {
        this.file = file;
        this.length = file.length();
        PS.printf("Reading %d bytes: ", this.length);
    }

    @Override
    public int read() throws IOException {
        int read = this.file.read();
        if (read >= 0) {
            this.update();
        }
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.file.read(b, off, len);
        if (read > 0) {
            this.update();
        }
        return read;
    }

    @Override
    public void close() throws IOException {
        this.file.close();
        PS.println(" done");
    }

    private void update() throws IOException {
        long p = this.file.getFilePointer() * 100L / this.length;
        while ((long)this.percent < p) {
            PS.print(".");
            ++this.percent;
            if (this.percent % 10 != 0) continue;
            PS.print(this.percent + "%");
        }
    }
}

