/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix.management.impl;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.impl.matrix.management.CollectorCounters;
import com.devexperts.qd.impl.matrix.management.CollectorOperation;
import com.devexperts.qd.impl.matrix.management.RecordCounters;
import com.devexperts.qd.impl.matrix.management.impl.LockCounters;
import com.devexperts.qd.impl.matrix.management.impl.ReportBuilder;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class CollectorCountersImpl
extends CollectorCounters {
    private static final CollectorOperation[] OPS = CollectorOperation.values();
    private static final int N_OPS = OPS.length;
    private static final long UNKNOWN = -1L;
    static final int TOP_N = 5;
    private final DataScheme scheme;
    private long milliseconds;
    private int numberAdded;
    private final AtomicLong distributions = new AtomicLong();
    private final AtomicLongArray distributionIncomingRecords;
    private final AtomicLongArray distributionOutgoingRecords;
    private final AtomicLong distributionSpins = new AtomicLong();
    private final AtomicLong droppedRecords = new AtomicLong();
    private final AtomicLong retrievals = new AtomicLong();
    private final AtomicLong retrievedRecords = new AtomicLong();
    private volatile long distributionIncomingRecordsSum = -1L;
    private volatile long distributionOutgoingRecordsSum = -1L;
    private final AtomicReferenceArray<LockCounters> lockCountersGlobal = new AtomicReferenceArray(N_OPS);
    private static final ThreadLocal<NumberFormat> NUMBER_FORMAT = new ThreadLocal();

    public static String getAllLockOperations() {
        StringBuilder sb = new StringBuilder();
        for (CollectorOperation op : OPS) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(op);
        }
        return sb.toString();
    }

    public CollectorCountersImpl(DataScheme scheme, long milliseconds, int numberAdded) {
        this.scheme = scheme;
        this.milliseconds = milliseconds;
        this.numberAdded = numberAdded;
        int n = scheme.getRecordCount();
        this.distributionIncomingRecords = new AtomicLongArray(n);
        this.distributionOutgoingRecords = new AtomicLongArray(n);
    }

    public CollectorCountersImpl(DataScheme scheme) {
        this(scheme, System.currentTimeMillis(), 0);
    }

    public CollectorCountersImpl(CollectorCountersImpl other) {
        this(other.scheme, 0L, 0);
        this.add(other);
    }

    public CollectorCountersImpl(CollectorCountersImpl cur, CollectorCountersImpl old) {
        this(cur.scheme, cur.getMilliseconds() - old.getMilliseconds(), 1);
        this.distributions.set(cur.distributions.get() - old.distributions.get());
        CollectorCountersImpl.setDiff(this.distributionIncomingRecords, cur.distributionIncomingRecords, old.distributionIncomingRecords);
        CollectorCountersImpl.setDiff(this.distributionOutgoingRecords, cur.distributionOutgoingRecords, old.distributionOutgoingRecords);
        this.distributionSpins.set(cur.distributionSpins.get() - old.distributionSpins.get());
        this.droppedRecords.set(cur.droppedRecords.get() - old.droppedRecords.get());
        this.retrievals.set(cur.retrievals.get() - old.retrievals.get());
        this.retrievedRecords.set(cur.retrievedRecords.get() - old.retrievedRecords.get());
        for (int i = 0; i < N_OPS; ++i) {
            LockCounters curCounters = cur.lockCountersGlobal.get(i);
            if (curCounters == null) continue;
            LockCounters oldCounters = old.lockCountersGlobal.get(i);
            if (oldCounters != null) {
                this.lockCountersGlobal.set(i, new LockCounters(curCounters, oldCounters));
                continue;
            }
            this.lockCountersGlobal.set(i, new LockCounters(curCounters));
        }
    }

    private static void setDiff(AtomicLongArray a, AtomicLongArray cur, AtomicLongArray old) {
        int n = a.length();
        for (int i = 0; i < n; ++i) {
            a.set(i, cur.get(i) - old.get(i));
        }
    }

    public CollectorCounters snapshot() {
        return new CollectorCountersImpl(this);
    }

    public CollectorCounters since(CollectorCounters snapshot) {
        return snapshot == null ? this : new CollectorCountersImpl(this, (CollectorCountersImpl)snapshot);
    }

    public long getMilliseconds() {
        return this.numberAdded > 0 ? this.milliseconds / (long)this.numberAdded : System.currentTimeMillis() - this.milliseconds;
    }

    public long getDistributions() {
        return this.distributions.get();
    }

    public long getDistributionIncomingRecords() {
        long sum = this.distributionIncomingRecordsSum;
        if (sum != -1L) {
            return sum;
        }
        this.distributionIncomingRecordsSum = CollectorCountersImpl.sum(this.distributionIncomingRecords);
        return this.distributionIncomingRecordsSum;
    }

    public long getDistributionOutgoingRecords() {
        long sum = this.distributionOutgoingRecordsSum;
        if (sum != -1L) {
            return sum;
        }
        this.distributionOutgoingRecordsSum = CollectorCountersImpl.sum(this.distributionOutgoingRecords);
        return this.distributionOutgoingRecordsSum;
    }

    public long getDistributionSpins() {
        return this.distributionSpins.get();
    }

    public long getDroppedRecords() {
        return this.droppedRecords.get();
    }

    public long getRetrievals() {
        return this.retrievals.get();
    }

    public long getRetrievedRecords() {
        return this.retrievedRecords.get();
    }

    public double getAverageDistributionIncomingRecords() {
        return (double)this.getDistributionIncomingRecords() / (double)this.getDistributions();
    }

    public double getAverageDistributionFanoutRecords() {
        return (double)this.getDistributionOutgoingRecords() / (double)this.getDistributionIncomingRecords();
    }

    public double getAverageDistributionSpins() {
        return (double)this.getDistributionSpins() / (double)this.getDistributions();
    }

    public double getAverageDistributionIncomingRecordsPerSecond() {
        return (double)this.getDistributionIncomingRecords() * 1000.0 / (double)this.getMilliseconds();
    }

    public double getAverageDistributionOutgoingRecordsPerSecond() {
        return (double)this.getDistributionOutgoingRecords() * 1000.0 / (double)this.getMilliseconds();
    }

    public double getAverageRetrievedRecords() {
        return (double)this.getRetrievedRecords() / (double)this.getRetrievals();
    }

    public double getAverageRetrievedRecordsFraction() {
        return (double)this.getRetrievedRecords() / (double)this.getDistributionOutgoingRecords();
    }

    public double getAverageRetrievedRecordsPerSecond() {
        return (double)this.getRetrievedRecords() * 1000.0 / (double)this.getMilliseconds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockCounters lockCountersGlobal(CollectorOperation op) {
        LockCounters result = this.lockCountersGlobal.get(op.ordinal());
        if (result == null) {
            AtomicReferenceArray<LockCounters> atomicReferenceArray = this.lockCountersGlobal;
            synchronized (atomicReferenceArray) {
                result = this.lockCountersGlobal.get(op.ordinal());
                if (result == null) {
                    result = new LockCounters();
                    this.lockCountersGlobal.set(op.ordinal(), result);
                }
            }
        }
        return result;
    }

    public void countLock(CollectorOperation op, long waitNanos, long lockNanos) {
        this.lockCountersGlobal(op).countLock(waitNanos, lockNanos);
    }

    public void countDistributionAndClear(RecordCounters incoming, RecordCounters outgoing, int spins) {
        this.distributions.incrementAndGet();
        this.distributionSpins.addAndGet(spins);
        if (incoming.flushAndClear(this.distributionIncomingRecords)) {
            this.distributionIncomingRecordsSum = -1L;
        }
        if (outgoing.flushAndClear(this.distributionOutgoingRecords)) {
            this.distributionOutgoingRecordsSum = -1L;
        }
    }

    public void countRetrieval(int records) {
        this.retrievals.incrementAndGet();
        this.retrievedRecords.addAndGet(records);
    }

    public void countDropped(int records) {
        this.droppedRecords.addAndGet(records);
    }

    public void add(CollectorCountersImpl other) {
        this.milliseconds += other.getMilliseconds();
        ++this.numberAdded;
        this.distributions.getAndAdd(other.distributions.get());
        CollectorCountersImpl.add(this.distributionIncomingRecords, other.distributionIncomingRecords);
        CollectorCountersImpl.add(this.distributionOutgoingRecords, other.distributionOutgoingRecords);
        this.distributionSpins.getAndAdd(other.distributionSpins.get());
        this.droppedRecords.getAndAdd(other.droppedRecords.get());
        this.retrievals.getAndAdd(other.retrievals.get());
        this.retrievedRecords.getAndAdd(other.retrievedRecords.get());
        for (int i = 0; i < N_OPS; ++i) {
            LockCounters otherCounters = other.lockCountersGlobal.get(i);
            if (otherCounters == null) continue;
            LockCounters thisCounters = this.lockCountersGlobal(OPS[i]);
            thisCounters.add(otherCounters);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        long millis = this.getMilliseconds();
        sb.append(this.fmtHeader(millis)).append(": ");
        sb.append(this.fmtDist()).append("; ");
        sb.append(this.fmtRetrieve());
        String glockStr = this.fmtLockCountersGlobal(millis);
        if (glockStr.length() > 0) {
            sb.append("; GLOCK[").append(glockStr).append("]");
        }
        this.fmtTopRpsTo(sb, "IN", this.distributionIncomingRecords, millis, 5);
        this.fmtTopRpsTo(sb, "OUT", this.distributionOutgoingRecords, millis, 5);
        return sb.toString();
    }

    public ReportBuilder reportTo(ReportBuilder rb, String name, int topSize) {
        long millis = this.getMilliseconds();
        rb.header(this.fmtHeader(millis) + (name == null ? "" : " on " + name), 1);
        rb.message(this.fmtDist());
        rb.message(this.fmtRetrieve());
        rb.beginTable();
        rb.newRow().td("Op");
        LockCounters.reportHeaderTo(rb);
        for (int i = 0; i < N_OPS; ++i) {
            LockCounters counters = this.lockCountersGlobal.get(i);
            if (counters == null || counters.getLockTimes().getCount() == 0L) continue;
            rb.newRow().td(OPS[i]);
            counters.reportDataTo(rb, millis);
        }
        rb.endTable();
        this.reportTopRpsTo(rb, "IN", this.distributionIncomingRecords, millis, topSize);
        this.reportTopRpsTo(rb, "OUT", this.distributionOutgoingRecords, millis, topSize);
        return rb;
    }

    public String textReport() {
        return this.reportTo(new ReportBuilder("text"), null, 5).toString();
    }

    private String fmtHeader(long millis) {
        return "COUNTERS for " + CollectorCountersImpl.fmt((double)millis / 1000.0) + " sec";
    }

    private String fmtDist() {
        return "DIST[" + CollectorCountersImpl.fmt(this.getDistributions()) + "; AVG: in=" + CollectorCountersImpl.fmt(this.getAverageDistributionIncomingRecords()) + " fanout=" + CollectorCountersImpl.fmt(this.getAverageDistributionFanoutRecords()) + " spin=" + CollectorCountersImpl.fmt(this.getAverageDistributionSpins()) + "; RPS: in=" + CollectorCountersImpl.fmt(this.getAverageDistributionIncomingRecordsPerSecond()) + " out=" + CollectorCountersImpl.fmt(this.getAverageDistributionOutgoingRecordsPerSecond()) + "; DROPPED: " + CollectorCountersImpl.fmt(this.getDroppedRecords()) + "]";
    }

    private String fmtRetrieve() {
        return "RETRIEVE[" + CollectorCountersImpl.fmt(this.getRetrievals()) + "; AVG: ret=" + CollectorCountersImpl.fmt(this.getAverageRetrievedRecords()) + " frac=" + CollectorCountersImpl.fmt(this.getAverageRetrievedRecordsFraction() * 100.0) + "%; RPS: ret=" + CollectorCountersImpl.fmt(this.getAverageRetrievedRecordsPerSecond()) + "]";
    }

    private String fmtLockCountersGlobal(long millis) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < N_OPS; ++i) {
            LockCounters counters = this.lockCountersGlobal.get(i);
            if (counters == null || counters.getLockTimes().getCount() == 0L) continue;
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(OPS[i]).append("=").append(counters.fmtString(millis));
        }
        return sb.toString();
    }

    private void fmtTopRpsTo(StringBuilder sb, String header, AtomicLongArray count, long millis, int topSize) {
        List<CountItem> list = CollectorCountersImpl.buildTopList(this.scheme, count, topSize);
        if (list.isEmpty()) {
            return;
        }
        sb.append("; TOP_RPS_").append(header).append('[');
        for (CountItem item : list) {
            sb.append(item.record).append('=').append(CollectorCountersImpl.fmt((double)item.count * 1000.0 / (double)millis)).append(' ');
        }
        sb.setCharAt(sb.length() - 1, ']');
    }

    private void reportTopRpsTo(ReportBuilder rb, String header, AtomicLongArray count, long millis, int topSize) {
        List<CountItem> list = CollectorCountersImpl.buildTopList(this.scheme, count, topSize);
        if (list.isEmpty()) {
            return;
        }
        rb.header("TOP RPS " + header, 2);
        rb.beginTable().newRow().td("Record").td("RPS").endTR();
        for (CountItem item : list) {
            rb.newRow().td(item.record).td(CollectorCountersImpl.fmt((double)item.count * 1000.0 / (double)millis)).endTR();
        }
        rb.endTable();
    }

    private static List<CountItem> buildTopList(DataScheme scheme, AtomicLongArray count, int topSize) {
        ArrayList<CountItem> list = new ArrayList<CountItem>();
        for (int i = 0; i < count.length(); ++i) {
            if (count.get(i) == 0L) continue;
            list.add(new CountItem(scheme.getRecord(i), count.get(i)));
        }
        Collections.sort(list);
        while (list.size() > topSize && !list.isEmpty()) {
            list.remove(list.size() - 1);
        }
        return list;
    }

    public static String reportCounters(DataScheme scheme, Map<String, AtomicLongArray> counters, String format, int topSize) {
        ReportBuilder rb = new ReportBuilder(format);
        for (String header : counters.keySet()) {
            AtomicLongArray count = counters.get(header);
            List<CountItem> list = CollectorCountersImpl.buildTopList(scheme, count, topSize);
            if (list.isEmpty()) continue;
            rb.header(header, 2);
            rb.beginTable().newRow().td("Record").td("Count").endTR();
            for (CountItem item : list) {
                rb.newRow().td(item.record).td(item.count).endTR();
            }
            rb.endTable();
        }
        return rb.toString();
    }

    private static String fmt(double d) {
        if (Double.isNaN(d)) {
            return "0";
        }
        d = d >= 99.95 ? Math.floor(d + 0.5) : (d >= 9.995 ? Math.floor(d * 10.0 + 0.5) / 10.0 : Math.floor(d * 100.0 + 0.5) / 100.0);
        NumberFormat nf = NUMBER_FORMAT.get();
        if (nf == null) {
            nf = NumberFormat.getInstance(Locale.US);
            nf.setMaximumFractionDigits(2);
            NUMBER_FORMAT.set(nf);
        }
        return nf.format(d);
    }

    private static long sum(AtomicLongArray arr) {
        long sum = 0L;
        int n = arr.length();
        for (int i = 0; i < n; ++i) {
            sum += arr.get(i);
        }
        return sum;
    }

    private static void add(AtomicLongArray cur, AtomicLongArray old) {
        int n = cur.length();
        for (int i = 0; i < n; ++i) {
            cur.getAndAdd(i, old.get(i));
        }
    }

    private static class CountItem
    implements Comparable<CountItem> {
        final String record;
        final long count;

        CountItem(DataRecord record, long count) {
            this.record = record.getName();
            this.count = count;
        }

        @Override
        public int compareTo(CountItem o) {
            return this.count > o.count ? -1 : (this.count < o.count ? 1 : this.record.compareTo(o.record));
        }
    }
}

