/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix.management.impl;

import com.devexperts.io.BufferedOutput;
import com.devexperts.io.StreamOutput;
import com.devexperts.logging.Logging;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDFactory;
import com.devexperts.qd.SymbolCodec;
import com.devexperts.qd.impl.matrix.Collector;
import com.devexperts.qd.impl.matrix.SubscriptionDumpVisitor;
import com.devexperts.qd.impl.matrix.management.impl.Exec;
import com.devexperts.util.LogUtil;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class SubscriptionDumpImpl
implements SubscriptionDumpVisitor {
    private static final Logging log = Logging.getLogging(SubscriptionDumpImpl.class);
    private final DataScheme scheme;
    private final SymbolCodec codec;
    private final SymbolCodec.Writer symbolWriter;
    private final BufferedOutput out;
    private final boolean[] seenRecords;

    public static void makeDump(final String file, final DataScheme scheme, final List<Collector> list) {
        Exec.EXEC.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    SubscriptionDumpImpl.makeDumpImpl(file, scheme, list);
                }
                catch (Throwable t) {
                    log.error("Failed to dump subscription to " + LogUtil.hideCredentials((Object)file), t);
                }
            }
        });
    }

    private static void makeDumpImpl(String file, DataScheme scheme, List<Collector> list) throws IOException {
        log.info("Dumping subscription for " + list.size() + " collector(s) to " + LogUtil.hideCredentials((Object)file));
        try (StreamOutput out = new StreamOutput((OutputStream)new FileOutputStream(file), 100000);){
            SubscriptionDumpImpl visitor = new SubscriptionDumpImpl(scheme, (BufferedOutput)out);
            visitor.writeHeader();
            for (Collector collector : list) {
                collector.dumpSubscription((SubscriptionDumpVisitor)visitor);
            }
            visitor.writeEndOfFile();
        }
        log.info("Subscription dump completed");
    }

    private SubscriptionDumpImpl(DataScheme scheme, BufferedOutput out) {
        this.scheme = scheme;
        this.codec = scheme.getCodec();
        this.symbolWriter = this.codec.createWriter();
        this.out = out;
        this.seenRecords = new boolean[scheme.getRecordCount()];
    }

    private void writeHeader() throws IOException {
        this.out.write(MAGIC);
        this.out.writeCompactInt(2);
        this.out.writeCompactLong(System.currentTimeMillis());
        this.out.writeUTFString(QDFactory.getVersion());
        this.out.writeUTFString(this.scheme.getClass().getName());
        this.out.writeUTFString(this.codec.getClass().getName());
    }

    private void writeEndOfFile() throws IOException {
        this.out.writeCompactInt(-1);
    }

    public void visitCollector(int id, String keyProperties, String contract, boolean hasTime) throws IOException {
        this.out.writeCompactInt(id == -1 ? 0 : id);
        this.out.writeUTFString(keyProperties);
        this.out.writeUTFString(contract);
        this.out.writeBoolean(hasTime);
    }

    public void visitRecord(DataRecord record) throws IOException {
        int rid = record.getId();
        if (!this.seenRecords[rid]) {
            this.out.writeCompactInt(-rid - 2);
            this.out.writeUTFString(record.getName());
            this.seenRecords[rid] = true;
        } else {
            this.out.writeCompactInt(rid);
        }
    }

    public void visitSymbol(int cipher, String symbol) throws IOException {
        this.symbolWriter.writeSymbol(this.out, cipher, symbol, 0);
    }

    public void visitAgentNew(int aid, String keyProperties) throws IOException {
        assert (aid >= 0);
        this.out.writeCompactInt(-aid - 2);
        this.out.writeUTFString(keyProperties);
    }

    public void visitAgentAgain(int aid) throws IOException {
        assert (aid >= 0);
        this.out.writeCompactInt(aid);
    }

    public void visitTime(int t0, int t1) throws IOException {
        this.out.writeCompactInt(t0);
        this.out.writeCompactInt(t1);
    }

    public void visitEndOfChain() throws IOException {
        this.out.writeCompactInt(-1);
    }

    public void visitEndOfCollector() throws IOException {
        this.out.writeCompactInt(-1);
    }
}

