/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.monitoring;

import com.devexperts.logging.Logging;
import com.devexperts.qd.monitoring.JmxConnector;
import com.devexperts.util.SynchronizedIndexedSet;

class JmxConnectors {
    private static final Logging log = Logging.getLogging(JmxConnectors.class);
    private static final SynchronizedIndexedSet<Integer, JmxConnector> JMX_CONNECTORS = SynchronizedIndexedSet.createInt(JmxConnector::getPort);

    private JmxConnectors() {
    }

    static boolean isPortAvailable(Integer port) {
        return port != null && !JMX_CONNECTORS.containsKey((Object)port);
    }

    static boolean addConnector(JmxConnector connector) {
        return JMX_CONNECTORS.putIfAbsentAndGet((Object)connector) == connector;
    }

    static void removeConnector(JmxConnector connector) {
        JMX_CONNECTORS.remove((Object)connector);
    }

    static void stopConnectors() {
        JmxConnector[] values;
        for (JmxConnector connector : values = (JmxConnector[])JMX_CONNECTORS.toArray((Object[])new JmxConnector[JMX_CONNECTORS.size()])) {
            try {
                connector.stop();
            }
            catch (Exception e) {
                log.error("Failed to stop JMX connector " + connector, (Throwable)e);
            }
        }
    }
}

