/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.monitoring;

import com.devexperts.qd.QDCollector;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.impl.AbstractCollector;
import com.devexperts.qd.impl.matrix.Collector;
import com.devexperts.qd.impl.matrix.management.CollectorCounters;
import com.devexperts.qd.monitoring.MonitoringEndpoint;
import com.devexperts.qd.qtp.MessageConnector;
import com.devexperts.qd.qtp.QDEndpoint;
import com.devexperts.services.ServiceProvider;
import com.devexperts.util.SystemProperties;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class MonitoredQDEndpoint
extends QDEndpoint {
    private static final boolean LOG_COLLECTOR_COUNTERS = SystemProperties.getBooleanProperty(MonitoredQDEndpoint.class, (String)"logCollectorCounters", (boolean)false);
    private final MonitoringEndpoint monitoringEndpoint;
    private Runnable logConnectorCountersTask;
    private EnumMap<QDContract, CollectorCounters> lastCounters;

    @Deprecated
    protected MonitoredQDEndpoint(MonitoringEndpoint monitoringEndpoint, List<QDCollector.Factory> collectors, boolean withEventTimeSequence, boolean storeEverything) {
        this(new BuilderImpl().withName(monitoringEndpoint.getName()).withScheme(monitoringEndpoint.getScheme()).withCollectors(collectors).withEventTimeSequence(withEventTimeSequence).withStoreEverything(storeEverything), monitoringEndpoint);
    }

    protected MonitoredQDEndpoint(QDEndpoint.Builder builder, MonitoringEndpoint monitoringEndpoint) {
        super(builder, monitoringEndpoint.getRootStats());
        this.monitoringEndpoint = monitoringEndpoint;
        for (QDCollector collector : this.getCollectors()) {
            if (!(collector instanceof AbstractCollector)) continue;
            ((AbstractCollector)collector).setDroppedLog(monitoringEndpoint.droppedLogAccept());
        }
        if (LOG_COLLECTOR_COUNTERS) {
            this.lastCounters = new EnumMap(QDContract.class);
            this.logConnectorCountersTask = new Runnable(){

                @Override
                public void run() {
                    MonitoredQDEndpoint.this.logCollectorCounters();
                }
            };
            monitoringEndpoint.registerMonitoringTask(this.logConnectorCountersTask);
        }
    }

    public Map<String, String> getDescriptorProperties() {
        return this.monitoringEndpoint.getDescriptorProperties();
    }

    protected void addConnectorsImpl(Collection<MessageConnector> connectors) {
        super.addConnectorsImpl(connectors);
        this.monitoringEndpoint.addConnectors(connectors);
    }

    protected void removeConnectorsImpl(Collection<MessageConnector> connectors) {
        this.monitoringEndpoint.removeConnectors(connectors);
        super.removeConnectorsImpl(connectors);
    }

    protected void cleanupConnectorsImpl(Collection<MessageConnector> connectors) {
        this.monitoringEndpoint.removeConnectors(connectors);
        super.cleanupConnectorsImpl(connectors);
    }

    protected void closeImpl() {
        super.closeImpl();
        if (this.logConnectorCountersTask != null) {
            this.monitoringEndpoint.unregisterMonitoringTask(this.logConnectorCountersTask);
        }
        this.monitoringEndpoint.release();
    }

    public void registerMonitoringTask(Runnable task) {
        this.monitoringEndpoint.registerMonitoringTask(task);
    }

    private void logCollectorCounters() {
        for (QDContract contract : QDContract.values()) {
            QDCollector collector = this.getCollector(contract);
            if (!(collector instanceof Collector)) continue;
            CollectorCounters counters = ((Collector)collector).getCountersSinceStart();
            CollectorCounters delta = counters.since(this.lastCounters.get(contract));
            this.lastCounters.put(contract, counters);
            String text = delta.textReport().replaceAll("\\r?\\n", "\n    ");
            this.log.info("\b{" + collector + "} " + text);
        }
    }

    @ServiceProvider
    public static class BuilderImpl
    extends QDEndpoint.Builder {
        private final MonitoringEndpoint.Builder monitoringEndpointBuilder = MonitoringEndpoint.newBuilder();

        public boolean supportsProperty(String key) {
            return super.supportsProperty(key) || this.monitoringEndpointBuilder.supportsProperty(key);
        }

        public QDEndpoint build() {
            MonitoringEndpoint monitoringEndpoint = this.monitoringEndpointBuilder.withScheme(this.getSchemeOrDefault()).withProperties(this.props).acquire();
            MonitoredQDEndpoint endpoint = new MonitoredQDEndpoint(this, monitoringEndpoint);
            this.subscribe(endpoint);
            return endpoint;
        }
    }
}

