/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.monitoring;

import com.devexperts.qd.DataScheme;
import com.devexperts.qd.stats.QDStats;
import java.util.Arrays;

class SumDeltaCounter {
    private static final long[] EMPTY = new long[0];
    final QDStats.SValue statValue;
    long totalDelta;
    long[] recordDelta = EMPTY;

    SumDeltaCounter(QDStats.SValue statValue) {
        this.statValue = statValue;
    }

    void clear() {
        this.totalDelta = 0L;
    }

    void clearRid(int recordCount) {
        if (this.statValue.isRid()) {
            if (recordCount == 0) {
                this.recordDelta = EMPTY;
            } else if (this.recordDelta.length != recordCount) {
                this.recordDelta = new long[recordCount];
            } else {
                Arrays.fill(this.recordDelta, 0L);
            }
        }
    }

    int findMaxRecord() {
        long max = this.totalDelta / 100L;
        if (max <= 0L) {
            return -1;
        }
        int index = -1;
        for (int i = 0; i < this.recordDelta.length; ++i) {
            if (this.recordDelta[i] <= max) continue;
            max = this.recordDelta[i];
            index = i;
        }
        return index;
    }

    String formatMax(DataScheme scheme, StringBuilder buff, String name, int index, String sep) {
        if (index < 0 || this.totalDelta <= 0L) {
            return sep;
        }
        int v = Math.min(100, (int)(this.recordDelta[index] * 100L / this.totalDelta));
        buff.append(sep).append(name).append(' ').append(scheme.getRecord(index).getName()).append(": ").append(v).append("%");
        return "; ";
    }
}

