/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix.management.impl;

import com.devexperts.annotation.Description;
import com.devexperts.qd.QDContract;

@Description(value="Management interface for core QD collectors.")
public interface CollectorMXBean {
    @Description(value="Number of managed collector instances")
    public int getCollectorCount();

    @Description(value="Contract name")
    public QDContract getContract();

    public void resetToDefaults();

    @Description(value="Size of the bucket (in records) for one phase of subscription change operation")
    public int getSubscriptionBucket();

    public void setSubscriptionBucket(int var1);

    @Description(value="Size of the bucket (in records) for one phase of distribution operation")
    public int getDistributionBucket();

    public void setDistributionBucket(int var1);

    @Description(value="Number of concurrent scans of subscription structure during distribution")
    public int getInterleave();

    public void setInterleave(int var1);

    @Description(value="Default size of agent buffer")
    public int getAgentBufferSizeDefault();

    public void setAgentBufferSizeDefault(int var1);

    @Description(value="Maximal number of tryLock spins during distribution before waiting for local lock")
    public int getMaxDistributionSpins();

    public void setMaxDistributionSpins(int var1);

    @Description(value="Duration between logging messages about buffer overflow")
    public String getBufferOverflowLogInterval();

    public void setBufferOverflowLogInterval(String var1);

    @Description(value="Duration before logging that global lock is taking too long")
    public String getLockWaitLogInterval();

    public void setLockWaitLogInterval(String var1);

    @Description(value="Regexp of operations that have global lock priority")
    public String getUseLockPriority();

    public void setUseLockPriority(String var1);

    @Description(value="Regexp of operations that count global locks and time inside the lock")
    public String getUseLockCounters();

    public void setUseLockCounters(String var1);

    @Description(value="A list of all operations that require global lock")
    public String getAllLockOperations();

    @Description(value="Non-empty when fatal error had happened inside core processing methods")
    public String getFatalError();

    @Description(value="Performance counters since last reset")
    public String getCounters();

    @Description(value="Reports performance counters since last reset")
    public String reportCounters(@Description(name="format", value="html (default) or csv") String var1, @Description(name="topSize", value="max size of TOP tables, 5 by default") Integer var2);

    @Description(value="Resets performance counters")
    public void resetCounters();

    @Description(value="Dumps detailed information about all subscriptions to the file in QDSD format.")
    public void dumpSubscriptionToFile(@Description(name="file", value="the name of the file") String var1);

    @Description(value="Dumps detailed information about subscription to the file, read it with com.devexperts.qd.impl.matrix.management.dump.DebugDumpReader class")
    public void dumpCollectorsToFile(@Description(name="file", value="the name of the file") String var1);

    @Description(value="Verifies consistency of internal collector data structures (see log for verification report)")
    public void verifyCollectors();

    @Description(value="Reports stored snapshot data")
    public String reportData(@Description(name="recordName", value="the name of the record (use * for all)") String var1, @Description(name="symbol", value="the symbol (use * for all)") String var2, @Description(name="boundsOnly", value="true to report only first and last rows from history") boolean var3, @Description(name="format", value="html (default), csv, or text") String var4);

    @Description(value="Reports subscription")
    public String reportSubscription(@Description(name="recordName", value="the name of the record (use * for all)") String var1, @Description(name="symbol", value="the symbol (use * for all)") String var2, @Description(name="format", value="html (default), csv, or text") String var3);

    @Description(value="Sticky subscription period")
    public String getStickySubscriptionPeriod();

    @Description(value="Set sticky subscription period")
    public String applyStickySubscriptionPeriod(@Description(name="regexp", value="apply a sticky period if the regexp matches the name of the collector") String var1, @Description(name="period", value="in ,{@link com.devexperts.util.TimePeriod}, format") String var2);

    @Description(value="Get a log interval for sticky subscription processing")
    public String getStickySubscriptionLogInterval();

    @Description(value="Set a log interval for sticky subscription processing")
    public void setStickySubscriptionLogInterval(@Description(name="interval", value="in ,{@link com.devexperts.util.TimePeriod}, format") String var1);

    @Description(value="Get the minimum delay between scheduler calls to clear subscriptions")
    public long getStickyScheduleMinDelay();

    @Description(value="Set the minimum delay between scheduler calls to clear subscriptions")
    public void setStickyScheduleMinDelay(@Description(name="delay", value="im milliseconds") long var1);
}

